/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

typedef enum {
	MODBUS_MODE_NONE = 0,
	MODBUS_MODE_SER_485,
	MODBUS_MODE_ETH_TCP,
	MODBUS_MODE_ETH_UDP
}
modbus_mode_t;

typedef struct {
	int ser_initialized;
	int eth_initialized;
	modbus_mode_t mode;
	int dev_adr;
	HANDLE ser_handle;
	SOCKET eth_socket;
}
modbus_t;

/* calculate the CRC16 */
int modbus_calc_crc16(unsigned char *p_buf, unsigned short num_byte, unsigned char *p_crc_lo, unsigned char *p_crc_hi);

/* send MODBUS request and wait for reply or timeout */
int modbus_transfer(modbus_t *p_modbus, int dev_cmd, int skip_tx, unsigned char *p_tx, int num_tx, unsigned char *p_rx, int num_rx);

/* read a group of MODBUS registers */
int modbus_reg_rd_group(modbus_t *p_modbus, int reg_adr, int num_reg, int *p_reg_val, int has_sign);

/* write a group of MODBUS registers */
int modbus_reg_wr_group(modbus_t *p_modbus, int reg_adr, int num_reg, int *p_reg_val);

/* write a single MODBUS register */
int modbus_reg_wr_single(modbus_t *p_modbus, int reg_adr, int reg_val);

/* initialize data structures */
int modbus_init(modbus_t *p_modbus);

/* open serial port and set communication parameters */
int modbus_open_ser(modbus_t *p_modbus, LPCWSTR p_port);

/* open ethernet port and set communication parameters */
int modbus_open_eth(modbus_t *p_modbus, char *p_board_ip_address, char *p_board_port_number);

/* close serial port */
int modbus_close_ser(modbus_t *p_modbus);

/* close ethernet port */
int modbus_close_eth(modbus_t *p_modbus);

/* select communication port */
int modbus_sel_mode(modbus_t *p_modbus, modbus_mode_t mode);

/* select device addres */
int modbus_sel_addr(modbus_t *p_modbus, int addr);

/* file ends here */
