/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "main_app.h"
#include "modbus.h"
#include "dev_ltic1ch-d1-4.h"
#include "menu_ltic1ch-d1-4.h"
#include "menu.h"

/* read all the general purpose registers */
int ltic1ch_d1_4_menu_read_gen_reg(modbus_t *p_modbus, int print, int read_all_regs)
{
	int err = 0;
	ltic1ch_d1_4_reg_rd_t reg;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if ((err = ltic1ch_d1_4_gen_reg_rd(p_modbus, &reg, print, read_all_regs)) != 0) {
		printf("error in ltic1ch_d1_4_gen_reg_rd() call\n");
		goto exit;
	}

exit:
	return err;
}

/* write all the general purpose registers */
int ltic1ch_d1_4_menu_write_gen_reg(modbus_t *p_modbus, int mode)
{
	int err = 0;
	ltic1ch_d1_4_reg_wr_t reg;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if (mode == 0) { /* factory configuration */
		reg.enable_control = 0;
		reg.current_control = 0;
		reg.current_range = 0;
		reg.current_preset = 0;
		reg.fault_control = 0x0007;
		reg.fault_board_tmp_low = 800;
		reg.fault_board_tmp_high = 900;
		reg.fault_light_tmp_low = 850;
		reg.fault_light_tmp_high = 950;
		reg.fan_control = 0;
		reg.fan_tmp_low = 600;
		reg.fan_tmp_high = 800;
		reg.fan_duty_inf = 50;
		reg.fan_duty_sup = 100;
		reg.fan_duty_min = 50;
		reg.fan_duty_max = 100;
		reg.fan_duty_manual = 75;
		reg.fan_pwm_frequency = 250;
		reg.osc_control = 0;
		reg.osc_frequency = 3000;
		reg.spare_set0 = 0;
		reg.spare_set1 = 0;
		reg.spare_set2 = 0;
		reg.spare_set3 = 0;
		reg.spare_set4 = 0;
		reg.spare_set5 = 0;
		reg.spare_set6 = 0;
		reg.spare_set7 = 0;
		reg.spare_set8 = 0;
		reg.spare_set9 = 0;
		reg.spare_set10 = 0;
		reg.spare_set11 = 0;
		reg.spare_set12 = 0;
		reg.spare_set13 = 0;
		reg.spare_set14 = 0;
		reg.spare_set15 = 0;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4943;
		reg.eth_hostname2 = 0x3143;
		reg.eth_hostname3 = 0x482D;
		reg.eth_hostname4 = 0x4431;
		reg.eth_hostname5 = 0x2D34;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port = 502;
		reg.eth_modbus_udp_port = 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}
	else if (mode == 1) { /* test configuration */
		reg.enable_control = 0;
		reg.current_control = 0;
		reg.current_range = 0;
		reg.current_preset = 0;
		reg.fault_control = 0x0007;
		reg.fault_board_tmp_low = 800;
		reg.fault_board_tmp_high = 900;
		reg.fault_light_tmp_low = 850;
		reg.fault_light_tmp_high = 950;
		reg.fan_control = 0;
		reg.fan_tmp_low = 600;
		reg.fan_tmp_high = 800;
		reg.fan_duty_inf = 50;
		reg.fan_duty_sup = 100;
		reg.fan_duty_min = 50;
		reg.fan_duty_max = 100;
		reg.fan_duty_manual = 75;
		reg.fan_pwm_frequency = 250;
		reg.osc_control = 0;
		reg.osc_frequency = 3000;
		reg.spare_set0 = 0;
		reg.spare_set1 = 0;
		reg.spare_set2 = 0;
		reg.spare_set3 = 0;
		reg.spare_set4 = 0;
		reg.spare_set5 = 0;
		reg.spare_set6 = 0;
		reg.spare_set7 = 0;
		reg.spare_set8 = 0;
		reg.spare_set9 = 0;
		reg.spare_set10 = 0;
		reg.spare_set11 = 0;
		reg.spare_set12 = 0;
		reg.spare_set13 = 0;
		reg.spare_set14 = 0;
		reg.spare_set15 = 0;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4943;
		reg.eth_hostname2 = 0x3143;
		reg.eth_hostname3 = 0x482D;
		reg.eth_hostname4 = 0x4431;
		reg.eth_hostname5 = 0x2D34;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port = 502;
		reg.eth_modbus_udp_port = 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}
	else if (mode == 2) { /* laboratory configuration */
		reg.enable_control = 0;
		reg.current_control = 0;
		reg.current_range = 0;
		reg.current_preset = 0;
		reg.fault_control = 0x0007;
		reg.fault_board_tmp_low = 800;
		reg.fault_board_tmp_high = 900;
		reg.fault_light_tmp_low = 850;
		reg.fault_light_tmp_high = 950;
		reg.fan_control = 0;
		reg.fan_tmp_low = 600;
		reg.fan_tmp_high = 800;
		reg.fan_duty_inf = 50;
		reg.fan_duty_sup = 100;
		reg.fan_duty_min = 50;
		reg.fan_duty_max = 100;
		reg.fan_duty_manual = 75;
		reg.fan_pwm_frequency = 250;
		reg.osc_control = 0;
		reg.osc_frequency = 3000;
		reg.spare_set0 = 0;
		reg.spare_set1 = 0;
		reg.spare_set2 = 0;
		reg.spare_set3 = 0;
		reg.spare_set4 = 0;
		reg.spare_set5 = 0;
		reg.spare_set6 = 0;
		reg.spare_set7 = 0;
		reg.spare_set8 = 0;
		reg.spare_set9 = 0;
		reg.spare_set10 = 0;
		reg.spare_set11 = 0;
		reg.spare_set12 = 0;
		reg.spare_set13 = 0;
		reg.spare_set14 = 0;
		reg.spare_set15 = 0;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4943;
		reg.eth_hostname2 = 0x3143;
		reg.eth_hostname3 = 0x482D;
		reg.eth_hostname4 = 0x4431;
		reg.eth_hostname5 = 0x2D34;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port = 502;
		reg.eth_modbus_udp_port = 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}

	if ((err = ltic1ch_d1_4_gen_reg_wr(p_modbus, &reg, 1, 0)) != 0) {
		printf("error in ltic1ch_d1_4_gen_reg_wr() call\n");
		goto exit;
	}

exit:
	return err;
}

/* write board command register */
int ltic1ch_d1_4_menu_write_brd_cmd(modbus_t *p_modbus, int reg_val)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if ((err = ltic1ch_d1_4_brd_cmd_wr(p_modbus, reg_val)) != 0) {
		printf("error in ltic1ch_d1_4_brd_cmd_wr() call\n");
		goto exit;
	}

exit:
	return err;
}

/* read all the general purpose registers and store data to disk file */
int ltic1ch_d1_4_menu_read_gen_reg_file(modbus_t *p_modbus, char *p_file_name)
{
	int err = 0;
	int print = 0;
	ltic1ch_d1_4_reg_rd_t reg_rd;
	ltic1ch_d1_4_reg_file_t reg_file;
	FILE *p_file = NULL;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_file_name == NULL) { err = 1; printf("bad parameter p_file_name\n"); goto exit; }

	/* open disk file for writing */
	if (fopen_s(&p_file, p_file_name, "wb") != 0) {
		printf("unable to open file %s for writing\n", p_file_name);
		goto exit;
	}

	/* read registers from device */
	printf("reading registers from device...\n");
	if ((err = ltic1ch_d1_4_gen_reg_rd(p_modbus, &reg_rd, print, 1)) != 0) {
		printf("error in ltic1ch_d1_4_gen_reg_rd() call\n");
		goto exit;
	}
	printf("registers read from device\n");

	/* prepare data for writing to disk */
	reg_file.magic0 = LTIC1CH_D1_4_FILE_MAGIC0;
	reg_file.magic1 = LTIC1CH_D1_4_FILE_MAGIC1;
	reg_file.enable_control = reg_rd.enable_control;
	reg_file.current_control = reg_rd.current_control;
	reg_file.current_range = reg_rd.current_range;
	reg_file.current_preset = reg_rd.current_preset;
	reg_file.fault_control = reg_rd.fault_control;
	reg_file.fault_board_tmp_low = reg_rd.fault_board_tmp_low;
	reg_file.fault_board_tmp_high = reg_rd.fault_board_tmp_high;
	reg_file.fault_light_tmp_low = reg_rd.fault_light_tmp_low;
	reg_file.fault_light_tmp_high = reg_rd.fault_light_tmp_high;
	reg_file.fan_control = reg_rd.fan_control;
	reg_file.fan_tmp_low = reg_rd.fan_tmp_low;
	reg_file.fan_tmp_high = reg_rd.fan_tmp_high;
	reg_file.fan_duty_inf = reg_rd.fan_duty_inf;
	reg_file.fan_duty_sup = reg_rd.fan_duty_sup;
	reg_file.fan_duty_min = reg_rd.fan_duty_min;
	reg_file.fan_duty_max = reg_rd.fan_duty_max;
	reg_file.fan_duty_manual = reg_rd.fan_duty_manual;
	reg_file.fan_pwm_frequency = reg_rd.fan_pwm_frequency;
	reg_file.osc_control = reg_rd.osc_control;
	reg_file.osc_frequency = reg_rd.osc_frequency;
	reg_file.spare_set0 = reg_rd.spare_set0;
	reg_file.spare_set1 = reg_rd.spare_set1;
	reg_file.spare_set2 = reg_rd.spare_set2;
	reg_file.spare_set3 = reg_rd.spare_set3;
	reg_file.spare_set4 = reg_rd.spare_set4;
	reg_file.spare_set5 = reg_rd.spare_set5;
	reg_file.spare_set6 = reg_rd.spare_set6;
	reg_file.spare_set7 = reg_rd.spare_set7;
	reg_file.spare_set8 = reg_rd.spare_set8;
	reg_file.spare_set9 = reg_rd.spare_set9;
	reg_file.spare_set10 = reg_rd.spare_set10;
	reg_file.spare_set11 = reg_rd.spare_set11;
	reg_file.spare_set12 = reg_rd.spare_set12;
	reg_file.spare_set13 = reg_rd.spare_set13;
	reg_file.spare_set14 = reg_rd.spare_set14;
	reg_file.spare_set15 = reg_rd.spare_set15;
	reg_file.rs485_modbus_addr = reg_rd.rs485_modbus_addr;
	reg_file.rs485_line_speed = reg_rd.rs485_line_speed;
	reg_file.rs485_line_parity = reg_rd.rs485_line_parity;
	reg_file.eth_mac_addr0 = reg_rd.eth_mac_addr0;
	reg_file.eth_mac_addr1 = reg_rd.eth_mac_addr1;
	reg_file.eth_mac_addr2 = reg_rd.eth_mac_addr2;
	reg_file.eth_hostname0 = reg_rd.eth_hostname0;
	reg_file.eth_hostname1 = reg_rd.eth_hostname1;
	reg_file.eth_hostname2 = reg_rd.eth_hostname2;
	reg_file.eth_hostname3 = reg_rd.eth_hostname3;
	reg_file.eth_hostname4 = reg_rd.eth_hostname4;
	reg_file.eth_hostname5 = reg_rd.eth_hostname5;
	reg_file.eth_hostname6 = reg_rd.eth_hostname6;
	reg_file.eth_hostname7 = reg_rd.eth_hostname7;
	reg_file.eth_dhcp_enable = reg_rd.eth_dhcp_enable;
	reg_file.eth_ip_addr_hi = reg_rd.eth_ip_addr_hi;
	reg_file.eth_ip_addr_lo = reg_rd.eth_ip_addr_lo;
	reg_file.eth_subnet_mask_hi = reg_rd.eth_subnet_mask_hi;
	reg_file.eth_subnet_mask_lo = reg_rd.eth_subnet_mask_lo;
	reg_file.eth_def_gateway_hi = reg_rd.eth_def_gateway_hi;
	reg_file.eth_def_gateway_lo = reg_rd.eth_def_gateway_lo;
	reg_file.eth_pri_dns_hi = reg_rd.eth_pri_dns_hi;
	reg_file.eth_pri_dns_lo = reg_rd.eth_pri_dns_lo;
	reg_file.eth_sec_dns_hi = reg_rd.eth_sec_dns_hi;
	reg_file.eth_sec_dns_lo = reg_rd.eth_sec_dns_lo;
	reg_file.eth_modbus_addr = reg_rd.eth_modbus_addr;
	reg_file.eth_modbus_tcp_port = reg_rd.eth_modbus_tcp_port;
	reg_file.eth_modbus_udp_port = reg_rd.eth_modbus_udp_port;
	reg_file.web_password0 = reg_rd.web_password0;
	reg_file.web_password1 = reg_rd.web_password1;
	reg_file.web_password2 = reg_rd.web_password2;
	reg_file.web_password3 = reg_rd.web_password3;

	/* write data to file */
	if (fwrite(&reg_file, sizeof(reg_file), 1, p_file) != 1) {
		printf("unable to write to file %s\n", p_file_name);
		goto exit;
	}
	printf("data written to file \"%s\"\n", p_file_name);

exit:
	if (p_file != NULL) fclose(p_file);
	return err;
}

/* write all the general purpose registers with data read from disk file */
int ltic1ch_d1_4_menu_write_gen_reg_file(modbus_t *p_modbus, char *p_file_name)
{
	int err = 0;
	int print = 0;
	ltic1ch_d1_4_reg_wr_t reg_wr;
	ltic1ch_d1_4_reg_file_t reg_file;
	FILE *p_file = NULL;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_file_name == NULL) { err = 1; printf("bad parameter p_file_name\n"); goto exit; }

	/* open disk file for reading */
	if (fopen_s(&p_file, p_file_name, "rb") != 0) {
		printf("unable to open file %s for reading\n", p_file_name);
		goto exit;
	}

	/* read data from file */
	if (fread(&reg_file, sizeof(reg_file), 1, p_file) != 1) {
		printf("unable to read from file %s\n", p_file_name);
		goto exit;
	}
	printf("data read from file \"%s\"\n", p_file_name);

	/* check header */
	if ((reg_file.magic0 != LTIC1CH_D1_4_FILE_MAGIC0) || (reg_file.magic1 != LTIC1CH_D1_4_FILE_MAGIC1)) {
		printf("bad header in file %s\n", p_file_name);
		goto exit;
	}

	/* prepare data for writing to device */
	reg_wr.enable_control = reg_file.enable_control;
	reg_wr.current_control = reg_file.current_control;
	reg_wr.current_range = reg_file.current_range;
	reg_wr.current_preset = reg_file.current_preset;
	reg_wr.fault_control = reg_file.fault_control;
	reg_wr.fault_board_tmp_low = reg_file.fault_board_tmp_low;
	reg_wr.fault_board_tmp_high = reg_file.fault_board_tmp_high;
	reg_wr.fault_light_tmp_low = reg_file.fault_light_tmp_low;
	reg_wr.fault_light_tmp_high = reg_file.fault_light_tmp_high;
	reg_wr.fan_control = reg_file.fan_control;
	reg_wr.fan_tmp_low = reg_file.fan_tmp_low;
	reg_wr.fan_tmp_high = reg_file.fan_tmp_high;
	reg_wr.fan_duty_inf = reg_file.fan_duty_inf;
	reg_wr.fan_duty_sup = reg_file.fan_duty_sup;
	reg_wr.fan_duty_min = reg_file.fan_duty_min;
	reg_wr.fan_duty_max = reg_file.fan_duty_max;
	reg_wr.fan_duty_manual = reg_file.fan_duty_manual;
	reg_wr.fan_pwm_frequency = reg_file.fan_pwm_frequency;
	reg_wr.osc_control = reg_file.osc_control;
	reg_wr.osc_frequency = reg_file.osc_frequency;
	reg_wr.spare_set0 = reg_file.spare_set0;
	reg_wr.spare_set1 = reg_file.spare_set1;
	reg_wr.spare_set2 = reg_file.spare_set2;
	reg_wr.spare_set3 = reg_file.spare_set3;
	reg_wr.spare_set4 = reg_file.spare_set4;
	reg_wr.spare_set5 = reg_file.spare_set5;
	reg_wr.spare_set6 = reg_file.spare_set6;
	reg_wr.spare_set7 = reg_file.spare_set7;
	reg_wr.spare_set8 = reg_file.spare_set8;
	reg_wr.spare_set9 = reg_file.spare_set9;
	reg_wr.spare_set10 = reg_file.spare_set10;
	reg_wr.spare_set11 = reg_file.spare_set11;
	reg_wr.spare_set12 = reg_file.spare_set12;
	reg_wr.spare_set13 = reg_file.spare_set13;
	reg_wr.spare_set14 = reg_file.spare_set14;
	reg_wr.spare_set15 = reg_file.spare_set15;
	reg_wr.rs485_modbus_addr = reg_file.rs485_modbus_addr;
	reg_wr.rs485_line_speed = reg_file.rs485_line_speed;
	reg_wr.rs485_line_parity = reg_file.rs485_line_parity;
	reg_wr.eth_mac_addr0 = reg_file.eth_mac_addr0;
	reg_wr.eth_mac_addr1 = reg_file.eth_mac_addr1;
	reg_wr.eth_mac_addr2 = reg_file.eth_mac_addr2;
	reg_wr.eth_hostname0 = reg_file.eth_hostname0;
	reg_wr.eth_hostname1 = reg_file.eth_hostname1;
	reg_wr.eth_hostname2 = reg_file.eth_hostname2;
	reg_wr.eth_hostname3 = reg_file.eth_hostname3;
	reg_wr.eth_hostname4 = reg_file.eth_hostname4;
	reg_wr.eth_hostname5 = reg_file.eth_hostname5;
	reg_wr.eth_hostname6 = reg_file.eth_hostname6;
	reg_wr.eth_hostname7 = reg_file.eth_hostname7;
	reg_wr.eth_dhcp_enable = reg_file.eth_dhcp_enable;
	reg_wr.eth_ip_addr_hi = reg_file.eth_ip_addr_hi;
	reg_wr.eth_ip_addr_lo = reg_file.eth_ip_addr_lo;
	reg_wr.eth_subnet_mask_hi = reg_file.eth_subnet_mask_hi;
	reg_wr.eth_subnet_mask_lo = reg_file.eth_subnet_mask_lo;
	reg_wr.eth_def_gateway_hi = reg_file.eth_def_gateway_hi;
	reg_wr.eth_def_gateway_lo = reg_file.eth_def_gateway_lo;
	reg_wr.eth_pri_dns_hi = reg_file.eth_pri_dns_hi;
	reg_wr.eth_pri_dns_lo = reg_file.eth_pri_dns_lo;
	reg_wr.eth_sec_dns_hi = reg_file.eth_sec_dns_hi;
	reg_wr.eth_sec_dns_lo = reg_file.eth_sec_dns_lo;
	reg_wr.eth_modbus_addr = reg_file.eth_modbus_addr;
	reg_wr.eth_modbus_tcp_port = reg_file.eth_modbus_tcp_port;
	reg_wr.eth_modbus_udp_port = reg_file.eth_modbus_udp_port;
	reg_wr.web_password0 = reg_file.web_password0;
	reg_wr.web_password1 = reg_file.web_password1;
	reg_wr.web_password2 = reg_file.web_password2;
	reg_wr.web_password3 = reg_file.web_password3;

	/* write registers to device */
	printf("writing registers to device...\n");
	if ((err = ltic1ch_d1_4_gen_reg_wr(p_modbus, &reg_wr, print, 0)) != 0) {
		printf("error in ltic1ch_d1_4_gen_reg_wr() call\n");
		goto exit;
	}
	printf("registers written to device\n");

	/* store registers in non-volatile memory */
	printf("storing registers to non-volatile memory...\n");
	if ((err = ltic1ch_d1_4_menu_write_brd_cmd(p_modbus, 2)) != 0) {
		printf("error in ltic1ch_d1_4_menu_write_brd_cmd() call\n");
		goto exit;
	}
	printf("registers stored to non-volatile memory\n");

exit:
	if (p_file != NULL) fclose(p_file);
	return err;
}

/* program menu */
int ltic1ch_d1_4_menu_run(int use_ethernet)
{
	modbus_t modbus;
	int err = 0;
	int quit = 0;
	char file_name[] = "LTIC1CH-D1-4.dat";

	/* communication parameters */
	LPCWSTR p_ser_port = MODBUS_COM;
	int modbus_addr = MODBUS_ADR;
	char *p_eth_board_ip_address = BOARD_IP_ADDRESS;
	char *p_eth_board_port_number = BOARD_PORT_NUMBER;

	if (p_ser_port == NULL) { err = 1; printf("bad parameter p_ser_port\n"); goto exit; }
	if (modbus_addr < 0) { err = 1; printf("bad parameter modbus_addr\n"); goto exit; }
	if (p_eth_board_ip_address == NULL) { err = 1; printf("bad parameter p_eth_board_ip_address\n"); goto exit; }
	if (p_eth_board_port_number == NULL) { err = 1; printf("bad parameter p_eth_board_port_number\n"); goto exit; }

	if ((err = modbus_init(&modbus)) != 0) {
		printf("error in modbus_init() call\n");
		goto exit;
	}

	if (use_ethernet == 0) {
		if ((err = modbus_open_ser(&modbus, p_ser_port)) != 0) {
			printf("error in modbus_open_ser() call\n");
			goto exit;
		}

		if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_SER_485)) != 0) {
			printf("error in modbus_sel_mode() call\n");
			goto exit;
		}
	}
	else {
		if ((err = modbus_open_eth(&modbus, p_eth_board_ip_address, p_eth_board_port_number)) != 0) {
			printf("error in modbus_open_eth() call\n");
			goto exit;
		}

		if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_ETH_TCP)) != 0) {
			printf("error in modbus_sel_mode() call\n");
			goto exit;
		}
	}

	if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
		printf("error in modbus_sel_addr() call\n");
		goto exit;
	}

	while (!quit) {
		printf(
			"\n"
			"LTIC1CH-D1-4 demonstration program\n"
			"==================================\n"
			"\n"
			"0) Quit\n"
			"1) Read registers\n"
			"2) Write registers with factory configuration\n"
			"3) Write registers with test configuration\n"
			"4) Write registers with EMC configuration\n"
			"5) Load registers from non-volatile memory\n"
			"6) Store registers to non-volatile memory\n"
			"7) Reboot device\n"
			"8) Read registers and save data to disk file \"%s\"\n"
			"9) Write registers with data loaded from disk file \"%s\" and store to non-volatile memory\n"
			"\n"
			"Choose: ", file_name, file_name
			);

		switch (menu_wait_selection()) {
		case 0:
			quit = 1;
			break;
		case 1:
			if ((err = ltic1ch_d1_4_menu_read_gen_reg(&modbus, 1, 1)) != 0) {
				printf("error in ltic1ch_d1_4_menu_read_gen_reg() call\n");
				goto exit;
			}
			break;
		case 2:
			if ((err = ltic1ch_d1_4_menu_write_gen_reg(&modbus, 0)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 3:
			if ((err = ltic1ch_d1_4_menu_write_gen_reg(&modbus, 1)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 4:
			if ((err = ltic1ch_d1_4_menu_write_gen_reg(&modbus, 2)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 5:
			if ((err = ltic1ch_d1_4_menu_write_brd_cmd(&modbus, 1)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 6:
			if ((err = ltic1ch_d1_4_menu_write_brd_cmd(&modbus, 2)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 7:
			if ((err = ltic1ch_d1_4_menu_write_brd_cmd(&modbus, 3)) != 0) {
				printf("error in ltic1ch_d1_4_menu_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 8:
			if ((err = ltic1ch_d1_4_menu_read_gen_reg_file(&modbus, file_name)) != 0) {
				printf("error in ltic1ch_d1_4_menu_read_gen_reg_file() call\n");
				goto exit;
			}
			break;
		case 9:
			if ((err = ltic1ch_d1_4_menu_write_gen_reg_file(&modbus, file_name)) != 0) {
				printf("error in ltic1ch_d1_4_menu_write_gen_reg_file() call\n");
				goto exit;
			}
			break;
		default:
			break;
		}
	}

	if ((err = modbus_close_ser(&modbus)) != 0) {
		printf("error in modbus_close_ser() call\n");
		goto exit;
	}

	if ((err = modbus_close_eth(&modbus)) != 0) {
		printf("error in modbus_close_eth() call\n");
		goto exit;
	}

exit:
	return err;
}

/* test communication interfaces */
int ltic1ch_d1_4_menu_test_communication(int test_serial, int test_ethernet)
{
	modbus_t modbus;
	int err = 0;
	int quit = 0;
	int err_eth = 0;
	int err_ser = 0;

	/* communication parameters */
	LPCWSTR p_ser_port = MODBUS_COM;
	int modbus_addr = MODBUS_ADR;
	char *p_eth_board_ip_address = BOARD_IP_ADDRESS;
	char *p_eth_board_port_number = BOARD_PORT_NUMBER;

	if (p_ser_port == NULL) { err = 1; printf("bad parameter p_ser_port\n"); goto exit; }
	if (modbus_addr < 0) { err = 1; printf("bad parameter modbus_addr\n"); goto exit; }
	if (p_eth_board_ip_address == NULL) { err = 1; printf("bad parameter p_eth_board_ip_address\n"); goto exit; }
	if (p_eth_board_port_number == NULL) { err = 1; printf("bad parameter p_eth_board_port_number\n"); goto exit; }

	while (1) {
		if (test_serial != 0) {
			printf("\n");
			printf("**********************************\n");
			printf("* Serial port communication test *\n");
			printf("**********************************\n");
			printf("\n");

			if ((err = modbus_init(&modbus)) != 0) {
				printf("error in modbus_init() call\n");
				goto exit;
			}

			if ((err = modbus_open_ser(&modbus, p_ser_port)) != 0) {
				printf("error in modbus_open_ser() call\n");
				err_ser++;
				//goto exit;
			}
			printf("\n");

			if (modbus.ser_initialized != 0) {
				if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
					printf("error in modbus_sel_addr() call\n");
					goto exit;
				}

				if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_SER_485)) != 0) {
					printf("error in modbus_sel_mode() call\n");
					goto exit;
				}

				if ((err = ltic1ch_d1_4_menu_read_gen_reg(&modbus, 0, 0)) != 0) {
					printf("error in ltic1ch_d1_4_menu_read_gen_reg() call\n");
					err_ser++;
					//goto exit;
				}
				printf("\n");

				if ((err = modbus_close_ser(&modbus)) != 0) {
					printf("error in modbus_close_ser() call\n");
					goto exit;
				}
				printf("\n");
			}
			printf("Cumulative error count for serial interface = %d\n", err_ser);
			printf("\n");

			/* 1000ms delay */
			Sleep(1000);

			if (_kbhit()) { _getch(); break; }
		}

		if (test_ethernet != 0) {
			printf("\n");
			printf("************************************\n");
			printf("* Ethernet port communication test *\n");
			printf("************************************\n");
			printf("\n");

			if ((err = modbus_init(&modbus)) != 0) {
				printf("error in modbus_init() call\n");
				goto exit;
			}

			if ((err = modbus_open_eth(&modbus, p_eth_board_ip_address, p_eth_board_port_number)) != 0) {
				printf("error in modbus_open_eth() call\n");
				err_eth++;
				//goto exit;
			}
			printf("\n");

			if (modbus.eth_initialized != 0) {
				if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
					printf("error in modbus_sel_addr() call\n");
					goto exit;
				}

				if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_ETH_TCP)) != 0) {
					printf("error in modbus_sel_mode() call\n");
					goto exit;
				}

				if ((err = ltic1ch_d1_4_menu_read_gen_reg(&modbus, 0, 0)) != 0) {
					printf("error in ltic1ch_d1_4_menu_read_gen_reg() call\n");
					err_eth++;
					//goto exit;
				}
				printf("\n");

				if ((err = modbus_close_eth(&modbus)) != 0) {
					printf("error in modbus_com_close_eth() call\n");
					goto exit;
				}
				printf("\n");
			}
			printf("Cumulative error count for ethernet interface = %d\n", err_eth);
			printf("\n");

			/* 1000ms delay */
			Sleep(1000);

			if (_kbhit()) { _getch(); break; }
		}
	}

exit:
	return err;
}

/* file ends here */
