/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "main_app.h"
#include "modbus.h"
#include "dev_ltdve4ch.h"
#include "menu_ltdve4ch.h"
#include "menu.h"

/* read all the general purpose registers */
int ltdve4ch_menu_read_gen_reg(modbus_t *p_modbus, int print, int read_all_regs)
{
	int err = 0;
	ltdve4ch_reg_rd_t reg;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if ((err = ltdve4ch_gen_reg_rd(p_modbus, &reg, print, read_all_regs)) != 0) {
		printf("error in ltdve4ch_gen_reg_rd() call\n");
		goto exit;
	}

exit:
	return err;
}

/* write all the general purpose registers */
int ltdve4ch_menu_write_gen_reg(modbus_t *p_modbus, int mode)
{
	int err = 0;
	ltdve4ch_reg_wr_t reg;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if (mode == 0) { /* factory configuration */
		reg.osc_period = 200;
		reg.filter_sel0	= 0;
		reg.filter_sel1	= 0;
		reg.filter_sel2 = 0;
		reg.filter_sel3 = 0;
		reg.input_sel0 = 0x0000;
		reg.input_sel1 = 0x0000;
		reg.input_sel2 = 0x0000;
		reg.input_sel3 = 0x0000;
		reg.input_sel4 = 0x0000;
		reg.input_sel5 = 0x0000;
		reg.input_sel6 = 0x0000;
		reg.input_sel7 = 0x0000;
		reg.gen_dly_base0 = 0;
		reg.gen_dly_cnt0 = 0;
		reg.gen_wdt_base0 = 0;
		reg.gen_wdt_cnt0 = 0;
		reg.gen_dly_base1 = 0;
		reg.gen_dly_cnt1 = 0;
		reg.gen_wdt_base1 = 0;
		reg.gen_wdt_cnt1 = 0;
		reg.gen_dly_base2 = 0;
		reg.gen_dly_cnt2 = 0;
		reg.gen_wdt_base2 = 0;
		reg.gen_wdt_cnt2 = 0;
		reg.gen_dly_base3 = 0;
		reg.gen_dly_cnt3 = 0;
		reg.gen_wdt_base3 = 0;
		reg.gen_wdt_cnt3 = 0;
		reg.gen_dly_base4 = 0;
		reg.gen_dly_cnt4 = 0;
		reg.gen_wdt_base4 = 0;
		reg.gen_wdt_cnt4 = 0;
		reg.gen_dly_base5 = 0;
		reg.gen_dly_cnt5 = 0;
		reg.gen_wdt_base5 = 0;
		reg.gen_wdt_cnt5 = 0;
		reg.gen_dly_base6 = 0;
		reg.gen_dly_cnt6 = 0;
		reg.gen_wdt_base6 = 0;
		reg.gen_wdt_cnt6 = 0;
		reg.gen_dly_base7 = 0;
		reg.gen_dly_cnt7 = 0;
		reg.gen_wdt_base7 = 0;
		reg.gen_wdt_cnt7 = 0;
		reg.output_sel_hi0 = 0x0000;
		reg.output_sel_lo0 = 0x0000;
		reg.output_sel_hi1 = 0x0000;
		reg.output_sel_lo1 = 0x0000;
		reg.output_sel_hi2 = 0x0000;
		reg.output_sel_lo2 = 0x0000;
		reg.output_sel_hi3 = 0x0000;
		reg.output_sel_lo3 = 0x0000;
		reg.output_sel_hi8 = 0x0000;
		reg.output_sel_lo8 = 0x0000;
		reg.output_sel_hi9 = 0x0000;
		reg.output_sel_lo9 = 0x0000;
		reg.output_sel_hi10 = 0x0000;
		reg.output_sel_lo10 = 0x0000;
		reg.output_sel_hi11 = 0x0000;
		reg.output_sel_lo11 = 0x0000;
		reg.prt_cnt_on0 = 0;
		reg.prt_ena_on0 = 0;
		reg.prt_cnt_off0 = 0;
		reg.prt_ena_off0 = 0;
		reg.prt_cnt_on1 = 0;
		reg.prt_ena_on1 = 0;
		reg.prt_cnt_off1 = 0;
		reg.prt_ena_off1 = 0;
		reg.prt_cnt_on2 = 0;
		reg.prt_ena_on2 = 0;
		reg.prt_cnt_off2 = 0;
		reg.prt_ena_off2 = 0;
		reg.prt_cnt_on3 = 0;
		reg.prt_ena_on3 = 0;
		reg.prt_cnt_off3 = 0;
		reg.prt_ena_off3 = 0;
		reg.cur_range0 = 0;
		reg.cur_value0 = 0;
		reg.cur_range1 = 0;
		reg.cur_value1 = 0;
		reg.cur_range2 = 0;
		reg.cur_value2 = 0;
		reg.cur_range3 = 0;
		reg.cur_value3 = 0;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4456;
		reg.eth_hostname2 = 0x4534;
		reg.eth_hostname3 = 0x4348;
		reg.eth_hostname4 = 0x2d32;
		reg.eth_hostname5 = 0x3000;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port	= 502;
		reg.eth_modbus_udp_port	= 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}
	else if (mode == 1) { /* test configuration */
		reg.osc_period = 200;
		reg.filter_sel0 = 0;
		reg.filter_sel1 = 0;
		reg.filter_sel2 = 0;
		reg.filter_sel3 = 0;
		reg.input_sel0 = 0x0100; /* oscillator */
		reg.input_sel1 = 0x0100; /* oscillator */
		reg.input_sel2 = 0x0100; /* oscillator */
		reg.input_sel3 = 0x0100; /* oscillator */
		reg.input_sel4 = 0x0100; /* oscillator */
		reg.input_sel5 = 0x0100; /* oscillator */
		reg.input_sel6 = 0x0100; /* oscillator */
		reg.input_sel7 = 0x0100; /* oscillator */
		reg.gen_dly_base0 = 3;	//1ms
		reg.gen_dly_cnt0 = 0;
		reg.gen_wdt_base0 = 0;	//1us
		reg.gen_wdt_cnt0 = 500;
		reg.gen_dly_base1 = 3;	//1ms
		reg.gen_dly_cnt1 = 1;
		reg.gen_wdt_base1 = 0;	//1us
		reg.gen_wdt_cnt1 = 500;
		reg.gen_dly_base2 = 3;	//1ms
		reg.gen_dly_cnt2 = 2;
		reg.gen_wdt_base2 = 0;	//1us
		reg.gen_wdt_cnt2 = 500;
		reg.gen_dly_base3 = 3;	//1ms
		reg.gen_dly_cnt3 = 3;
		reg.gen_wdt_base3 = 0;	//1us
		reg.gen_wdt_cnt3 = 500;
		reg.gen_dly_base4 = 3;	//1ms
		reg.gen_dly_cnt4 = 0;
		reg.gen_wdt_base4 = 3;	//1ms
		reg.gen_wdt_cnt4 = 1;
		reg.gen_dly_base5 = 3;	//1ms
		reg.gen_dly_cnt5 = 0;
		reg.gen_wdt_base5 = 3;	//1ms
		reg.gen_wdt_cnt5 = 1;
		reg.gen_dly_base6 = 3;	//1ms
		reg.gen_dly_cnt6 = 0;
		reg.gen_wdt_base6 = 3;	//1ms
		reg.gen_wdt_cnt6 = 1;
		reg.gen_dly_base7 = 3;	//1ms
		reg.gen_dly_cnt7 = 0;
		reg.gen_wdt_base7 = 3;	//1ms
		reg.gen_wdt_cnt7 = 1;
		reg.output_sel_hi0 = 0x0000;
		reg.output_sel_lo0 = 0x0001;
		reg.output_sel_hi1 = 0x0000;
		reg.output_sel_lo1 = 0x0002;
		reg.output_sel_hi2 = 0x0000;
		reg.output_sel_lo2 = 0x0004;
		reg.output_sel_hi3 = 0x0000;
		reg.output_sel_lo3 = 0x0008;
		reg.output_sel_hi8 = 0x0000;
		reg.output_sel_lo8 = 0x0010;
		reg.output_sel_hi9 = 0x0000;
		reg.output_sel_lo9 = 0x0020;
		reg.output_sel_hi10 = 0x0000;
		reg.output_sel_lo10 = 0x0040;
		reg.output_sel_hi11 = 0x0000;
		reg.output_sel_lo11 = 0x0080;
		reg.prt_cnt_on0 = 0;
		reg.prt_ena_on0	= 0;
		reg.prt_cnt_off0 = 0;
		reg.prt_ena_off0 = 0;
		reg.prt_cnt_on1 = 0;
		reg.prt_ena_on1	= 0;
		reg.prt_cnt_off1 = 0;
		reg.prt_ena_off1 = 0;
		reg.prt_cnt_on2	= 0;
		reg.prt_ena_on2	= 0;
		reg.prt_cnt_off2 = 0;
		reg.prt_ena_off2 = 0;
		reg.prt_cnt_on3 = 0;
		reg.prt_ena_on3	= 0;
		reg.prt_cnt_off3 = 0;
		reg.prt_ena_off3 = 0;
		reg.cur_range0 = 0;
		reg.cur_value0 = 17000;
		reg.cur_range1 = 0;
		reg.cur_value1 = 17000;
		reg.cur_range2 = 0;
		reg.cur_value2 = 17000;
		reg.cur_range3 = 0;
		reg.cur_value3 = 17000;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4456;
		reg.eth_hostname2 = 0x4534;
		reg.eth_hostname3 = 0x4348;
		reg.eth_hostname4 = 0x2d32;
		reg.eth_hostname5 = 0x3000;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port	= 502;
		reg.eth_modbus_udp_port	= 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}
	else if (mode == 2) { /* laboratory configuration */
		reg.osc_period = 200;
		reg.filter_sel0 = 0;
		reg.filter_sel1 = 0;
		reg.filter_sel2 = 0;
		reg.filter_sel3 = 0;
		reg.input_sel0 = 0x0001; /* TR1 */
		reg.input_sel1 = 0x0001; /* TR1 */
		reg.input_sel2 = 0x0001; /* TR1 */
		reg.input_sel3 = 0x0001; /* TR1 */
		reg.input_sel4 = 0x0001; /* TR1 */
		reg.input_sel5 = 0x0001; /* TR1 */
		reg.input_sel6 = 0x0001; /* TR1 */
		reg.input_sel7 = 0x0001; /* TR1 */
		reg.gen_dly_base0 = 3;	//1ms
		reg.gen_dly_cnt0 = 0;
		reg.gen_wdt_base0 = 0;	//1us
		reg.gen_wdt_cnt0 = 500;
		reg.gen_dly_base1 = 3;	//1ms
		reg.gen_dly_cnt1 = 1;
		reg.gen_wdt_base1 = 0;	//1us
		reg.gen_wdt_cnt1 = 500;
		reg.gen_dly_base2 = 3;	//1ms
		reg.gen_dly_cnt2 = 2;
		reg.gen_wdt_base2 = 0;	//1us
		reg.gen_wdt_cnt2 = 500;
		reg.gen_dly_base3 = 3;	//1ms
		reg.gen_dly_cnt3 = 3;
		reg.gen_wdt_base3 = 0;	//1us
		reg.gen_wdt_cnt3 = 500;
		reg.gen_dly_base4 = 3;	//1ms
		reg.gen_dly_cnt4 = 0;
		reg.gen_wdt_base4 = 3;	//1ms
		reg.gen_wdt_cnt4 = 1;
		reg.gen_dly_base5 = 3;	//1ms
		reg.gen_dly_cnt5 = 0;
		reg.gen_wdt_base5 = 3;	//1ms
		reg.gen_wdt_cnt5 = 1;
		reg.gen_dly_base6 = 3;	//1ms
		reg.gen_dly_cnt6 = 0;
		reg.gen_wdt_base6 = 3;	//1ms
		reg.gen_wdt_cnt6 = 1;
		reg.gen_dly_base7 = 3;	//1ms
		reg.gen_dly_cnt7 = 0;
		reg.gen_wdt_base7 = 3;	//1ms
		reg.gen_wdt_cnt7 = 1;
		reg.output_sel_hi0 = 0x0000;
		reg.output_sel_lo0 = 0x0001;
		reg.output_sel_hi1 = 0x0000;
		reg.output_sel_lo1 = 0x0002;
		reg.output_sel_hi2 = 0x0000;
		reg.output_sel_lo2 = 0x0004;
		reg.output_sel_hi3 = 0x0000;
		reg.output_sel_lo3 = 0x0008;
		reg.output_sel_hi8 = 0x0000;
		reg.output_sel_lo8 = 0x0010;
		reg.output_sel_hi9 = 0x0000;
		reg.output_sel_lo9 = 0x0020;
		reg.output_sel_hi10 = 0x0000;
		reg.output_sel_lo10 = 0x0040;
		reg.output_sel_hi11 = 0x0000;
		reg.output_sel_lo11 = 0x0080;
		reg.prt_cnt_on0 = 0;
		reg.prt_ena_on0 = 0;
		reg.prt_cnt_off0 = 0;
		reg.prt_ena_off0 = 0;
		reg.prt_cnt_on1 = 0;
		reg.prt_ena_on1 = 0;
		reg.prt_cnt_off1 = 0;
		reg.prt_ena_off1 = 0;
		reg.prt_cnt_on2 = 0;
		reg.prt_ena_on2 = 0;
		reg.prt_cnt_off2 = 0;
		reg.prt_ena_off2 = 0;
		reg.prt_cnt_on3 = 0;
		reg.prt_ena_on3 = 0;
		reg.prt_cnt_off3 = 0;
		reg.prt_ena_off3 = 0;
		reg.cur_range0 = 0;
		reg.cur_value0 = 17000;
		reg.cur_range1 = 0;
		reg.cur_value1 = 17000;
		reg.cur_range2 = 0;
		reg.cur_value2 = 17000;
		reg.cur_range3 = 0;
		reg.cur_value3 = 17000;
		reg.rs485_modbus_addr = 32;
		reg.rs485_line_speed = 3;
		reg.rs485_line_parity = 1;
		reg.eth_mac_addr0 = 0x0000;
		reg.eth_mac_addr1 = 0x0000;
		reg.eth_mac_addr2 = 0x0000;
		reg.eth_hostname0 = 0x4c54;
		reg.eth_hostname1 = 0x4456;
		reg.eth_hostname2 = 0x4534;
		reg.eth_hostname3 = 0x4348;
		reg.eth_hostname4 = 0x2d32;
		reg.eth_hostname5 = 0x3000;
		reg.eth_hostname6 = 0x0000;
		reg.eth_hostname7 = 0x0000;
		reg.eth_dhcp_enable = 0;
		reg.eth_ip_addr_hi = 0xC0A8;
		reg.eth_ip_addr_lo = 0x0020;
		reg.eth_subnet_mask_hi = 0xFFFF;
		reg.eth_subnet_mask_lo = 0xFF00;
		reg.eth_def_gateway_hi = 0xC0A8;
		reg.eth_def_gateway_lo = 0x0001;
		reg.eth_pri_dns_hi = 0xC0A8;
		reg.eth_pri_dns_lo = 0x0002;
		reg.eth_sec_dns_hi = 0xC0A8;
		reg.eth_sec_dns_lo = 0x0002;
		reg.eth_modbus_addr = 32;
		reg.eth_modbus_tcp_port = 502;
		reg.eth_modbus_udp_port = 502;
		reg.web_password0 = 0x0000;
		reg.web_password1 = 0x0000;
		reg.web_password2 = 0x0000;
		reg.web_password3 = 0x0000;
	}

	if ((err = ltdve4ch_gen_reg_wr(p_modbus, &reg, 1, 0)) != 0) {
		printf("error in ltdve4ch_gen_reg_wr() call\n");
		goto exit;
	}

exit:
	return err;
}

/* write board command register */
int ltdve4ch_menu_write_brd_cmd(modbus_t *p_modbus, int reg_val)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }

	if ((err = ltdve4ch_brd_cmd_wr(p_modbus, reg_val)) != 0) {
		printf("error in ltdve4ch_brd_cmd_wr() call\n");
		goto exit;
	}

exit:
	return err;
}

/* read all the general purpose registers and store data to disk file */
int ltdve4ch_menu_read_gen_reg_file(modbus_t *p_modbus, char *p_file_name)
{
	int err = 0;
	int print = 0;
	ltdve4ch_reg_rd_t reg_rd;
	ltdve4ch_reg_file_t reg_file;
	FILE *p_file = NULL;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_file_name == NULL) { err = 1; printf("bad parameter p_file_name\n"); goto exit; }

	/* open disk file for writing */
	if (fopen_s(&p_file, p_file_name, "wb") != 0) {
		printf("unable to open file %s for writing\n", p_file_name);
		goto exit;
	}

	/* read registers from device */
	printf("reading registers from device...\n");
	if ((err = ltdve4ch_gen_reg_rd(p_modbus, &reg_rd, print, 1)) != 0) {
		printf("error in ltdve4ch_gen_reg_rd() call\n");
		goto exit;
	}
	printf("registers read from device\n");

	/* prepare data for writing to disk */
	reg_file.magic0 = LTDVE4CH_FILE_MAGIC0;
	reg_file.magic1 = LTDVE4CH_FILE_MAGIC1;
	reg_file.osc_period = reg_rd.osc_period;
	reg_file.filter_sel0 = reg_rd.filter_sel0;
	reg_file.filter_sel1 = reg_rd.filter_sel1;
	reg_file.filter_sel2 = reg_rd.filter_sel2;
	reg_file.filter_sel3 = reg_rd.filter_sel3;
	reg_file.input_sel0 = reg_rd.input_sel0;
	reg_file.input_sel1 = reg_rd.input_sel1;
	reg_file.input_sel2 = reg_rd.input_sel2;
	reg_file.input_sel3 = reg_rd.input_sel3;
	reg_file.input_sel4 = reg_rd.input_sel4;
	reg_file.input_sel5 = reg_rd.input_sel5;
	reg_file.input_sel6 = reg_rd.input_sel6;
	reg_file.input_sel7 = reg_rd.input_sel7;
	reg_file.gen_dly_base0 = reg_rd.gen_dly_base0;
	reg_file.gen_dly_cnt0 = reg_rd.gen_dly_cnt0;
	reg_file.gen_wdt_base0 = reg_rd.gen_wdt_base0;
	reg_file.gen_wdt_cnt0 = reg_rd.gen_wdt_cnt0;
	reg_file.gen_dly_base1 = reg_rd.gen_dly_base1;
	reg_file.gen_dly_cnt1 = reg_rd.gen_dly_cnt1;
	reg_file.gen_wdt_base1 = reg_rd.gen_wdt_base1;
	reg_file.gen_wdt_cnt1 = reg_rd.gen_wdt_cnt1;
	reg_file.gen_dly_base2 = reg_rd.gen_dly_base2;
	reg_file.gen_dly_cnt2 = reg_rd.gen_dly_cnt2;
	reg_file.gen_wdt_base2 = reg_rd.gen_wdt_base2;
	reg_file.gen_wdt_cnt2 = reg_rd.gen_wdt_cnt2;
	reg_file.gen_dly_base3 = reg_rd.gen_dly_base3;
	reg_file.gen_dly_cnt3 = reg_rd.gen_dly_cnt3;
	reg_file.gen_wdt_base3 = reg_rd.gen_wdt_base3;
	reg_file.gen_wdt_cnt3 = reg_rd.gen_wdt_cnt3;
	reg_file.gen_dly_base4 = reg_rd.gen_dly_base4;
	reg_file.gen_dly_cnt4 = reg_rd.gen_dly_cnt4;
	reg_file.gen_wdt_base4 = reg_rd.gen_wdt_base4;
	reg_file.gen_wdt_cnt4 = reg_rd.gen_wdt_cnt4;
	reg_file.gen_dly_base5 = reg_rd.gen_dly_base5;
	reg_file.gen_dly_cnt5 = reg_rd.gen_dly_cnt5;
	reg_file.gen_wdt_base5 = reg_rd.gen_wdt_base5;
	reg_file.gen_wdt_cnt5 = reg_rd.gen_wdt_cnt5;
	reg_file.gen_dly_base6 = reg_rd.gen_dly_base6;
	reg_file.gen_dly_cnt6 = reg_rd.gen_dly_cnt6;
	reg_file.gen_wdt_base6 = reg_rd.gen_wdt_base6;
	reg_file.gen_wdt_cnt6 = reg_rd.gen_wdt_cnt6;
	reg_file.gen_dly_base7 = reg_rd.gen_dly_base7;
	reg_file.gen_dly_cnt7 = reg_rd.gen_dly_cnt7;
	reg_file.gen_wdt_base7 = reg_rd.gen_wdt_base7;
	reg_file.gen_wdt_cnt7 = reg_rd.gen_wdt_cnt7;
	reg_file.output_sel_hi0 = reg_rd.output_sel_hi0;
	reg_file.output_sel_lo0 = reg_rd.output_sel_lo0;
	reg_file.output_sel_hi1 = reg_rd.output_sel_hi1;
	reg_file.output_sel_lo1 = reg_rd.output_sel_lo1;
	reg_file.output_sel_hi2 = reg_rd.output_sel_hi2;
	reg_file.output_sel_lo2 = reg_rd.output_sel_lo2;
	reg_file.output_sel_hi3 = reg_rd.output_sel_hi3;
	reg_file.output_sel_lo3 = reg_rd.output_sel_lo3;
	reg_file.output_sel_hi8 = reg_rd.output_sel_hi8;
	reg_file.output_sel_lo8 = reg_rd.output_sel_lo8;
	reg_file.output_sel_hi9 = reg_rd.output_sel_hi9;
	reg_file.output_sel_lo9 = reg_rd.output_sel_lo9;
	reg_file.output_sel_hi10 = reg_rd.output_sel_hi10;
	reg_file.output_sel_lo10 = reg_rd.output_sel_lo10;
	reg_file.output_sel_hi11 = reg_rd.output_sel_hi11;
	reg_file.output_sel_lo11 = reg_rd.output_sel_lo11;
	reg_file.prt_cnt_on0 = reg_rd.prt_cnt_on0;
	reg_file.prt_ena_on0 = reg_rd.prt_ena_on0;
	reg_file.prt_cnt_off0 = reg_rd.prt_cnt_off0;
	reg_file.prt_ena_off0 = reg_rd.prt_ena_off0;
	reg_file.prt_cnt_on1 = reg_rd.prt_cnt_on1;
	reg_file.prt_ena_on1 = reg_rd.prt_ena_on1;
	reg_file.prt_cnt_off1 = reg_rd.prt_cnt_off1;
	reg_file.prt_ena_off1 = reg_rd.prt_ena_off1;
	reg_file.prt_cnt_on2 = reg_rd.prt_cnt_on2;
	reg_file.prt_ena_on2 = reg_rd.prt_ena_on2;
	reg_file.prt_cnt_off2 = reg_rd.prt_cnt_off2;
	reg_file.prt_ena_off2 = reg_rd.prt_ena_off2;
	reg_file.prt_cnt_on3 = reg_rd.prt_cnt_on3;
	reg_file.prt_ena_on3 = reg_rd.prt_ena_on3;
	reg_file.prt_cnt_off3 = reg_rd.prt_cnt_off3;
	reg_file.prt_ena_off3 = reg_rd.prt_ena_off3;
	reg_file.cur_range0 = reg_rd.cur_range0;
	reg_file.cur_value0 = reg_rd.cur_value0;
	reg_file.cur_range1 = reg_rd.cur_range1;
	reg_file.cur_value1 = reg_rd.cur_value1;
	reg_file.cur_range2 = reg_rd.cur_range2;
	reg_file.cur_value2 = reg_rd.cur_value2;
	reg_file.cur_range3 = reg_rd.cur_range3;
	reg_file.cur_value3 = reg_rd.cur_value3;
	reg_file.rs485_modbus_addr = reg_rd.rs485_modbus_addr;
	reg_file.rs485_line_speed = reg_rd.rs485_line_speed;
	reg_file.rs485_line_parity = reg_rd.rs485_line_parity;
	reg_file.eth_mac_addr0 = reg_rd.eth_mac_addr0;
	reg_file.eth_mac_addr1 = reg_rd.eth_mac_addr1;
	reg_file.eth_mac_addr2 = reg_rd.eth_mac_addr2;
	reg_file.eth_hostname0 = reg_rd.eth_hostname0;
	reg_file.eth_hostname1 = reg_rd.eth_hostname1;
	reg_file.eth_hostname2 = reg_rd.eth_hostname2;
	reg_file.eth_hostname3 = reg_rd.eth_hostname3;
	reg_file.eth_hostname4 = reg_rd.eth_hostname4;
	reg_file.eth_hostname5 = reg_rd.eth_hostname5;
	reg_file.eth_hostname6 = reg_rd.eth_hostname6;
	reg_file.eth_hostname7 = reg_rd.eth_hostname7;
	reg_file.eth_dhcp_enable = reg_rd.eth_dhcp_enable;
	reg_file.eth_ip_addr_hi = reg_rd.eth_ip_addr_hi;
	reg_file.eth_ip_addr_lo = reg_rd.eth_ip_addr_lo;
	reg_file.eth_subnet_mask_hi = reg_rd.eth_subnet_mask_hi;
	reg_file.eth_subnet_mask_lo = reg_rd.eth_subnet_mask_lo;
	reg_file.eth_def_gateway_hi = reg_rd.eth_def_gateway_hi;
	reg_file.eth_def_gateway_lo = reg_rd.eth_def_gateway_lo;
	reg_file.eth_pri_dns_hi = reg_rd.eth_pri_dns_hi;
	reg_file.eth_pri_dns_lo = reg_rd.eth_pri_dns_lo;
	reg_file.eth_sec_dns_hi = reg_rd.eth_sec_dns_hi;
	reg_file.eth_sec_dns_lo = reg_rd.eth_sec_dns_lo;
	reg_file.eth_modbus_addr = reg_rd.eth_modbus_addr;
	reg_file.eth_modbus_tcp_port = reg_rd.eth_modbus_tcp_port;
	reg_file.eth_modbus_udp_port = reg_rd.eth_modbus_udp_port;
	reg_file.web_password0 = reg_rd.web_password0;
	reg_file.web_password1 = reg_rd.web_password1;
	reg_file.web_password2 = reg_rd.web_password2;
	reg_file.web_password3 = reg_rd.web_password3;

	/* write data to file */
	if (fwrite(&reg_file, sizeof(reg_file), 1, p_file) != 1) {
		printf("unable to write to file %s\n", p_file_name);
		goto exit;
	}
	printf("data written to file \"%s\"\n", p_file_name);

exit:
	if (p_file != NULL) fclose(p_file);
	return err;
}

/* write all the general purpose registers with data read from disk file */
int ltdve4ch_menu_write_gen_reg_file(modbus_t *p_modbus, char *p_file_name)
{
	int err = 0;
	int print = 0;
	ltdve4ch_reg_wr_t reg_wr;
	ltdve4ch_reg_file_t reg_file;
	FILE *p_file = NULL;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_file_name == NULL) { err = 1; printf("bad parameter p_file_name\n"); goto exit; }

	/* open disk file for reading */
	if (fopen_s(&p_file, p_file_name, "rb") != 0) {
		printf("unable to open file %s for reading\n", p_file_name);
		goto exit;
	}

	/* read data from file */
	if (fread(&reg_file, sizeof(reg_file), 1, p_file) != 1) {
		printf("unable to read from file %s\n", p_file_name);
		goto exit;
	}
	printf("data read from file \"%s\"\n", p_file_name);

	/* check header */
	if ((reg_file.magic0 != LTDVE4CH_FILE_MAGIC0) || (reg_file.magic1 != LTDVE4CH_FILE_MAGIC1)) {
		printf("bad header in file %s\n", p_file_name);
		goto exit;
	}

	/* prepare data for writing to device */
	reg_wr.osc_period = reg_file.osc_period;
	reg_wr.filter_sel0 = reg_file.filter_sel0;
	reg_wr.filter_sel1 = reg_file.filter_sel1;
	reg_wr.filter_sel2 = reg_file.filter_sel2;
	reg_wr.filter_sel3 = reg_file.filter_sel3;
	reg_wr.input_sel0 = reg_file.input_sel0;
	reg_wr.input_sel1 = reg_file.input_sel1;
	reg_wr.input_sel2 = reg_file.input_sel2;
	reg_wr.input_sel3 = reg_file.input_sel3;
	reg_wr.input_sel4 = reg_file.input_sel4;
	reg_wr.input_sel5 = reg_file.input_sel5;
	reg_wr.input_sel6 = reg_file.input_sel6;
	reg_wr.input_sel7 = reg_file.input_sel7;
	reg_wr.gen_dly_base0 = reg_file.gen_dly_base0;
	reg_wr.gen_dly_cnt0 = reg_file.gen_dly_cnt0;
	reg_wr.gen_wdt_base0 = reg_file.gen_wdt_base0;
	reg_wr.gen_wdt_cnt0 = reg_file.gen_wdt_cnt0;
	reg_wr.gen_dly_base1 = reg_file.gen_dly_base1;
	reg_wr.gen_dly_cnt1 = reg_file.gen_dly_cnt1;
	reg_wr.gen_wdt_base1 = reg_file.gen_wdt_base1;
	reg_wr.gen_wdt_cnt1 = reg_file.gen_wdt_cnt1;
	reg_wr.gen_dly_base2 = reg_file.gen_dly_base2;
	reg_wr.gen_dly_cnt2 = reg_file.gen_dly_cnt2;
	reg_wr.gen_wdt_base2 = reg_file.gen_wdt_base2;
	reg_wr.gen_wdt_cnt2 = reg_file.gen_wdt_cnt2;
	reg_wr.gen_dly_base3 = reg_file.gen_dly_base3;
	reg_wr.gen_dly_cnt3 = reg_file.gen_dly_cnt3;
	reg_wr.gen_wdt_base3 = reg_file.gen_wdt_base3;
	reg_wr.gen_wdt_cnt3 = reg_file.gen_wdt_cnt3;
	reg_wr.gen_dly_base4 = reg_file.gen_dly_base4;
	reg_wr.gen_dly_cnt4 = reg_file.gen_dly_cnt4;
	reg_wr.gen_wdt_base4 = reg_file.gen_wdt_base4;
	reg_wr.gen_wdt_cnt4 = reg_file.gen_wdt_cnt4;
	reg_wr.gen_dly_base5 = reg_file.gen_dly_base5;
	reg_wr.gen_dly_cnt5 = reg_file.gen_dly_cnt5;
	reg_wr.gen_wdt_base5 = reg_file.gen_wdt_base5;
	reg_wr.gen_wdt_cnt5 = reg_file.gen_wdt_cnt5;
	reg_wr.gen_dly_base6 = reg_file.gen_dly_base6;
	reg_wr.gen_dly_cnt6 = reg_file.gen_dly_cnt6;
	reg_wr.gen_wdt_base6 = reg_file.gen_wdt_base6;
	reg_wr.gen_wdt_cnt6 = reg_file.gen_wdt_cnt6;
	reg_wr.gen_dly_base7 = reg_file.gen_dly_base7;
	reg_wr.gen_dly_cnt7 = reg_file.gen_dly_cnt7;
	reg_wr.gen_wdt_base7 = reg_file.gen_wdt_base7;
	reg_wr.gen_wdt_cnt7 = reg_file.gen_wdt_cnt7;
	reg_wr.output_sel_hi0 = reg_file.output_sel_hi0;
	reg_wr.output_sel_lo0 = reg_file.output_sel_lo0;
	reg_wr.output_sel_hi1 = reg_file.output_sel_hi1;
	reg_wr.output_sel_lo1 = reg_file.output_sel_lo1;
	reg_wr.output_sel_hi2 = reg_file.output_sel_hi2;
	reg_wr.output_sel_lo2 = reg_file.output_sel_lo2;
	reg_wr.output_sel_hi3 = reg_file.output_sel_hi3;
	reg_wr.output_sel_lo3 = reg_file.output_sel_lo3;
	reg_wr.output_sel_hi8 = reg_file.output_sel_hi8;
	reg_wr.output_sel_lo8 = reg_file.output_sel_lo8;
	reg_wr.output_sel_hi9 = reg_file.output_sel_hi9;
	reg_wr.output_sel_lo9 = reg_file.output_sel_lo9;
	reg_wr.output_sel_hi10 = reg_file.output_sel_hi10;
	reg_wr.output_sel_lo10 = reg_file.output_sel_lo10;
	reg_wr.output_sel_hi11 = reg_file.output_sel_hi11;
	reg_wr.output_sel_lo11 = reg_file.output_sel_lo11;
	reg_wr.prt_cnt_on0 = reg_file.prt_cnt_on0;
	reg_wr.prt_ena_on0 = reg_file.prt_ena_on0;
	reg_wr.prt_cnt_off0 = reg_file.prt_cnt_off0;
	reg_wr.prt_ena_off0 = reg_file.prt_ena_off0;
	reg_wr.prt_cnt_on1 = reg_file.prt_cnt_on1;
	reg_wr.prt_ena_on1 = reg_file.prt_ena_on1;
	reg_wr.prt_cnt_off1 = reg_file.prt_cnt_off1;
	reg_wr.prt_ena_off1 = reg_file.prt_ena_off1;
	reg_wr.prt_cnt_on2 = reg_file.prt_cnt_on2;
	reg_wr.prt_ena_on2 = reg_file.prt_ena_on2;
	reg_wr.prt_cnt_off2 = reg_file.prt_cnt_off2;
	reg_wr.prt_ena_off2 = reg_file.prt_ena_off2;
	reg_wr.prt_cnt_on3 = reg_file.prt_cnt_on3;
	reg_wr.prt_ena_on3 = reg_file.prt_ena_on3;
	reg_wr.prt_cnt_off3 = reg_file.prt_cnt_off3;
	reg_wr.prt_ena_off3 = reg_file.prt_ena_off3;
	reg_wr.cur_range0 = reg_file.cur_range0;
	reg_wr.cur_value0 = reg_file.cur_value0;
	reg_wr.cur_range1 = reg_file.cur_range1;
	reg_wr.cur_value1 = reg_file.cur_value1;
	reg_wr.cur_range2 = reg_file.cur_range2;
	reg_wr.cur_value2 = reg_file.cur_value2;
	reg_wr.cur_range3 = reg_file.cur_range3;
	reg_wr.cur_value3 = reg_file.cur_value3;
	reg_wr.rs485_modbus_addr = reg_file.rs485_modbus_addr;
	reg_wr.rs485_line_speed = reg_file.rs485_line_speed;
	reg_wr.rs485_line_parity = reg_file.rs485_line_parity;
	reg_wr.eth_mac_addr0 = reg_file.eth_mac_addr0;
	reg_wr.eth_mac_addr1 = reg_file.eth_mac_addr1;
	reg_wr.eth_mac_addr2 = reg_file.eth_mac_addr2;
	reg_wr.eth_hostname0 = reg_file.eth_hostname0;
	reg_wr.eth_hostname1 = reg_file.eth_hostname1;
	reg_wr.eth_hostname2 = reg_file.eth_hostname2;
	reg_wr.eth_hostname3 = reg_file.eth_hostname3;
	reg_wr.eth_hostname4 = reg_file.eth_hostname4;
	reg_wr.eth_hostname5 = reg_file.eth_hostname5;
	reg_wr.eth_hostname6 = reg_file.eth_hostname6;
	reg_wr.eth_hostname7 = reg_file.eth_hostname7;
	reg_wr.eth_dhcp_enable = reg_file.eth_dhcp_enable;
	reg_wr.eth_ip_addr_hi = reg_file.eth_ip_addr_hi;
	reg_wr.eth_ip_addr_lo = reg_file.eth_ip_addr_lo;
	reg_wr.eth_subnet_mask_hi = reg_file.eth_subnet_mask_hi;
	reg_wr.eth_subnet_mask_lo = reg_file.eth_subnet_mask_lo;
	reg_wr.eth_def_gateway_hi = reg_file.eth_def_gateway_hi;
	reg_wr.eth_def_gateway_lo = reg_file.eth_def_gateway_lo;
	reg_wr.eth_pri_dns_hi = reg_file.eth_pri_dns_hi;
	reg_wr.eth_pri_dns_lo = reg_file.eth_pri_dns_lo;
	reg_wr.eth_sec_dns_hi = reg_file.eth_sec_dns_hi;
	reg_wr.eth_sec_dns_lo = reg_file.eth_sec_dns_lo;
	reg_wr.eth_modbus_addr = reg_file.eth_modbus_addr;
	reg_wr.eth_modbus_tcp_port = reg_file.eth_modbus_tcp_port;
	reg_wr.eth_modbus_udp_port = reg_file.eth_modbus_udp_port;
	reg_wr.web_password0 = reg_file.web_password0;
	reg_wr.web_password1 = reg_file.web_password1;
	reg_wr.web_password2 = reg_file.web_password2;
	reg_wr.web_password3 = reg_file.web_password3;

	/* write registers to device */
	printf("writing registers to device...\n");
	if ((err = ltdve4ch_gen_reg_wr(p_modbus, &reg_wr, print, 0)) != 0) {
		printf("error in ltdve4ch_gen_reg_wr() call\n");
		goto exit;
	}
	printf("registers written to device\n");

	/* store registers in non-volatile memory */
	printf("storing registers to non-volatile memory...\n");
	if ((err = ltdve4ch_menu_write_brd_cmd(p_modbus, 2)) != 0) {
		printf("error in ltdve4ch_menu_write_brd_cmd() call\n");
		goto exit;
	}
	printf("registers stored to non-volatile memory\n");

exit:
	if (p_file != NULL) fclose(p_file);
	return err;
}

/* program menu */
int ltdve4ch_menu_run(int use_ethernet)
{
	modbus_t modbus;
	int err = 0;
	int quit = 0;
	char file_name[] = "LTDVE4CH.dat";

	/* communication parameters */
	LPCWSTR p_ser_port = MODBUS_COM;
	int modbus_addr = MODBUS_ADR;
	char *p_eth_board_ip_address = BOARD_IP_ADDRESS;
	char *p_eth_board_port_number = BOARD_PORT_NUMBER;

	if (p_ser_port == NULL) { err = 1; printf("bad parameter p_ser_port\n"); goto exit; }
	if (modbus_addr < 0) { err = 1; printf("bad parameter modbus_addr\n"); goto exit; }
	if (p_eth_board_ip_address == NULL) { err = 1; printf("bad parameter p_eth_board_ip_address\n"); goto exit; }
	if (p_eth_board_port_number == NULL) { err = 1; printf("bad parameter p_eth_board_port_number\n"); goto exit; }

	if ((err = modbus_init(&modbus)) != 0) {
		printf("error in modbus_init() call\n");
		goto exit;
	}

	if (use_ethernet == 0) {
		if ((err = modbus_open_ser(&modbus, p_ser_port)) != 0) {
			printf("error in modbus_open_ser() call\n");
			goto exit;
		}

		if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_SER_485)) != 0) {
			printf("error in modbus_sel_mode() call\n");
			goto exit;
		}
	}
	else {
		if ((err = modbus_open_eth(&modbus, p_eth_board_ip_address, p_eth_board_port_number)) != 0) {
			printf("error in modbus_open_eth() call\n");
			goto exit;
		}

		if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_ETH_TCP)) != 0) {
			printf("error in modbus_sel_mode() call\n");
			goto exit;
		}
	}

	if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
		printf("error in modbus_sel_addr() call\n");
		goto exit;
	}

	while (!quit) {
		printf(
			"\n"
			"LTDVE4CH demonstration program\n"
			"==============================\n"
			"\n"
			"0) Quit\n"
			"1) Read registers\n"
			"2) Write registers with factory configuration\n"
			"3) Write registers with test configuration\n"
			"4) Write registers with EMC configuration\n"
			"5) Load registers from non-volatile memory\n"
			"6) Store registers to non-volatile memory\n"
			"7) Reboot device\n"
			"8) Read registers and save data to disk file \"%s\"\n"
			"9) Write registers with data loaded from disk file \"%s\" and store to non-volatile memory\n"
			"\n"
			"Choose: ", file_name, file_name
			);

		switch (menu_wait_selection()) {
		case 0:
			quit = 1;
			break;
		case 1:
			if ((err = ltdve4ch_menu_read_gen_reg(&modbus, 1, 1)) != 0) {
				printf("error in ltdve4ch_menu_read_gen_reg() call\n");
				goto exit;
			}
			break;
		case 2:
			if ((err = ltdve4ch_menu_write_gen_reg(&modbus, 0)) != 0) {
				printf("error in ltdve4ch_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 3:
			if ((err = ltdve4ch_menu_write_gen_reg(&modbus, 1)) != 0) {
				printf("error in ltdve4ch_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 4:
			if ((err = ltdve4ch_menu_write_gen_reg(&modbus, 2)) != 0) {
				printf("error in ltdve4ch_menu_write_gen_reg() call\n");
				goto exit;
			}
			break;
		case 5:
			if ((err = ltdve4ch_menu_write_brd_cmd(&modbus, 1)) != 0) {
				printf("error in ltdve4ch_menu_write_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 6:
			if ((err = ltdve4ch_menu_write_brd_cmd(&modbus, 2)) != 0) {
				printf("error in ltdve4ch_menu_write_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 7:
			if ((err = ltdve4ch_menu_write_brd_cmd(&modbus, 3)) != 0) {
				printf("error in ltdve4ch_menu_brd_cmd() call\n");
				goto exit;
			}
			break;
		case 8:
			if ((err = ltdve4ch_menu_read_gen_reg_file(&modbus, file_name)) != 0) {
				printf("error in ltdve4ch_menu_read_gen_reg_file() call\n");
				goto exit;
			}
			break;
		case 9:
			if ((err = ltdve4ch_menu_write_gen_reg_file(&modbus, file_name)) != 0) {
				printf("error in ltdve4ch_menu_write_gen_reg_file() call\n");
				goto exit;
			}
			break;
		default:
			break;
		}
	}

	if ((err = modbus_close_ser(&modbus)) != 0) {
		printf("error in modbus_close_ser() call\n");
		goto exit;
	}

	if ((err = modbus_close_eth(&modbus)) != 0) {
		printf("error in modbus_close_eth() call\n");
		goto exit;
	}

exit:
	return err;
}

/* test communication interfaces */
int ltdve4ch_menu_test_communication(int test_serial, int test_ethernet)
{
	modbus_t modbus;
	int err = 0;
	int quit = 0;
	int err_eth = 0;
	int err_ser = 0;

	/* communication parameters */
	LPCWSTR p_ser_port = MODBUS_COM;
	int modbus_addr = MODBUS_ADR;
	char *p_eth_board_ip_address = BOARD_IP_ADDRESS;
	char *p_eth_board_port_number = BOARD_PORT_NUMBER;

	if (p_ser_port == NULL) { err = 1; printf("bad parameter p_ser_port\n"); goto exit; }
	if (modbus_addr < 0) { err = 1; printf("bad parameter modbus_addr\n"); goto exit; }
	if (p_eth_board_ip_address == NULL) { err = 1; printf("bad parameter p_eth_board_ip_address\n"); goto exit; }
	if (p_eth_board_port_number == NULL) { err = 1; printf("bad parameter p_eth_board_port_number\n"); goto exit; }

	while (1) {
		if (test_serial != 0) {
			printf("\n");
			printf("**********************************\n");
			printf("* Serial port communication test *\n");
			printf("**********************************\n");
			printf("\n");

			if ((err = modbus_init(&modbus)) != 0) {
				printf("error in modbus_init() call\n");
				goto exit;
			}

			if ((err = modbus_open_ser(&modbus, p_ser_port)) != 0) {
				printf("error in modbus_open_ser() call\n");
				err_ser++;
				//goto exit;
			}
			printf("\n");

			if (modbus.ser_initialized != 0) {
				if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
					printf("error in modbus_sel_addr() call\n");
					goto exit;
				}

				if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_SER_485)) != 0) {
					printf("error in modbus_sel_mode() call\n");
					goto exit;
				}

				if ((err = ltdve4ch_menu_read_gen_reg(&modbus, 0, 0)) != 0) {
					printf("error in ltdve4ch_menu_read_gen_reg() call\n");
					err_ser++;
					//goto exit;
				}
				printf("\n");

				if ((err = modbus_close_ser(&modbus)) != 0) {
					printf("error in modbus_close_ser() call\n");
					goto exit;
				}
				printf("\n");
			}
			printf("Cumulative error count for serial interface = %d\n", err_ser);
			printf("\n");

			/* 1000ms delay */
			Sleep(1000);

			if (_kbhit()) { _getch(); break; }
		}

		if (test_ethernet != 0) {
			printf("\n");
			printf("************************************\n");
			printf("* Ethernet port communication test *\n");
			printf("************************************\n");
			printf("\n");

			if ((err = modbus_init(&modbus)) != 0) {
				printf("error in modbus_init() call\n");
				goto exit;
			}

			if ((err = modbus_open_eth(&modbus, p_eth_board_ip_address, p_eth_board_port_number)) != 0) {
				printf("error in modbus_open_eth() call\n");
				err_eth++;
				//goto exit;
			}
			printf("\n");

			if (modbus.eth_initialized != 0) {
				if ((err = modbus_sel_addr(&modbus, modbus_addr)) != 0) {
					printf("error in modbus_sel_addr() call\n");
					goto exit;
				}

				if ((err = modbus_sel_mode(&modbus, MODBUS_MODE_ETH_TCP)) != 0) {
					printf("error in modbus_sel_mode() call\n");
					goto exit;
				}

				if ((err = ltdve4ch_menu_read_gen_reg(&modbus, 0, 0)) != 0) {
					printf("error in ltdve4ch_menu_read_gen_reg() call\n");
					err_eth++;
					//goto exit;
				}
				printf("\n");

				if ((err = modbus_close_eth(&modbus)) != 0) {
					printf("error in modbus_com_close_eth() call\n");
					goto exit;
				}
				printf("\n");
			}
			printf("Cumulative error count for ethernet interface = %d\n", err_eth);
			printf("\n");

			/* 1000ms delay */
			Sleep(1000);

			if (_kbhit()) { _getch(); break; }
		}
	}

exit:
	return err;
}

/* file ends here */
