/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "modbus.h"
#include "menu.h"
#include "menu_ltdv6ch.h"
#include "menu_ltdve2ch.h"
#include "menu_ltdve4ch.h"
#include "menu_ltdve8ch.h"
#include "menu_ltic1ch-d1-4.h"

/* wait for user input */
int menu_wait_selection()
{
#if 1
	char buf[256];
	int value = -1;

	fflush(stdout);
	gets_s(buf, sizeof(buf));
	sscanf_s(buf, "%d", &value);

	return value;
#endif
}

/* program menu */
int menu_run()
{
	int err = 0;
	int quit = 0;

	while (!quit) {
		printf(
			"\n"
			"Device test program\n"
			"===================\n"
			"\n"
			" 0) Quit\n"
			" 1) Open communication with LTDV6CH using RS485 Modbus/RTU\n"
			" 2) Open communication with LTDVE2CH-20 using RS485 Modbus/RTU\n"
			" 3) Open communication with LTDVE2CH-20 using Ethernet Modbus/TCP\n"
			" 4) Open communication with LTDVE4CH-20 using RS485 Modbus/RTU\n"
			" 5) Open communication with LTDVE4CH-20 using Ethernet Modbus/TCP\n"
			" 6) Open communication with LTDVE8CH-20 using RS485 Modbus/RTU\n"
			" 7) Open communication with LTDVE8CH-20 using Ethernet Modbus/TCP\n"
			" 8) Open communication with LTIC1CH-D1-4 using RS485 Modbus/RTU\n"
			" 9) Open communication with LTIC1CH-D1-4 using Ethernet Modbus/TCP\n"
			"\n"
			"Choose: "
			);

		switch (menu_wait_selection()) {
		case 0:
			quit = 1;
			break;
		case 1:
			if ((err = ltdv6ch_menu_run()) != 0) {
				printf("error in ltdv6ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 2:
			if ((err = ltdve2ch_menu_run(0)) != 0) {
				printf("error in ltdve2ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 3:
			if ((err = ltdve2ch_menu_run(1)) != 0) {
				printf("error in ltdve2ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 4:
			if ((err = ltdve4ch_menu_run(0)) != 0) {
				printf("error in ltdve4ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 5:
			if ((err = ltdve4ch_menu_run(1)) != 0) {
				printf("error in ltdve4ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 6:
			if ((err = ltdve8ch_menu_run(0)) != 0) {
				printf("error in ltdve8ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 7:
			if ((err = ltdve8ch_menu_run(1)) != 0) {
				printf("error in ltdve8ch_menu_run() call\n");
				goto exit;
			}
			break;
		case 8:
			if ((err = ltic1ch_d1_4_menu_run(0)) != 0) {
				printf("error in ltic1ch_d1_4_menu_run() call\n");
				goto exit;
			}
			break;
		case 9:
			if ((err = ltic1ch_d1_4_menu_run(1)) != 0) {
				printf("error in ltic1ch_d1_4_menu_run() call\n");
				goto exit;
			}
			break;
		}
	}

exit:
	return err;
}

/* file ends here */
