/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#define FORCE_RANGE(v, a, b) ((v) < (a) ? (a) : ((v) > (b) ? (b) : (v)))

/* register file */
#define LTIC1CH_D1_4_ADR_DEVICE_TYPE			(0)
#define LTIC1CH_D1_4_ADR_BOOT_VERSION			(1)
#define LTIC1CH_D1_4_ADR_MCU_VERSION			(2)
#define LTIC1CH_D1_4_ADR_FPGA_VERSION			(3)
#define LTIC1CH_D1_4_ADR_BOARD_VERSION			(4)
#define LTIC1CH_D1_4_ADR_ENABLE_CONTROL			(5)
#define LTIC1CH_D1_4_ADR_CURRENT_CONTROL		(6)
#define LTIC1CH_D1_4_ADR_CURRENT_RANGE			(7)
#define LTIC1CH_D1_4_ADR_CURRENT_PRESET			(8)
#define LTIC1CH_D1_4_ADR_FAULT_CONTROL			(9)
#define LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_LOW	(10)
#define LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_HIGH	(11)
#define LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_LOW	(12)
#define LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_HIGH	(13)
#define LTIC1CH_D1_4_ADR_FAN_CONTROL			(14)
#define LTIC1CH_D1_4_ADR_FAN_TMP_LOW			(15)
#define LTIC1CH_D1_4_ADR_FAN_TMP_HIGH			(16)
#define LTIC1CH_D1_4_ADR_FAN_DUTY_INF			(17)
#define LTIC1CH_D1_4_ADR_FAN_DUTY_SUP			(18)
#define LTIC1CH_D1_4_ADR_FAN_DUTY_MIN			(19)
#define LTIC1CH_D1_4_ADR_FAN_DUTY_MAX			(20)
#define LTIC1CH_D1_4_ADR_FAN_DUTY_MANUAL		(21)
#define LTIC1CH_D1_4_ADR_FAN_PWM_FREQUENCY		(22)
#define LTIC1CH_D1_4_ADR_OSC_CONTROL			(23)
#define LTIC1CH_D1_4_ADR_OSC_FREQUENCY			(24)
#define LTIC1CH_D1_4_ADR_SPARE_SET0				(25)
#define LTIC1CH_D1_4_ADR_SPARE_SET1				(26)
#define LTIC1CH_D1_4_ADR_SPARE_SET2				(27)
#define LTIC1CH_D1_4_ADR_SPARE_SET3				(28)
#define LTIC1CH_D1_4_ADR_SPARE_SET4				(29)
#define LTIC1CH_D1_4_ADR_SPARE_SET5				(30)
#define LTIC1CH_D1_4_ADR_SPARE_SET6				(31)
#define LTIC1CH_D1_4_ADR_SPARE_SET7				(32)
#define LTIC1CH_D1_4_ADR_SPARE_SET8				(33)
#define LTIC1CH_D1_4_ADR_SPARE_SET9				(34)
#define LTIC1CH_D1_4_ADR_SPARE_SET10			(35)
#define LTIC1CH_D1_4_ADR_SPARE_SET11			(36)
#define LTIC1CH_D1_4_ADR_SPARE_SET12			(37)
#define LTIC1CH_D1_4_ADR_SPARE_SET13			(38)
#define LTIC1CH_D1_4_ADR_SPARE_SET14			(39)
#define LTIC1CH_D1_4_ADR_SPARE_SET15			(40)
#define LTIC1CH_D1_4_ADR_RS485_MODBUS_ADDR		(41)
#define LTIC1CH_D1_4_ADR_RS485_LINE_SPEED		(42)
#define LTIC1CH_D1_4_ADR_RS485_LINE_PARITY		(43)
#define LTIC1CH_D1_4_ADR_ETH_MAC_ADDR0			(44)
#define LTIC1CH_D1_4_ADR_ETH_MAC_ADDR1			(45)
#define LTIC1CH_D1_4_ADR_ETH_MAC_ADDR2			(46)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME0			(47)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME1			(48)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME2			(49)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME3			(50)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME4			(51)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME5			(52)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME6			(53)
#define LTIC1CH_D1_4_ADR_ETH_HOSTNAME7			(54)
#define LTIC1CH_D1_4_ADR_ETH_DHCP_ENABLE		(55)
#define LTIC1CH_D1_4_ADR_ETH_IP_ADDR_HI			(56)
#define LTIC1CH_D1_4_ADR_ETH_IP_ADDR_LO			(57)
#define LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_HI		(58)
#define LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_LO		(59)
#define LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_HI		(60)
#define LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_LO		(61)
#define LTIC1CH_D1_4_ADR_ETH_PRI_DNS_HI			(62)
#define LTIC1CH_D1_4_ADR_ETH_PRI_DNS_LO			(63)
#define LTIC1CH_D1_4_ADR_ETH_SEC_DNS_HI			(64)
#define LTIC1CH_D1_4_ADR_ETH_SEC_DNS_LO			(65)
#define LTIC1CH_D1_4_ADR_ETH_MODBUS_ADDR		(66)
#define LTIC1CH_D1_4_ADR_ETH_MODBUS_TCP_PORT	(67)
#define LTIC1CH_D1_4_ADR_ETH_MODBUS_UDP_PORT	(68)
#define LTIC1CH_D1_4_ADR_WEB_PASSWORD0			(69)
#define LTIC1CH_D1_4_ADR_WEB_PASSWORD1			(70)
#define LTIC1CH_D1_4_ADR_WEB_PASSWORD2			(71)
#define LTIC1CH_D1_4_ADR_WEB_PASSWORD3			(72)
#define LTIC1CH_D1_4_ADR_BOARD_TEMPERATURE		(73)
#define LTIC1CH_D1_4_ADR_LIGHT_TEMPERATURE		(74)
#define LTIC1CH_D1_4_ADR_SUPPLY_VOLTAGE			(75)
#define LTIC1CH_D1_4_ADR_DRIVER_CURRENT			(76)
#define LTIC1CH_D1_4_ADR_FAN_VOLTAGE			(77)
#define LTIC1CH_D1_4_ADR_INTERNAL_VOLTAGE		(78)
#define LTIC1CH_D1_4_ADR_LIGHT_VOLTAGE			(79)
#define LTIC1CH_D1_4_ADR_LIGHT_CURRENT			(80)
#define LTIC1CH_D1_4_ADR_DIMMING_VOLTAGE		(81)
#define LTIC1CH_D1_4_ADR_DIPSWITCH_SETTING		(82)
#define LTIC1CH_D1_4_ADR_ENABLE_INPUT			(83)
#define LTIC1CH_D1_4_ADR_FAULT_FLAGS			(84)
#define LTIC1CH_D1_4_ADR_FAULT_OUTPUT			(85)
#define LTIC1CH_D1_4_ADR_SHUNT_SELECT			(86)
#define LTIC1CH_D1_4_ADR_SHUNT_RESISTANCE		(87)
#define LTIC1CH_D1_4_ADR_DAC_VALUE				(88)
#define LTIC1CH_D1_4_ADR_FAN_DUTY				(89)
#define LTIC1CH_D1_4_ADR_ERROR_WORD				(90)
#define LTIC1CH_D1_4_ADR_SPARE_GET0				(91)
#define LTIC1CH_D1_4_ADR_SPARE_GET1				(92)
#define LTIC1CH_D1_4_ADR_SPARE_GET2				(93)
#define LTIC1CH_D1_4_ADR_SPARE_GET3				(94)
#define LTIC1CH_D1_4_ADR_SPARE_GET4				(95)
#define LTIC1CH_D1_4_ADR_SPARE_GET5				(96)
#define LTIC1CH_D1_4_ADR_SPARE_GET6				(97)
#define LTIC1CH_D1_4_ADR_SPARE_GET7				(98)
#define LTIC1CH_D1_4_ADR_SPARE_GET8				(99)
#define LTIC1CH_D1_4_ADR_SPARE_GET9				(100)
#define LTIC1CH_D1_4_ADR_SPARE_GET10			(101)
#define LTIC1CH_D1_4_ADR_SPARE_GET11			(102)
#define LTIC1CH_D1_4_ADR_SPARE_GET12			(103)
#define LTIC1CH_D1_4_ADR_SPARE_GET13			(104)
#define LTIC1CH_D1_4_ADR_SPARE_GET14			(105)
#define LTIC1CH_D1_4_ADR_SPARE_GET15			(106)
#define LTIC1CH_D1_4_ADR_BOARD_COMMAND			(127)

/* general purpose read registers */
typedef struct {
	int device_type;
	int boot_version;
	int mcu_version;
	int fpga_version;
	int board_version;
	int enable_control;
	int current_control;
	int current_range;
	int current_preset;
	int fault_control;
	int fault_board_tmp_low;
	int fault_board_tmp_high;
	int fault_light_tmp_low;
	int fault_light_tmp_high;
	int fan_control;
	int fan_tmp_low;
	int fan_tmp_high;
	int fan_duty_inf;
	int fan_duty_sup;
	int fan_duty_min;
	int fan_duty_max;
	int fan_duty_manual;
	int fan_pwm_frequency;
	int osc_control;
	int osc_frequency;
	int spare_set0;
	int spare_set1;
	int spare_set2;
	int spare_set3;
	int spare_set4;
	int spare_set5;
	int spare_set6;
	int spare_set7;
	int spare_set8;
	int spare_set9;
	int spare_set10;
	int spare_set11;
	int spare_set12;
	int spare_set13;
	int spare_set14;
	int spare_set15;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
	int board_temperature;
	int light_temperature;
	int supply_voltage;
	int driver_current;
	int fan_voltage;
	int internal_voltage;
	int light_voltage;
	int light_current;
	int dimming_voltage;
	int dipswitch_setting;
	int enable_input;
	int fault_flags;
	int fault_output;
	int shunt_select;
	int shunt_resistance;
	int dac_value;
	int fan_duty;
	int error_word;
	int spare_get0;
	int spare_get1;
	int spare_get2;
	int spare_get3;
	int spare_get4;
	int spare_get5;
	int spare_get6;
	int spare_get7;
	int spare_get8;
	int spare_get9;
	int spare_get10;
	int spare_get11;
	int spare_get12;
	int spare_get13;
	int spare_get14;
	int spare_get15;
	int board_command;
}
ltic1ch_d1_4_reg_rd_t;

/* general purpose write registers */
typedef struct {
	int enable_control;
	int current_control;
	int current_range;
	int current_preset;
	int fault_control;
	int fault_board_tmp_low;
	int fault_board_tmp_high;
	int fault_light_tmp_low;
	int fault_light_tmp_high;
	int fan_control;
	int fan_tmp_low;
	int fan_tmp_high;
	int fan_duty_inf;
	int fan_duty_sup;
	int fan_duty_min;
	int fan_duty_max;
	int fan_duty_manual;
	int fan_pwm_frequency;
	int osc_control;
	int osc_frequency;
	int spare_set0;
	int spare_set1;
	int spare_set2;
	int spare_set3;
	int spare_set4;
	int spare_set5;
	int spare_set6;
	int spare_set7;
	int spare_set8;
	int spare_set9;
	int spare_set10;
	int spare_set11;
	int spare_set12;
	int spare_set13;
	int spare_set14;
	int spare_set15;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
}
ltic1ch_d1_4_reg_wr_t;

#define LTIC1CH_D1_4_FILE_MAGIC0 (0x76543210)
#define LTIC1CH_D1_4_FILE_MAGIC1 (0x00000009)

/* data stored in disk file */
typedef struct {
	int magic0;
	int magic1;
	int enable_control;
	int current_control;
	int current_range;
	int current_preset;
	int fault_control;
	int fault_board_tmp_low;
	int fault_board_tmp_high;
	int fault_light_tmp_low;
	int fault_light_tmp_high;
	int fan_control;
	int fan_tmp_low;
	int fan_tmp_high;
	int fan_duty_inf;
	int fan_duty_sup;
	int fan_duty_min;
	int fan_duty_max;
	int fan_duty_manual;
	int fan_pwm_frequency;
	int osc_control;
	int osc_frequency;
	int spare_set0;
	int spare_set1;
	int spare_set2;
	int spare_set3;
	int spare_set4;
	int spare_set5;
	int spare_set6;
	int spare_set7;
	int spare_set8;
	int spare_set9;
	int spare_set10;
	int spare_set11;
	int spare_set12;
	int spare_set13;
	int spare_set14;
	int spare_set15;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
}
ltic1ch_d1_4_reg_file_t;

/* read all the general purpose registers */
int ltic1ch_d1_4_gen_reg_rd(modbus_t *p_modbus, ltic1ch_d1_4_reg_rd_t *p_reg, int print, int read_all_regs);

/* write all the general purpose registers */
int ltic1ch_d1_4_gen_reg_wr(modbus_t *p_modbus, ltic1ch_d1_4_reg_wr_t *p_reg, int print, int write_cal_regs);

/* write the board command register */
int ltic1ch_d1_4_brd_cmd_wr(modbus_t *p_modbus, int reg_val);

/* file ends here */
