/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "modbus.h"
#include "dev_ltic1ch-d1-4.h"

/* read all the general purpose registers */
int ltic1ch_d1_4_gen_reg_rd(modbus_t *p_modbus, ltic1ch_d1_4_reg_rd_t *p_reg, int print, int read_all_regs)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	if ((err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_DEVICE_TYPE, 1, &p_reg->device_type, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DEVICE_TYPE\t\t = %d\n", p_reg->device_type);

	if ((err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_BOOT_VERSION, 1, &p_reg->boot_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("BOOT_VERSION\t\t = %d\n", p_reg->boot_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_MCU_VERSION, 1, &p_reg->mcu_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("MCU_VERSION\t\t = %d\n", p_reg->mcu_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FPGA_VERSION, 1, &p_reg->fpga_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("FPGA_VERSION\t\t = %d\n", p_reg->fpga_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_BOARD_VERSION, 1, &p_reg->board_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("BOARD_VERSION\t\t = %d\n", p_reg->board_version);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ENABLE_CONTROL, 1, &p_reg->enable_control, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ENABLE_CONTROL\t\t = %d\n", p_reg->enable_control);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_CONTROL, 1, &p_reg->current_control, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CURRENT_CONTROL\t\t = %d\n", p_reg->current_control);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_RANGE, 1, &p_reg->current_range, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CURRENT_RANGE\t\t = %d\n", p_reg->current_range);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_PRESET, 1, &p_reg->current_preset, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CURRENT_PRESET\t\t = %d => %.3f A\n", p_reg->current_preset, p_reg->current_preset / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_CONTROL, 1, &p_reg->fault_control, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_CONTROL\t\t = %d\n", p_reg->fault_control);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_LOW, 1, &p_reg->fault_board_tmp_low, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_BOARD_TMP_LOW\t = %d => %.1f C\n", p_reg->fault_board_tmp_low, p_reg->fault_board_tmp_low / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_HIGH, 1, &p_reg->fault_board_tmp_high, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_BOARD_TMP_HIGH\t = %d => %.1f C\n", p_reg->fault_board_tmp_high, p_reg->fault_board_tmp_high / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_LOW, 1, &p_reg->fault_light_tmp_low, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_LIGHT_TMP_LOW\t = %d => %.1f C\n", p_reg->fault_light_tmp_low, p_reg->fault_light_tmp_low / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_HIGH, 1, &p_reg->fault_light_tmp_high, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_LIGHT_TMP_HIGH\t = %d => %.1f C\n", p_reg->fault_light_tmp_high, p_reg->fault_light_tmp_high / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_CONTROL, 1, &p_reg->fan_control, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_CONTROL\t\t = %d\n", p_reg->fan_control);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_TMP_LOW, 1, &p_reg->fan_tmp_low, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_TMP_LOW\t\t = %d => %.1f C\n", p_reg->fan_tmp_low, p_reg->fan_tmp_low / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_TMP_HIGH, 1, &p_reg->fan_tmp_high, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_TMP_HIGH\t\t = %d => %.1f C\n", p_reg->fan_tmp_high, p_reg->fan_tmp_high / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_INF, 1, &p_reg->fan_duty_inf, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY_INF\t\t = %d\n", p_reg->fan_duty_inf);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_SUP, 1, &p_reg->fan_duty_sup, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY_SUP\t\t = %d\n", p_reg->fan_duty_sup);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MIN, 1, &p_reg->fan_duty_min, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY_MIN\t\t = %d\n", p_reg->fan_duty_min);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MAX, 1, &p_reg->fan_duty_max, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY_MAX\t\t = %d\n", p_reg->fan_duty_max);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MANUAL, 1, &p_reg->fan_duty_manual, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY_MANUAL\t\t = %d\n", p_reg->fan_duty_manual);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_PWM_FREQUENCY, 1, &p_reg->fan_pwm_frequency, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_PWM_FREQUENCY\t = %d => %d Hz\n", p_reg->fan_pwm_frequency, p_reg->fan_pwm_frequency);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_OSC_CONTROL, 1, &p_reg->osc_control, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OSC_CONTROL\t\t = %d\n", p_reg->osc_control);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_OSC_FREQUENCY, 1, &p_reg->osc_frequency, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OSC_FREQUENCY\t\t = %d => %.3f kHz\n", p_reg->osc_frequency, (float)p_reg->osc_frequency / 10);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET0, 1, &p_reg->spare_set0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET0\t\t = 0x%04X\n", p_reg->spare_set0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET1, 1, &p_reg->spare_set1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET1\t\t = 0x%04X\n", p_reg->spare_set1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET2, 1, &p_reg->spare_set2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET2\t\t = 0x%04X\n", p_reg->spare_set2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET3, 1, &p_reg->spare_set3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET3\t\t = 0x%04X\n", p_reg->spare_set3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET4, 1, &p_reg->spare_set4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET4\t\t = 0x%04X\n", p_reg->spare_set4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET5, 1, &p_reg->spare_set5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET5\t\t = 0x%04X\n", p_reg->spare_set5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET6, 1, &p_reg->spare_set6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET6\t\t = 0x%04X\n", p_reg->spare_set6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET7, 1, &p_reg->spare_set7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET7\t\t = 0x%04X\n", p_reg->spare_set7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET8, 1, &p_reg->spare_set8, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET8\t\t = 0x%04X\n", p_reg->spare_set8);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET9, 1, &p_reg->spare_set9, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET9\t\t = 0x%04X\n", p_reg->spare_set9);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET10, 1, &p_reg->spare_set10, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET10\t\t = 0x%04X\n", p_reg->spare_set10);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET11, 1, &p_reg->spare_set11, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET11\t\t = 0x%04X\n", p_reg->spare_set11);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET12, 1, &p_reg->spare_set12, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET12\t\t = 0x%04X\n", p_reg->spare_set12);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET13, 1, &p_reg->spare_set13, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET13\t\t = 0x%04X\n", p_reg->spare_set13);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET14, 1, &p_reg->spare_set14, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET14\t\t = 0x%04X\n", p_reg->spare_set14);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET15, 1, &p_reg->spare_set15, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_SET15\t\t = 0x%04X\n", p_reg->spare_set15);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_MODBUS_ADDR, 1, &p_reg->rs485_modbus_addr, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_MODBUS_ADDR\t = %d\n", p_reg->rs485_modbus_addr);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_LINE_SPEED, 1, &p_reg->rs485_line_speed, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_LINE_SPEED\t = %d\n", p_reg->rs485_line_speed);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_LINE_PARITY, 1, &p_reg->rs485_line_parity, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_LINE_PARITY\t = %d\n", p_reg->rs485_line_parity);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR0, 1, &p_reg->eth_mac_addr0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR0\t\t = 0x%04X\n", p_reg->eth_mac_addr0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR1, 1, &p_reg->eth_mac_addr1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR1\t\t = 0x%04X\n", p_reg->eth_mac_addr1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR2, 1, &p_reg->eth_mac_addr2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR2\t\t = 0x%04X\n", p_reg->eth_mac_addr2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME0, 1, &p_reg->eth_hostname0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME0\t\t = 0x%04X\n", p_reg->eth_hostname0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME1, 1, &p_reg->eth_hostname1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME1\t\t = 0x%04X\n", p_reg->eth_hostname1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME2, 1, &p_reg->eth_hostname2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME2\t\t = 0x%04X\n", p_reg->eth_hostname2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME3, 1, &p_reg->eth_hostname3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME3\t\t = 0x%04X\n", p_reg->eth_hostname3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME4, 1, &p_reg->eth_hostname4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME4\t\t = 0x%04X\n", p_reg->eth_hostname4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME5, 1, &p_reg->eth_hostname5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME5\t\t = 0x%04X\n", p_reg->eth_hostname5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME6, 1, &p_reg->eth_hostname6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME6\t\t = 0x%04X\n", p_reg->eth_hostname6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME7, 1, &p_reg->eth_hostname7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME7\t\t = 0x%04X\n", p_reg->eth_hostname7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DHCP_ENABLE, 1, &p_reg->eth_dhcp_enable, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DHCP_ENABLE\t\t = %d\n", p_reg->eth_dhcp_enable);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_IP_ADDR_HI, 1, &p_reg->eth_ip_addr_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_IP_ADDR_HI\t\t = 0x%04X\n", p_reg->eth_ip_addr_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_IP_ADDR_LO, 1, &p_reg->eth_ip_addr_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_IP_ADDR_LO\t\t = 0x%04X\n", p_reg->eth_ip_addr_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_HI, 1, &p_reg->eth_subnet_mask_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SUBNET_MASK_HI\t = 0x%04X\n", p_reg->eth_subnet_mask_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_LO, 1, &p_reg->eth_subnet_mask_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SUBNET_MASK_LO\t = 0x%04X\n", p_reg->eth_subnet_mask_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_HI, 1, &p_reg->eth_def_gateway_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DEF_GATEWAY_HI\t = 0x%04X\n", p_reg->eth_def_gateway_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_LO, 1, &p_reg->eth_def_gateway_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DEF_GATEWAY_LO\t = 0x%04X\n", p_reg->eth_def_gateway_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_PRI_DNS_HI, 1, &p_reg->eth_pri_dns_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_PRI_DNS_HI\t\t = 0x%04X\n", p_reg->eth_pri_dns_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_PRI_DNS_LO, 1, &p_reg->eth_pri_dns_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_PRI_DNS_LO\t\t = 0x%04X\n", p_reg->eth_pri_dns_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SEC_DNS_HI, 1, &p_reg->eth_sec_dns_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SEC_DNS_HI\t\t = 0x%04X\n", p_reg->eth_sec_dns_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SEC_DNS_LO, 1, &p_reg->eth_sec_dns_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SEC_DNS_LO\t\t = 0x%04X\n", p_reg->eth_sec_dns_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_ADDR, 1, &p_reg->eth_modbus_addr, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_ADDR\t\t = %d\n", p_reg->eth_modbus_addr);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_TCP_PORT, 1, &p_reg->eth_modbus_tcp_port, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_TCP_PORT\t = %d\n", p_reg->eth_modbus_tcp_port);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_UDP_PORT, 1, &p_reg->eth_modbus_udp_port, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_UDP_PORT\t = %d\n", p_reg->eth_modbus_udp_port);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD0, 1, &p_reg->web_password0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD0\t\t = 0x%04X\n", p_reg->web_password0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD1, 1, &p_reg->web_password1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD1\t\t = 0x%04X\n", p_reg->web_password1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD2, 1, &p_reg->web_password2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD2\t\t = 0x%04X\n", p_reg->web_password2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD3, 1, &p_reg->web_password3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD3\t\t = 0x%04X\n", p_reg->web_password3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_BOARD_TEMPERATURE, 1, &p_reg->board_temperature, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("BOARD_TEMPERATURE\t = %d => %.1f C\n", p_reg->board_temperature, p_reg->board_temperature / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_LIGHT_TEMPERATURE, 1, &p_reg->light_temperature, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("LIGHT_TEMPERATURE\t = %d => %.1f C\n", p_reg->light_temperature, p_reg->light_temperature / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SUPPLY_VOLTAGE, 1, &p_reg->supply_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SUPPLY_VOLTAGE\t\t = %d => %.1f V\n", p_reg->supply_voltage, p_reg->supply_voltage / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_DRIVER_CURRENT, 1, &p_reg->driver_current, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("DRIVER_CURRENT\t\t = %d => %.3f A\n", p_reg->driver_current, p_reg->driver_current / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_VOLTAGE, 1, &p_reg->fan_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_VOLTAGE\t\t = %d => %.1f V\n", p_reg->fan_voltage, p_reg->fan_voltage / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_INTERNAL_VOLTAGE, 1, &p_reg->internal_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INTERNAL_VOLTAGE\t = %d => %.1f V\n", p_reg->internal_voltage, p_reg->internal_voltage / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_LIGHT_VOLTAGE, 1, &p_reg->light_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("LIGHT_VOLTAGE\t\t = %d => %.1f V\n", p_reg->light_voltage, p_reg->light_voltage / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_LIGHT_CURRENT, 1, &p_reg->light_current, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("LIGHT_CURRENT\t\t = %d => %.3f A\n", p_reg->light_current, p_reg->light_current / 1000.0);
	
	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_DIMMING_VOLTAGE, 1, &p_reg->dimming_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("DIMMING_VOLTAGE\t\t = %d => %.1f V\n", p_reg->dimming_voltage, p_reg->dimming_voltage / 10.0);
	
	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_DIPSWITCH_SETTING, 1, &p_reg->dipswitch_setting, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("DIPSWITCH_SETTING\t = %d\n", p_reg->dipswitch_setting);
	
	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ENABLE_INPUT, 1, &p_reg->enable_input, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ENABLE_INPUT\t\t = %d\n", p_reg->enable_input);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_FLAGS, 1, &p_reg->fault_flags, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_FLAGS\t\t = %d\n", p_reg->fault_flags);
	
	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_OUTPUT, 1, &p_reg->fault_output, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAULT_OUTPUT\t\t = %d\n", p_reg->fault_output);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SHUNT_SELECT, 1, &p_reg->shunt_select, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SHUNT_SELECT\t\t = %d\n", p_reg->shunt_select);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SHUNT_RESISTANCE, 1, &p_reg->shunt_resistance, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SHUNT_RESISTANCE\t = %d => %.5f Ohm\n", p_reg->shunt_resistance, p_reg->shunt_resistance / 100000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_DAC_VALUE, 1, &p_reg->dac_value, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("DAC_VALUE\t\t = %d\n", p_reg->dac_value);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY, 1, &p_reg->fan_duty, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FAN_DUTY\t\t = %d\n", p_reg->fan_duty);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_ERROR_WORD, 1, &p_reg->error_word, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ERROR_WORD\t\t = 0x%04X\n", p_reg->error_word);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET0, 1, &p_reg->spare_get0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET0\t\t = 0x%04X %d\n", p_reg->spare_get0, p_reg->spare_get0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET1, 1, &p_reg->spare_get1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET1\t\t = 0x%04X %d\n", p_reg->spare_get1, p_reg->spare_get1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET2, 1, &p_reg->spare_get2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET2\t\t = 0x%04X %d\n", p_reg->spare_get2, p_reg->spare_get2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET3, 1, &p_reg->spare_get3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET3\t\t = 0x%04X %d\n", p_reg->spare_get3, p_reg->spare_get3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET4, 1, &p_reg->spare_get4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET4\t\t = 0x%04X %d\n", p_reg->spare_get4, p_reg->spare_get4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET5, 1, &p_reg->spare_get5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET5\t\t = 0x%04X %d\n", p_reg->spare_get5, p_reg->spare_get5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET6, 1, &p_reg->spare_get6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET6\t\t = 0x%04X %d\n", p_reg->spare_get6, p_reg->spare_get6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET7, 1, &p_reg->spare_get7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET7\t\t = 0x%04X %d\n", p_reg->spare_get7, p_reg->spare_get7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET8, 1, &p_reg->spare_get8, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET8\t\t = 0x%04X %d\n", p_reg->spare_get8, p_reg->spare_get8);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET9, 1, &p_reg->spare_get9, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET9\t\t = 0x%04X %d\n", p_reg->spare_get9, p_reg->spare_get9);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET10, 1, &p_reg->spare_get10, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET10\t\t = 0x%04X %d\n", p_reg->spare_get10, p_reg->spare_get10);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET11, 1, &p_reg->spare_get11, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET11\t\t = 0x%04X %d\n", p_reg->spare_get11, p_reg->spare_get11);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET12, 1, &p_reg->spare_get12, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET12\t\t = 0x%04X %d\n", p_reg->spare_get12, p_reg->spare_get12);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET13, 1, &p_reg->spare_get13, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET13\t\t = 0x%04X %d\n", p_reg->spare_get13, p_reg->spare_get13);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET14, 1, &p_reg->spare_get14, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET14\t\t = 0x%04X %d\n", p_reg->spare_get14, p_reg->spare_get14);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_GET15, 1, &p_reg->spare_get15, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SPARE_GET15\t\t = 0x%04X %d\n", p_reg->spare_get15, p_reg->spare_get15);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTIC1CH_D1_4_ADR_BOARD_COMMAND, 1, &p_reg->board_command, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("BOARD_COMMAND\t\t = %d\n", p_reg->board_command);

exit:
	return err;
}

/* write all the general purpose registers */
int ltic1ch_d1_4_gen_reg_wr(modbus_t *p_modbus, ltic1ch_d1_4_reg_wr_t *p_reg, int print, int write_cal_regs)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	p_reg->enable_control = FORCE_RANGE(p_reg->enable_control, 0, 65535);
	p_reg->current_control = FORCE_RANGE(p_reg->current_control, 0, 65535);
	p_reg->current_range = FORCE_RANGE(p_reg->current_range, 0, 65535);
	p_reg->current_preset = FORCE_RANGE(p_reg->current_preset, 0, 65535);
	p_reg->fault_control = FORCE_RANGE(p_reg->fault_control, 0, 65535);
	p_reg->fault_board_tmp_low = FORCE_RANGE(p_reg->fault_board_tmp_low, 0, 65535);
	p_reg->fault_board_tmp_high = FORCE_RANGE(p_reg->fault_board_tmp_high, 0, 65535);
	p_reg->fault_light_tmp_low = FORCE_RANGE(p_reg->fault_light_tmp_low, 0, 65535);
	p_reg->fault_light_tmp_high = FORCE_RANGE(p_reg->fault_light_tmp_high, 0, 65535);
	p_reg->fan_control = FORCE_RANGE(p_reg->fan_control, 0, 65535);
	p_reg->fan_tmp_low = FORCE_RANGE(p_reg->fan_tmp_low, 0, 65535);
	p_reg->fan_tmp_high = FORCE_RANGE(p_reg->fan_tmp_high, 0, 65535);
	p_reg->fan_duty_inf = FORCE_RANGE(p_reg->fan_duty_inf, 0, 65535);
	p_reg->fan_duty_sup = FORCE_RANGE(p_reg->fan_duty_sup, 0, 65535);
	p_reg->fan_duty_min = FORCE_RANGE(p_reg->fan_duty_min, 0, 65535);
	p_reg->fan_duty_max = FORCE_RANGE(p_reg->fan_duty_max, 0, 65535);
	p_reg->fan_duty_manual = FORCE_RANGE(p_reg->fan_duty_manual, 0, 65535);
	p_reg->fan_pwm_frequency = FORCE_RANGE(p_reg->fan_pwm_frequency, 0, 65535);
	p_reg->osc_control = FORCE_RANGE(p_reg->osc_control, 0, 65535);
	p_reg->osc_frequency = FORCE_RANGE(p_reg->osc_frequency, 0, 65535);
	p_reg->spare_set0 = FORCE_RANGE(p_reg->spare_set0, 0, 65535);
	p_reg->spare_set1 = FORCE_RANGE(p_reg->spare_set1, 0, 65535);
	p_reg->spare_set2 = FORCE_RANGE(p_reg->spare_set2, 0, 65535);
	p_reg->spare_set3 = FORCE_RANGE(p_reg->spare_set3, 0, 65535);
	p_reg->spare_set4 = FORCE_RANGE(p_reg->spare_set4, 0, 65535);
	p_reg->spare_set5 = FORCE_RANGE(p_reg->spare_set5, 0, 65535);
	p_reg->spare_set6 = FORCE_RANGE(p_reg->spare_set6, 0, 65535);
	p_reg->spare_set7 = FORCE_RANGE(p_reg->spare_set7, 0, 65535);
	p_reg->spare_set8 = FORCE_RANGE(p_reg->spare_set8, 0, 65535);
	p_reg->spare_set9 = FORCE_RANGE(p_reg->spare_set9, 0, 65535);
	p_reg->spare_set10 = FORCE_RANGE(p_reg->spare_set10, 0, 65535);
	p_reg->spare_set11 = FORCE_RANGE(p_reg->spare_set11, 0, 65535);
	p_reg->spare_set12 = FORCE_RANGE(p_reg->spare_set12, 0, 65535);
	p_reg->spare_set13 = FORCE_RANGE(p_reg->spare_set13, 0, 65535);
	p_reg->spare_set14 = FORCE_RANGE(p_reg->spare_set14, 0, 65535);
	p_reg->spare_set15 = FORCE_RANGE(p_reg->spare_set15, 0, 65535);
	p_reg->rs485_modbus_addr = FORCE_RANGE(p_reg->rs485_modbus_addr, 1, 247);
	p_reg->rs485_line_speed = FORCE_RANGE(p_reg->rs485_line_speed, 0, 65535);
	p_reg->rs485_line_parity = FORCE_RANGE(p_reg->rs485_line_parity, 0, 65535);
	p_reg->eth_mac_addr0 = FORCE_RANGE(p_reg->eth_mac_addr0, 0, 65535);
	p_reg->eth_mac_addr1 = FORCE_RANGE(p_reg->eth_mac_addr1, 0, 65535);
	p_reg->eth_mac_addr2 = FORCE_RANGE(p_reg->eth_mac_addr2, 0, 65535);
	p_reg->eth_hostname0 = FORCE_RANGE(p_reg->eth_hostname0, 0, 65535);
	p_reg->eth_hostname1 = FORCE_RANGE(p_reg->eth_hostname1, 0, 65535);
	p_reg->eth_hostname2 = FORCE_RANGE(p_reg->eth_hostname2, 0, 65535);
	p_reg->eth_hostname3 = FORCE_RANGE(p_reg->eth_hostname3, 0, 65535);
	p_reg->eth_hostname4 = FORCE_RANGE(p_reg->eth_hostname4, 0, 65535);
	p_reg->eth_hostname5 = FORCE_RANGE(p_reg->eth_hostname5, 0, 65535);
	p_reg->eth_hostname6 = FORCE_RANGE(p_reg->eth_hostname6, 0, 65535);
	p_reg->eth_hostname7 = FORCE_RANGE(p_reg->eth_hostname7, 0, 65535);
	p_reg->eth_dhcp_enable = FORCE_RANGE(p_reg->eth_dhcp_enable, 0, 65535);
	p_reg->eth_ip_addr_hi = FORCE_RANGE(p_reg->eth_ip_addr_hi, 0, 65535);
	p_reg->eth_ip_addr_lo = FORCE_RANGE(p_reg->eth_ip_addr_lo, 0, 65535);
	p_reg->eth_subnet_mask_hi = FORCE_RANGE(p_reg->eth_subnet_mask_hi, 0, 65535);
	p_reg->eth_subnet_mask_lo = FORCE_RANGE(p_reg->eth_subnet_mask_lo, 0, 65535);
	p_reg->eth_def_gateway_hi = FORCE_RANGE(p_reg->eth_def_gateway_hi, 0, 65535);
	p_reg->eth_def_gateway_lo = FORCE_RANGE(p_reg->eth_def_gateway_lo, 0, 65535);
	p_reg->eth_pri_dns_hi = FORCE_RANGE(p_reg->eth_pri_dns_hi, 0, 65535);
	p_reg->eth_pri_dns_lo = FORCE_RANGE(p_reg->eth_pri_dns_lo, 0, 65535);
	p_reg->eth_sec_dns_hi = FORCE_RANGE(p_reg->eth_sec_dns_hi, 0, 65535);
	p_reg->eth_sec_dns_lo = FORCE_RANGE(p_reg->eth_sec_dns_lo, 0, 65535);
	p_reg->eth_modbus_addr = FORCE_RANGE(p_reg->eth_modbus_addr, 1, 247);
	p_reg->eth_modbus_tcp_port = FORCE_RANGE(p_reg->eth_modbus_tcp_port, 1, 65535);
	p_reg->eth_modbus_udp_port = FORCE_RANGE(p_reg->eth_modbus_udp_port, 1, 65535);
	p_reg->web_password0 = FORCE_RANGE(p_reg->web_password0, 0, 65535);
	p_reg->web_password1 = FORCE_RANGE(p_reg->web_password1, 0, 65535);
	p_reg->web_password2 = FORCE_RANGE(p_reg->web_password2, 0, 65535);
	p_reg->web_password3 = FORCE_RANGE(p_reg->web_password3, 0, 65535);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ENABLE_CONTROL, 1, &p_reg->enable_control)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ENABLE_CONTROL\t\t = %d\n", p_reg->enable_control);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_CONTROL, 1, &p_reg->current_control)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CURRENT_CONTROL\t\t = %d\n", p_reg->current_control);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_RANGE, 1, &p_reg->current_range)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CURRENT_RANGE\t\t = %d\n", p_reg->current_range);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_CURRENT_PRESET, 1, &p_reg->current_preset)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CURRENT_PRESET\t\t = %d => %.3f A\n", p_reg->current_preset, p_reg->current_preset / 1000.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_CONTROL, 1, &p_reg->fault_control)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAULT_CONTROL\t\t = %d\n", p_reg->fault_control);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_LOW, 1, &p_reg->fault_board_tmp_low)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAULT_BOARD_TMP_LOW\t = %d => %.1f C\n", p_reg->fault_board_tmp_low, p_reg->fault_board_tmp_low / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_BOARD_TMP_HIGH, 1, &p_reg->fault_board_tmp_high)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAULT_BOARD_TMP_HIGH\t = %d => %.1f C\n", p_reg->fault_board_tmp_high, p_reg->fault_board_tmp_high / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_LOW, 1, &p_reg->fault_light_tmp_low)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAULT_LIGHT_TMP_LOW\t = %d => %.1f C\n", p_reg->fault_light_tmp_low, p_reg->fault_light_tmp_low / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAULT_LIGHT_TMP_HIGH, 1, &p_reg->fault_light_tmp_high)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAULT_LIGHT_TMP_HIGH\t = %d => %.1f C\n", p_reg->fault_light_tmp_high, p_reg->fault_light_tmp_high / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_CONTROL, 1, &p_reg->fan_control)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_CONTROL\t\t = %d\n", p_reg->fan_control);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_TMP_LOW, 1, &p_reg->fan_tmp_low)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_TMP_LOW\t\t = %d => %.1f C\n", p_reg->fan_tmp_low, p_reg->fan_tmp_low / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_TMP_HIGH, 1, &p_reg->fan_tmp_high)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_TMP_HIGH\t\t = %d => %.1f C\n", p_reg->fan_tmp_high, p_reg->fan_tmp_high / 10.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_INF, 1, &p_reg->fan_duty_inf)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_DUTY_INF\t\t = %d\n", p_reg->fan_duty_inf);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_SUP, 1, &p_reg->fan_duty_sup)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_DUTY_SUP\t\t = %d\n", p_reg->fan_duty_sup);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MIN, 1, &p_reg->fan_duty_min)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_DUTY_MIN\t\t = %d\n", p_reg->fan_duty_min);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MAX, 1, &p_reg->fan_duty_max)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_DUTY_MAX\t\t = %d\n", p_reg->fan_duty_max);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_DUTY_MANUAL, 1, &p_reg->fan_duty_manual)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_DUTY_MANUAL\t\t = %d\n", p_reg->fan_duty_manual);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_FAN_PWM_FREQUENCY, 1, &p_reg->fan_pwm_frequency)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FAN_PWM_FREQUENCY\t = %d => %d Hz\n", p_reg->fan_pwm_frequency, p_reg->fan_pwm_frequency);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_OSC_CONTROL, 1, &p_reg->osc_control)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OSC_CONTROL\t\t = %d\n", p_reg->osc_control);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_OSC_FREQUENCY, 1, &p_reg->osc_frequency)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OSC_FREQUENCY\t\t = %d => %.3f kHz\n", p_reg->osc_frequency, (float)p_reg->osc_frequency / 10);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET0, 1, &p_reg->spare_set0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET0\t\t = 0x%04X\n", p_reg->spare_set0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET1, 1, &p_reg->spare_set1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET1\t\t = 0x%04X\n", p_reg->spare_set1);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET2, 1, &p_reg->spare_set2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET2\t\t = 0x%04X\n", p_reg->spare_set2);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET3, 1, &p_reg->spare_set3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET3\t\t = 0x%04X\n", p_reg->spare_set3);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET4, 1, &p_reg->spare_set4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET4\t\t = 0x%04X\n", p_reg->spare_set4);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET5, 1, &p_reg->spare_set5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET5\t\t = 0x%04X\n", p_reg->spare_set5);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET6, 1, &p_reg->spare_set6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET6\t\t = 0x%04X\n", p_reg->spare_set6);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET7, 1, &p_reg->spare_set7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET7\t\t = 0x%04X\n", p_reg->spare_set7);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET8, 1, &p_reg->spare_set8)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET8\t\t = 0x%04X\n", p_reg->spare_set8);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET9, 1, &p_reg->spare_set9)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET9\t\t = 0x%04X\n", p_reg->spare_set9);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET10, 1, &p_reg->spare_set10)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET10\t\t = 0x%04X\n", p_reg->spare_set10);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET11, 1, &p_reg->spare_set11)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET11\t\t = 0x%04X\n", p_reg->spare_set11);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET12, 1, &p_reg->spare_set12)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET12\t\t = 0x%04X\n", p_reg->spare_set12);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET13, 1, &p_reg->spare_set13)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET13\t\t = 0x%04X\n", p_reg->spare_set13);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET14, 1, &p_reg->spare_set14)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET14\t\t = 0x%04X\n", p_reg->spare_set14);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_SPARE_SET15, 1, &p_reg->spare_set15)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("SPARE_SET15\t\t = 0x%04X\n", p_reg->spare_set15);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_MODBUS_ADDR, 1, &p_reg->rs485_modbus_addr)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_MODBUS_ADDR\t = %d\n", p_reg->rs485_modbus_addr);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_LINE_SPEED, 1, &p_reg->rs485_line_speed)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_LINE_SPEED\t = %d\n", p_reg->rs485_line_speed);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_RS485_LINE_PARITY, 1, &p_reg->rs485_line_parity)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_LINE_PARITY\t = %d\n", p_reg->rs485_line_parity);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR0, 1, &p_reg->eth_mac_addr0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR0\t\t = 0x%04X\n", p_reg->eth_mac_addr0);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR1, 1, &p_reg->eth_mac_addr1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR1\t\t = 0x%04X\n", p_reg->eth_mac_addr1);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MAC_ADDR2, 1, &p_reg->eth_mac_addr2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR2\t\t = 0x%04X\n", p_reg->eth_mac_addr2);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME0, 1, &p_reg->eth_hostname0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME0\t\t = 0x%04X\n", p_reg->eth_hostname0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME1, 1, &p_reg->eth_hostname1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME1\t\t = 0x%04X\n", p_reg->eth_hostname1);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME2, 1, &p_reg->eth_hostname2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME2\t\t = 0x%04X\n", p_reg->eth_hostname2);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME3, 1, &p_reg->eth_hostname3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME3\t\t = 0x%04X\n", p_reg->eth_hostname3);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME4, 1, &p_reg->eth_hostname4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME4\t\t = 0x%04X\n", p_reg->eth_hostname4);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME5, 1, &p_reg->eth_hostname5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME5\t\t = 0x%04X\n", p_reg->eth_hostname5);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME6, 1, &p_reg->eth_hostname6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME6\t\t = 0x%04X\n", p_reg->eth_hostname6);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_HOSTNAME7, 1, &p_reg->eth_hostname7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME7\t\t = 0x%04X\n", p_reg->eth_hostname7);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DHCP_ENABLE, 1, &p_reg->eth_dhcp_enable)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DHCP_ENABLE\t\t = %d\n", p_reg->eth_dhcp_enable);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_IP_ADDR_HI, 1, &p_reg->eth_ip_addr_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_IP_ADDR_HI\t\t = 0x%04X\n", p_reg->eth_ip_addr_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_IP_ADDR_LO, 1, &p_reg->eth_ip_addr_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_IP_ADDR_LO\t\t = 0x%04X\n", p_reg->eth_ip_addr_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_HI, 1, &p_reg->eth_subnet_mask_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SUBNET_MASK_HI\t = 0x%04X\n", p_reg->eth_subnet_mask_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SUBNET_MASK_LO, 1, &p_reg->eth_subnet_mask_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SUBNET_MASK_LO\t = 0x%04X\n", p_reg->eth_subnet_mask_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_HI, 1, &p_reg->eth_def_gateway_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DEF_GATEWAY_HI\t = 0x%04X\n", p_reg->eth_def_gateway_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_DEF_GATEWAY_LO, 1, &p_reg->eth_def_gateway_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DEF_GATEWAY_LO\t = 0x%04X\n", p_reg->eth_def_gateway_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_PRI_DNS_HI, 1, &p_reg->eth_pri_dns_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_PRI_DNS_HI\t\t = 0x%04X\n", p_reg->eth_pri_dns_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_PRI_DNS_LO, 1, &p_reg->eth_pri_dns_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_PRI_DNS_LO\t\t = 0x%04X\n", p_reg->eth_pri_dns_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SEC_DNS_HI, 1, &p_reg->eth_sec_dns_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SEC_DNS_HI\t\t = 0x%04X\n", p_reg->eth_sec_dns_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_SEC_DNS_LO, 1, &p_reg->eth_sec_dns_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SEC_DNS_LO\t\t = 0x%04X\n", p_reg->eth_sec_dns_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_ADDR, 1, &p_reg->eth_modbus_addr)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_ADDR\t\t = %d\n", p_reg->eth_modbus_addr);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_TCP_PORT, 1, &p_reg->eth_modbus_tcp_port)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_TCP_PORT\t = %d\n", p_reg->eth_modbus_tcp_port);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_ETH_MODBUS_UDP_PORT, 1, &p_reg->eth_modbus_udp_port)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_UDP_PORT\t = %d\n", p_reg->eth_modbus_udp_port);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD0, 1, &p_reg->web_password0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD0\t\t = 0x%04X\n", p_reg->web_password0);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD1, 1, &p_reg->web_password1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD1\t\t = 0x%04X\n", p_reg->web_password1);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD2, 1, &p_reg->web_password2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD2\t\t = 0x%04X\n", p_reg->web_password2);

	if ((err = modbus_reg_wr_group(p_modbus, LTIC1CH_D1_4_ADR_WEB_PASSWORD3, 1, &p_reg->web_password3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD3\t\t = 0x%04X\n", p_reg->web_password3);

exit:
	return err;
}

/* write the board command register */
int ltic1ch_d1_4_brd_cmd_wr(modbus_t *p_modbus, int reg_val)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (reg_val < 0) { err = 1; printf("bad parameter reg_val\n"); goto exit; }
	if (reg_val > 3) { err = 1; printf("bad parameter reg_val\n"); goto exit; }

	if ((err = modbus_reg_wr_single(p_modbus, LTIC1CH_D1_4_ADR_BOARD_COMMAND, reg_val)) != 0) {
		printf("error in modbus_reg_wr_single() call\n");
		goto exit;
	}

exit:
	return err;
}

/* file ends here */
