/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#define FORCE_RANGE(v, a, b) ((v) < (a) ? (a) : ((v) > (b) ? (b) : (v)))

/* register file */
#define LTDVE8CH_ADR_DEVICE_TYPE			(0)
#define LTDVE8CH_ADR_BOOT_VERSION			(1)
#define LTDVE8CH_ADR_MCU_VERSION			(2)
#define LTDVE8CH_ADR_FPGA_VERSION			(3)
#define LTDVE8CH_ADR_BOARD_VERSION			(4)
#define LTDVE8CH_ADR_OSC_PERIOD				(5)
#define LTDVE8CH_ADR_FILTER_SEL0			(6)
#define LTDVE8CH_ADR_FILTER_SEL1			(7)
#define LTDVE8CH_ADR_FILTER_SEL2			(8)
#define LTDVE8CH_ADR_FILTER_SEL3			(9)
#define LTDVE8CH_ADR_FILTER_SEL4			(10)
#define LTDVE8CH_ADR_FILTER_SEL5			(11)
#define LTDVE8CH_ADR_FILTER_SEL6			(12)
#define LTDVE8CH_ADR_FILTER_SEL7			(13)
#define LTDVE8CH_ADR_INPUT_SEL0				(14)
#define LTDVE8CH_ADR_INPUT_SEL1				(15)
#define LTDVE8CH_ADR_INPUT_SEL2				(16)
#define LTDVE8CH_ADR_INPUT_SEL3				(17)
#define LTDVE8CH_ADR_INPUT_SEL4				(18)
#define LTDVE8CH_ADR_INPUT_SEL5				(19)
#define LTDVE8CH_ADR_INPUT_SEL6				(20)
#define LTDVE8CH_ADR_INPUT_SEL7				(21)
#define LTDVE8CH_ADR_INPUT_SEL8				(22)
#define LTDVE8CH_ADR_INPUT_SEL9				(23)
#define LTDVE8CH_ADR_INPUT_SEL10			(24)
#define LTDVE8CH_ADR_INPUT_SEL11			(25)
#define LTDVE8CH_ADR_INPUT_SEL12			(26)
#define LTDVE8CH_ADR_INPUT_SEL13			(27)
#define LTDVE8CH_ADR_INPUT_SEL14			(28)
#define LTDVE8CH_ADR_INPUT_SEL15			(29)
#define LTDVE8CH_ADR_GEN_DLY_BASE0			(30)
#define LTDVE8CH_ADR_GEN_DLY_CNT0			(31)
#define LTDVE8CH_ADR_GEN_WDT_BASE0			(32)
#define LTDVE8CH_ADR_GEN_WDT_CNT0			(33)
#define LTDVE8CH_ADR_GEN_DLY_BASE1			(34)
#define LTDVE8CH_ADR_GEN_DLY_CNT1			(35)
#define LTDVE8CH_ADR_GEN_WDT_BASE1			(36)
#define LTDVE8CH_ADR_GEN_WDT_CNT1			(37)
#define LTDVE8CH_ADR_GEN_DLY_BASE2			(38)
#define LTDVE8CH_ADR_GEN_DLY_CNT2			(39)
#define LTDVE8CH_ADR_GEN_WDT_BASE2			(40)
#define LTDVE8CH_ADR_GEN_WDT_CNT2			(41)
#define LTDVE8CH_ADR_GEN_DLY_BASE3			(42)
#define LTDVE8CH_ADR_GEN_DLY_CNT3			(43)
#define LTDVE8CH_ADR_GEN_WDT_BASE3			(44)
#define LTDVE8CH_ADR_GEN_WDT_CNT3			(45)
#define LTDVE8CH_ADR_GEN_DLY_BASE4			(46)
#define LTDVE8CH_ADR_GEN_DLY_CNT4			(47)
#define LTDVE8CH_ADR_GEN_WDT_BASE4			(48)
#define LTDVE8CH_ADR_GEN_WDT_CNT4			(49)
#define LTDVE8CH_ADR_GEN_DLY_BASE5			(50)
#define LTDVE8CH_ADR_GEN_DLY_CNT5			(51)
#define LTDVE8CH_ADR_GEN_WDT_BASE5			(52)
#define LTDVE8CH_ADR_GEN_WDT_CNT5			(53)
#define LTDVE8CH_ADR_GEN_DLY_BASE6			(54)
#define LTDVE8CH_ADR_GEN_DLY_CNT6			(55)
#define LTDVE8CH_ADR_GEN_WDT_BASE6			(56)
#define LTDVE8CH_ADR_GEN_WDT_CNT6			(57)
#define LTDVE8CH_ADR_GEN_DLY_BASE7			(58)
#define LTDVE8CH_ADR_GEN_DLY_CNT7			(59)
#define LTDVE8CH_ADR_GEN_WDT_BASE7			(60)
#define LTDVE8CH_ADR_GEN_WDT_CNT7			(61)
#define LTDVE8CH_ADR_GEN_DLY_BASE8			(62)
#define LTDVE8CH_ADR_GEN_DLY_CNT8			(63)
#define LTDVE8CH_ADR_GEN_WDT_BASE8			(64)
#define LTDVE8CH_ADR_GEN_WDT_CNT8			(65)
#define LTDVE8CH_ADR_GEN_DLY_BASE9			(66)
#define LTDVE8CH_ADR_GEN_DLY_CNT9			(67)
#define LTDVE8CH_ADR_GEN_WDT_BASE9			(68)
#define LTDVE8CH_ADR_GEN_WDT_CNT9			(69)
#define LTDVE8CH_ADR_GEN_DLY_BASE10			(70)
#define LTDVE8CH_ADR_GEN_DLY_CNT10			(71)
#define LTDVE8CH_ADR_GEN_WDT_BASE10			(72)
#define LTDVE8CH_ADR_GEN_WDT_CNT10			(73)
#define LTDVE8CH_ADR_GEN_DLY_BASE11			(74)
#define LTDVE8CH_ADR_GEN_DLY_CNT11			(75)
#define LTDVE8CH_ADR_GEN_WDT_BASE11			(76)
#define LTDVE8CH_ADR_GEN_WDT_CNT11			(77)
#define LTDVE8CH_ADR_GEN_DLY_BASE12			(78)
#define LTDVE8CH_ADR_GEN_DLY_CNT12			(79)
#define LTDVE8CH_ADR_GEN_WDT_BASE12			(80)
#define LTDVE8CH_ADR_GEN_WDT_CNT12			(81)
#define LTDVE8CH_ADR_GEN_DLY_BASE13			(82)
#define LTDVE8CH_ADR_GEN_DLY_CNT13			(83)
#define LTDVE8CH_ADR_GEN_WDT_BASE13			(84)
#define LTDVE8CH_ADR_GEN_WDT_CNT13			(85)
#define LTDVE8CH_ADR_GEN_DLY_BASE14			(86)
#define LTDVE8CH_ADR_GEN_DLY_CNT14			(87)
#define LTDVE8CH_ADR_GEN_WDT_BASE14			(88)
#define LTDVE8CH_ADR_GEN_WDT_CNT14			(89)
#define LTDVE8CH_ADR_GEN_DLY_BASE15			(90)
#define LTDVE8CH_ADR_GEN_DLY_CNT15			(91)
#define LTDVE8CH_ADR_GEN_WDT_BASE15			(92)
#define LTDVE8CH_ADR_GEN_WDT_CNT15			(93)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI0			(94)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO0			(95)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI1			(96)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO1			(97)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI2			(98)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO2			(99)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI3			(100)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO3			(101)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI4			(102)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO4			(103)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI5			(104)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO5			(105)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI6			(106)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO6			(107)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI7			(108)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO7			(109)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI8			(110)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO8			(111)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI9			(112)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO9			(113)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI10		(114)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO10		(115)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI11		(116)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO11		(117)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI12		(118)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO12		(119)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI13		(120)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO13		(121)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI14		(122)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO14		(123)
#define LTDVE8CH_ADR_OUTPUT_SEL_HI15		(124)
#define LTDVE8CH_ADR_OUTPUT_SEL_LO15		(125)
#define LTDVE8CH_ADR_PRT_CNT_ON0			(126)
#define LTDVE8CH_ADR_PRT_ENA_ON0			(127)
#define LTDVE8CH_ADR_PRT_CNT_OFF0			(128)
#define LTDVE8CH_ADR_PRT_ENA_OFF0			(129)
#define LTDVE8CH_ADR_PRT_CNT_ON1			(130)
#define LTDVE8CH_ADR_PRT_ENA_ON1			(131)
#define LTDVE8CH_ADR_PRT_CNT_OFF1			(132)
#define LTDVE8CH_ADR_PRT_ENA_OFF1			(133)
#define LTDVE8CH_ADR_PRT_CNT_ON2			(134)
#define LTDVE8CH_ADR_PRT_ENA_ON2			(135)
#define LTDVE8CH_ADR_PRT_CNT_OFF2			(136)
#define LTDVE8CH_ADR_PRT_ENA_OFF2			(137)
#define LTDVE8CH_ADR_PRT_CNT_ON3			(138)
#define LTDVE8CH_ADR_PRT_ENA_ON3			(139)
#define LTDVE8CH_ADR_PRT_CNT_OFF3			(140)
#define LTDVE8CH_ADR_PRT_ENA_OFF3			(141)
#define LTDVE8CH_ADR_PRT_CNT_ON4			(142)
#define LTDVE8CH_ADR_PRT_ENA_ON4			(143)
#define LTDVE8CH_ADR_PRT_CNT_OFF4			(144)
#define LTDVE8CH_ADR_PRT_ENA_OFF4			(145)
#define LTDVE8CH_ADR_PRT_CNT_ON5			(146)
#define LTDVE8CH_ADR_PRT_ENA_ON5			(147)
#define LTDVE8CH_ADR_PRT_CNT_OFF5			(148)
#define LTDVE8CH_ADR_PRT_ENA_OFF5			(149)
#define LTDVE8CH_ADR_PRT_CNT_ON6			(150)
#define LTDVE8CH_ADR_PRT_ENA_ON6			(151)
#define LTDVE8CH_ADR_PRT_CNT_OFF6			(152)
#define LTDVE8CH_ADR_PRT_ENA_OFF6			(153)
#define LTDVE8CH_ADR_PRT_CNT_ON7			(154)
#define LTDVE8CH_ADR_PRT_ENA_ON7			(155)
#define LTDVE8CH_ADR_PRT_CNT_OFF7			(156)
#define LTDVE8CH_ADR_PRT_ENA_OFF7			(157)
#define LTDVE8CH_ADR_CUR_RANGE0				(158)
#define LTDVE8CH_ADR_CUR_VALUE0				(159)
#define LTDVE8CH_ADR_CUR_RANGE1				(160)
#define LTDVE8CH_ADR_CUR_VALUE1				(161)
#define LTDVE8CH_ADR_CUR_RANGE2				(162)
#define LTDVE8CH_ADR_CUR_VALUE2				(163)
#define LTDVE8CH_ADR_CUR_RANGE3				(164)
#define LTDVE8CH_ADR_CUR_VALUE3				(165)
#define LTDVE8CH_ADR_CUR_RANGE4				(166)
#define LTDVE8CH_ADR_CUR_VALUE4				(167)
#define LTDVE8CH_ADR_CUR_RANGE5				(168)
#define LTDVE8CH_ADR_CUR_VALUE5				(169)
#define LTDVE8CH_ADR_CUR_RANGE6				(170)
#define LTDVE8CH_ADR_CUR_VALUE6				(171)
#define LTDVE8CH_ADR_CUR_RANGE7				(172)
#define LTDVE8CH_ADR_CUR_VALUE7				(173)
#define LTDVE8CH_ADR_RS485_MODBUS_ADDR		(174)
#define LTDVE8CH_ADR_RS485_LINE_SPEED		(175)
#define LTDVE8CH_ADR_RS485_LINE_PARITY		(176)
#define LTDVE8CH_ADR_ETH_MAC_ADDR0			(177)
#define LTDVE8CH_ADR_ETH_MAC_ADDR1			(178)
#define LTDVE8CH_ADR_ETH_MAC_ADDR2			(179)
#define LTDVE8CH_ADR_ETH_HOSTNAME0			(180)
#define LTDVE8CH_ADR_ETH_HOSTNAME1			(181)
#define LTDVE8CH_ADR_ETH_HOSTNAME2			(182)
#define LTDVE8CH_ADR_ETH_HOSTNAME3			(183)
#define LTDVE8CH_ADR_ETH_HOSTNAME4			(184)
#define LTDVE8CH_ADR_ETH_HOSTNAME5			(185)
#define LTDVE8CH_ADR_ETH_HOSTNAME6			(186)
#define LTDVE8CH_ADR_ETH_HOSTNAME7			(187)
#define LTDVE8CH_ADR_ETH_DHCP_ENABLE		(188)
#define LTDVE8CH_ADR_ETH_IP_ADDR_HI			(189)
#define LTDVE8CH_ADR_ETH_IP_ADDR_LO			(190)
#define LTDVE8CH_ADR_ETH_SUBNET_MASK_HI		(191)
#define LTDVE8CH_ADR_ETH_SUBNET_MASK_LO		(192)
#define LTDVE8CH_ADR_ETH_DEF_GATEWAY_HI		(193)
#define LTDVE8CH_ADR_ETH_DEF_GATEWAY_LO		(194)
#define LTDVE8CH_ADR_ETH_PRI_DNS_HI			(195)
#define LTDVE8CH_ADR_ETH_PRI_DNS_LO			(196)
#define LTDVE8CH_ADR_ETH_SEC_DNS_HI			(197)
#define LTDVE8CH_ADR_ETH_SEC_DNS_LO			(198)
#define LTDVE8CH_ADR_ETH_MODBUS_ADDR		(199)
#define LTDVE8CH_ADR_ETH_MODBUS_TCP_PORT	(200)
#define LTDVE8CH_ADR_ETH_MODBUS_UDP_PORT	(201)
#define LTDVE8CH_ADR_WEB_PASSWORD0			(202)
#define LTDVE8CH_ADR_WEB_PASSWORD1			(203)
#define LTDVE8CH_ADR_WEB_PASSWORD2			(204)
#define LTDVE8CH_ADR_WEB_PASSWORD3			(205)
#define LTDVE8CH_ADR_BOARD_TEMPERATURE0		(206)
#define LTDVE8CH_ADR_BOARD_TEMPERATURE1		(207)
#define LTDVE8CH_ADR_BOARD_TEMPERATURE2		(208)
#define LTDVE8CH_ADR_BOARD_TEMPERATURE3		(209)
#define LTDVE8CH_ADR_REMOTE_TEMPERATURE		(210)
#define LTDVE8CH_ADR_SUPPLY_VOLTAGE			(211)
#define LTDVE8CH_ADR_MEASURED_CURRENT0		(212)
#define LTDVE8CH_ADR_MEASURED_CURRENT1		(213)
#define LTDVE8CH_ADR_MEASURED_CURRENT2		(214)
#define LTDVE8CH_ADR_MEASURED_CURRENT3		(215)
#define LTDVE8CH_ADR_MEASURED_CURRENT4		(216)
#define LTDVE8CH_ADR_MEASURED_CURRENT5		(217)
#define LTDVE8CH_ADR_MEASURED_CURRENT6		(218)
#define LTDVE8CH_ADR_MEASURED_CURRENT7		(219)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE0		(220)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE1		(221)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE2		(222)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE3		(223)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE4		(224)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE5		(225)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE6		(226)
#define LTDVE8CH_ADR_MEASURED_VOLTAGE7		(227)
#define LTDVE8CH_ADR_ERROR_WORD				(228)
#define LTDVE8CH_ADR_GEN_HLD_BASE0			(229)
#define LTDVE8CH_ADR_GEN_HLD_CNT0			(230)
#define LTDVE8CH_ADR_GEN_HLD_BASE1			(231)
#define LTDVE8CH_ADR_GEN_HLD_CNT1			(232)
#define LTDVE8CH_ADR_GEN_HLD_BASE2			(233)
#define LTDVE8CH_ADR_GEN_HLD_CNT2			(234)
#define LTDVE8CH_ADR_GEN_HLD_BASE3			(235)
#define LTDVE8CH_ADR_GEN_HLD_CNT3			(236)
#define LTDVE8CH_ADR_GEN_HLD_BASE4			(237)
#define LTDVE8CH_ADR_GEN_HLD_CNT4			(238)
#define LTDVE8CH_ADR_GEN_HLD_BASE5			(239)
#define LTDVE8CH_ADR_GEN_HLD_CNT5			(240)
#define LTDVE8CH_ADR_GEN_HLD_BASE6			(241)
#define LTDVE8CH_ADR_GEN_HLD_CNT6			(242)
#define LTDVE8CH_ADR_GEN_HLD_BASE7			(243)
#define LTDVE8CH_ADR_GEN_HLD_CNT7			(244)
#define LTDVE8CH_ADR_GEN_HLD_BASE8			(245)
#define LTDVE8CH_ADR_GEN_HLD_CNT8			(246)
#define LTDVE8CH_ADR_GEN_HLD_BASE9			(247)
#define LTDVE8CH_ADR_GEN_HLD_CNT9			(248)
#define LTDVE8CH_ADR_GEN_HLD_BASE10			(249)
#define LTDVE8CH_ADR_GEN_HLD_CNT10			(250)
#define LTDVE8CH_ADR_GEN_HLD_BASE11			(251)
#define LTDVE8CH_ADR_GEN_HLD_CNT11			(252)
#define LTDVE8CH_ADR_GEN_HLD_BASE12			(253)
#define LTDVE8CH_ADR_GEN_HLD_CNT12			(254)
#define LTDVE8CH_ADR_GEN_HLD_BASE13			(255)
#define LTDVE8CH_ADR_GEN_HLD_CNT13			(256)
#define LTDVE8CH_ADR_GEN_HLD_BASE14			(257)
#define LTDVE8CH_ADR_GEN_HLD_CNT14			(258)
#define LTDVE8CH_ADR_GEN_HLD_BASE15			(259)
#define LTDVE8CH_ADR_GEN_HLD_CNT15			(260)
#define LTDVE8CH_ADR_GEN_EDGE_SEL0			(261)
#define LTDVE8CH_ADR_GEN_EDGE_SEL1			(262)
#define LTDVE8CH_ADR_GEN_EDGE_SEL2			(263)
#define LTDVE8CH_ADR_GEN_EDGE_SEL3			(264)
#define LTDVE8CH_ADR_GEN_EDGE_SEL4			(265)
#define LTDVE8CH_ADR_GEN_EDGE_SEL5			(266)
#define LTDVE8CH_ADR_GEN_EDGE_SEL6			(267)
#define LTDVE8CH_ADR_GEN_EDGE_SEL7			(268)
#define LTDVE8CH_ADR_GEN_EDGE_SEL8			(269)
#define LTDVE8CH_ADR_GEN_EDGE_SEL9			(270)
#define LTDVE8CH_ADR_GEN_EDGE_SEL10			(271)
#define LTDVE8CH_ADR_GEN_EDGE_SEL11			(272)
#define LTDVE8CH_ADR_GEN_EDGE_SEL12			(273)
#define LTDVE8CH_ADR_GEN_EDGE_SEL13			(274)
#define LTDVE8CH_ADR_GEN_EDGE_SEL14			(275)
#define LTDVE8CH_ADR_GEN_EDGE_SEL15			(276)
#define LTDVE8CH_ADR_RESERVED_277			(277)
#define LTDVE8CH_ADR_RESERVED_278			(278)
#define LTDVE8CH_ADR_RESERVED_279			(279)
#define LTDVE8CH_ADR_RESERVED_280			(280)
#define LTDVE8CH_ADR_RESERVED_281			(281)
#define LTDVE8CH_ADR_RESERVED_282			(282)
#define LTDVE8CH_ADR_RESERVED_283			(283)
#define LTDVE8CH_ADR_RESERVED_284			(284)
#define LTDVE8CH_ADR_DRIVE_TIME0			(285)
#define LTDVE8CH_ADR_DRIVE_TIME1			(286)
#define LTDVE8CH_ADR_DRIVE_TIME2			(287)
#define LTDVE8CH_ADR_DRIVE_TIME3			(288)
#define LTDVE8CH_ADR_DRIVE_TIME4			(289)
#define LTDVE8CH_ADR_DRIVE_TIME5			(290)
#define LTDVE8CH_ADR_DRIVE_TIME6			(291)
#define LTDVE8CH_ADR_DRIVE_TIME7			(292)
#define LTDVE8CH_ADR_CUR_RED_DLY0			(293)
#define LTDVE8CH_ADR_CUR_RED_VAL0			(294)
#define LTDVE8CH_ADR_CUR_RED_DLY1			(295)
#define LTDVE8CH_ADR_CUR_RED_VAL1			(296)
#define LTDVE8CH_ADR_CUR_RED_DLY2			(297)
#define LTDVE8CH_ADR_CUR_RED_VAL2			(298)
#define LTDVE8CH_ADR_CUR_RED_DLY3			(299)
#define LTDVE8CH_ADR_CUR_RED_VAL3			(300)
#define LTDVE8CH_ADR_CUR_RED_DLY4			(301)
#define LTDVE8CH_ADR_CUR_RED_VAL4			(302)
#define LTDVE8CH_ADR_CUR_RED_DLY5			(303)
#define LTDVE8CH_ADR_CUR_RED_VAL5			(304)
#define LTDVE8CH_ADR_CUR_RED_DLY6			(305)
#define LTDVE8CH_ADR_CUR_RED_VAL6			(306)
#define LTDVE8CH_ADR_CUR_RED_DLY7			(307)
#define LTDVE8CH_ADR_CUR_RED_VAL7			(308)
#define LTDVE8CH_ADR_SOFTWARE_TRIGGER		(309)
#define LTDVE8CH_ADR_UNUSED_310				(310)
#define LTDVE8CH_ADR_UNUSED_311				(311)
#define LTDVE8CH_ADR_UNUSED_312				(312)
#define LTDVE8CH_ADR_UNUSED_313				(313)
#define LTDVE8CH_ADR_UNUSED_314				(314)
#define LTDVE8CH_ADR_UNUSED_315				(315)
#define LTDVE8CH_ADR_UNUSED_316				(316)
#define LTDVE8CH_ADR_UNUSED_317				(317)
#define LTDVE8CH_ADR_UNUSED_318				(318)
#define LTDVE8CH_ADR_BOARD_COMMAND			(511)

/* general purpose read registers */
typedef struct {
	int device_type;
	int boot_version;
	int mcu_version;
	int fpga_version;
	int board_version;
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int filter_sel2;
	int filter_sel3;
	int filter_sel4;
	int filter_sel5;
	int filter_sel6;
	int filter_sel7;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int input_sel4;
	int input_sel5;
	int input_sel6;
	int input_sel7;
	int input_sel8;
	int input_sel9;
	int input_sel10;
	int input_sel11;
	int input_sel12;
	int input_sel13;
	int input_sel14;
	int input_sel15;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int gen_dly_base4;
	int gen_dly_cnt4;
	int gen_wdt_base4;
	int gen_wdt_cnt4;
	int gen_dly_base5;
	int gen_dly_cnt5;
	int gen_wdt_base5;
	int gen_wdt_cnt5;
	int gen_dly_base6;
	int gen_dly_cnt6;
	int gen_wdt_base6;
	int gen_wdt_cnt6;
	int gen_dly_base7;
	int gen_dly_cnt7;
	int gen_wdt_base7;
	int gen_wdt_cnt7;
	int gen_dly_base8;
	int gen_dly_cnt8;
	int gen_wdt_base8;
	int gen_wdt_cnt8;
	int gen_dly_base9;
	int gen_dly_cnt9;
	int gen_wdt_base9;
	int gen_wdt_cnt9;
	int gen_dly_base10;
	int gen_dly_cnt10;
	int gen_wdt_base10;
	int gen_wdt_cnt10;
	int gen_dly_base11;
	int gen_dly_cnt11;
	int gen_wdt_base11;
	int gen_wdt_cnt11;
	int gen_dly_base12;
	int gen_dly_cnt12;
	int gen_wdt_base12;
	int gen_wdt_cnt12;
	int gen_dly_base13;
	int gen_dly_cnt13;
	int gen_wdt_base13;
	int gen_wdt_cnt13;
	int gen_dly_base14;
	int gen_dly_cnt14;
	int gen_wdt_base14;
	int gen_wdt_cnt14;
	int gen_dly_base15;
	int gen_dly_cnt15;
	int gen_wdt_base15;
	int gen_wdt_cnt15;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi2;
	int output_sel_lo2;
	int output_sel_hi3;
	int output_sel_lo3;
	int output_sel_hi4;
	int output_sel_lo4;
	int output_sel_hi5;
	int output_sel_lo5;
	int output_sel_hi6;
	int output_sel_lo6;
	int output_sel_hi7;
	int output_sel_lo7;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int output_sel_hi10;
	int output_sel_lo10;
	int output_sel_hi11;
	int output_sel_lo11;
	int output_sel_hi12;
	int output_sel_lo12;
	int output_sel_hi13;
	int output_sel_lo13;
	int output_sel_hi14;
	int output_sel_lo14;
	int output_sel_hi15;
	int output_sel_lo15;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int prt_cnt_on2;
	int prt_ena_on2;
	int prt_cnt_off2;
	int prt_ena_off2;
	int prt_cnt_on3;
	int prt_ena_on3;
	int prt_cnt_off3;
	int prt_ena_off3;
	int prt_cnt_on4;
	int prt_ena_on4;
	int prt_cnt_off4;
	int prt_ena_off4;
	int prt_cnt_on5;
	int prt_ena_on5;
	int prt_cnt_off5;
	int prt_ena_off5;
	int prt_cnt_on6;
	int prt_ena_on6;
	int prt_cnt_off6;
	int prt_ena_off6;
	int prt_cnt_on7;
	int prt_ena_on7;
	int prt_cnt_off7;
	int prt_ena_off7;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int cur_range2;
	int cur_value2;
	int cur_range3;
	int cur_value3;
	int cur_range4;
	int cur_value4;
	int cur_range5;
	int cur_value5;
	int cur_range6;
	int cur_value6;
	int cur_range7;
	int cur_value7;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
	int board_temperature0;
	int board_temperature1;
	int board_temperature2;
	int board_temperature3;
	int remote_temperature;
	int supply_voltage;
	int measured_current0;
	int measured_current1;
	int measured_current2;
	int measured_current3;
	int measured_current4;
	int measured_current5;
	int measured_current6;
	int measured_current7;
	int measured_voltage0;
	int measured_voltage1;
	int measured_voltage2;
	int measured_voltage3;
	int measured_voltage4;
	int measured_voltage5;
	int measured_voltage6;
	int measured_voltage7;
	int error_word;
	int board_command;
}
ltdve8ch_reg_rd_t;

/* general purpose write registers */
typedef struct {
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int filter_sel2;
	int filter_sel3;
	int filter_sel4;
	int filter_sel5;
	int filter_sel6;
	int filter_sel7;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int input_sel4;
	int input_sel5;
	int input_sel6;
	int input_sel7;
	int input_sel8;
	int input_sel9;
	int input_sel10;
	int input_sel11;
	int input_sel12;
	int input_sel13;
	int input_sel14;
	int input_sel15;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int gen_dly_base4;
	int gen_dly_cnt4;
	int gen_wdt_base4;
	int gen_wdt_cnt4;
	int gen_dly_base5;
	int gen_dly_cnt5;
	int gen_wdt_base5;
	int gen_wdt_cnt5;
	int gen_dly_base6;
	int gen_dly_cnt6;
	int gen_wdt_base6;
	int gen_wdt_cnt6;
	int gen_dly_base7;
	int gen_dly_cnt7;
	int gen_wdt_base7;
	int gen_wdt_cnt7;
	int gen_dly_base8;
	int gen_dly_cnt8;
	int gen_wdt_base8;
	int gen_wdt_cnt8;
	int gen_dly_base9;
	int gen_dly_cnt9;
	int gen_wdt_base9;
	int gen_wdt_cnt9;
	int gen_dly_base10;
	int gen_dly_cnt10;
	int gen_wdt_base10;
	int gen_wdt_cnt10;
	int gen_dly_base11;
	int gen_dly_cnt11;
	int gen_wdt_base11;
	int gen_wdt_cnt11;
	int gen_dly_base12;
	int gen_dly_cnt12;
	int gen_wdt_base12;
	int gen_wdt_cnt12;
	int gen_dly_base13;
	int gen_dly_cnt13;
	int gen_wdt_base13;
	int gen_wdt_cnt13;
	int gen_dly_base14;
	int gen_dly_cnt14;
	int gen_wdt_base14;
	int gen_wdt_cnt14;
	int gen_dly_base15;
	int gen_dly_cnt15;
	int gen_wdt_base15;
	int gen_wdt_cnt15;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi2;
	int output_sel_lo2;
	int output_sel_hi3;
	int output_sel_lo3;
	int output_sel_hi4;
	int output_sel_lo4;
	int output_sel_hi5;
	int output_sel_lo5;
	int output_sel_hi6;
	int output_sel_lo6;
	int output_sel_hi7;
	int output_sel_lo7;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int output_sel_hi10;
	int output_sel_lo10;
	int output_sel_hi11;
	int output_sel_lo11;
	int output_sel_hi12;
	int output_sel_lo12;
	int output_sel_hi13;
	int output_sel_lo13;
	int output_sel_hi14;
	int output_sel_lo14;
	int output_sel_hi15;
	int output_sel_lo15;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int prt_cnt_on2;
	int prt_ena_on2;
	int prt_cnt_off2;
	int prt_ena_off2;
	int prt_cnt_on3;
	int prt_ena_on3;
	int prt_cnt_off3;
	int prt_ena_off3;
	int prt_cnt_on4;
	int prt_ena_on4;
	int prt_cnt_off4;
	int prt_ena_off4;
	int prt_cnt_on5;
	int prt_ena_on5;
	int prt_cnt_off5;
	int prt_ena_off5;
	int prt_cnt_on6;
	int prt_ena_on6;
	int prt_cnt_off6;
	int prt_ena_off6;
	int prt_cnt_on7;
	int prt_ena_on7;
	int prt_cnt_off7;
	int prt_ena_off7;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int cur_range2;
	int cur_value2;
	int cur_range3;
	int cur_value3;
	int cur_range4;
	int cur_value4;
	int cur_range5;
	int cur_value5;
	int cur_range6;
	int cur_value6;
	int cur_range7;
	int cur_value7;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
}
ltdve8ch_reg_wr_t;

#define LTDVE8CH_FILE_MAGIC0 (0x76543210)
#define LTDVE8CH_FILE_MAGIC1 (0x00000008)

/* data stored in disk file */
typedef struct {
	int magic0;
	int magic1;
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int filter_sel2;
	int filter_sel3;
	int filter_sel4;
	int filter_sel5;
	int filter_sel6;
	int filter_sel7;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int input_sel4;
	int input_sel5;
	int input_sel6;
	int input_sel7;
	int input_sel8;
	int input_sel9;
	int input_sel10;
	int input_sel11;
	int input_sel12;
	int input_sel13;
	int input_sel14;
	int input_sel15;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int gen_dly_base4;
	int gen_dly_cnt4;
	int gen_wdt_base4;
	int gen_wdt_cnt4;
	int gen_dly_base5;
	int gen_dly_cnt5;
	int gen_wdt_base5;
	int gen_wdt_cnt5;
	int gen_dly_base6;
	int gen_dly_cnt6;
	int gen_wdt_base6;
	int gen_wdt_cnt6;
	int gen_dly_base7;
	int gen_dly_cnt7;
	int gen_wdt_base7;
	int gen_wdt_cnt7;
	int gen_dly_base8;
	int gen_dly_cnt8;
	int gen_wdt_base8;
	int gen_wdt_cnt8;
	int gen_dly_base9;
	int gen_dly_cnt9;
	int gen_wdt_base9;
	int gen_wdt_cnt9;
	int gen_dly_base10;
	int gen_dly_cnt10;
	int gen_wdt_base10;
	int gen_wdt_cnt10;
	int gen_dly_base11;
	int gen_dly_cnt11;
	int gen_wdt_base11;
	int gen_wdt_cnt11;
	int gen_dly_base12;
	int gen_dly_cnt12;
	int gen_wdt_base12;
	int gen_wdt_cnt12;
	int gen_dly_base13;
	int gen_dly_cnt13;
	int gen_wdt_base13;
	int gen_wdt_cnt13;
	int gen_dly_base14;
	int gen_dly_cnt14;
	int gen_wdt_base14;
	int gen_wdt_cnt14;
	int gen_dly_base15;
	int gen_dly_cnt15;
	int gen_wdt_base15;
	int gen_wdt_cnt15;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi2;
	int output_sel_lo2;
	int output_sel_hi3;
	int output_sel_lo3;
	int output_sel_hi4;
	int output_sel_lo4;
	int output_sel_hi5;
	int output_sel_lo5;
	int output_sel_hi6;
	int output_sel_lo6;
	int output_sel_hi7;
	int output_sel_lo7;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int output_sel_hi10;
	int output_sel_lo10;
	int output_sel_hi11;
	int output_sel_lo11;
	int output_sel_hi12;
	int output_sel_lo12;
	int output_sel_hi13;
	int output_sel_lo13;
	int output_sel_hi14;
	int output_sel_lo14;
	int output_sel_hi15;
	int output_sel_lo15;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int prt_cnt_on2;
	int prt_ena_on2;
	int prt_cnt_off2;
	int prt_ena_off2;
	int prt_cnt_on3;
	int prt_ena_on3;
	int prt_cnt_off3;
	int prt_ena_off3;
	int prt_cnt_on4;
	int prt_ena_on4;
	int prt_cnt_off4;
	int prt_ena_off4;
	int prt_cnt_on5;
	int prt_ena_on5;
	int prt_cnt_off5;
	int prt_ena_off5;
	int prt_cnt_on6;
	int prt_ena_on6;
	int prt_cnt_off6;
	int prt_ena_off6;
	int prt_cnt_on7;
	int prt_ena_on7;
	int prt_cnt_off7;
	int prt_ena_off7;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int cur_range2;
	int cur_value2;
	int cur_range3;
	int cur_value3;
	int cur_range4;
	int cur_value4;
	int cur_range5;
	int cur_value5;
	int cur_range6;
	int cur_value6;
	int cur_range7;
	int cur_value7;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
}
ltdve8ch_reg_file_t;

/* read all the general purpose registers */
int ltdve8ch_gen_reg_rd(modbus_t *p_modbus, ltdve8ch_reg_rd_t *p_reg, int print, int read_all_regs);

/* write all the general purpose registers */
int ltdve8ch_gen_reg_wr(modbus_t *p_modbus, ltdve8ch_reg_wr_t *p_reg, int print, int write_cal_regs);

/* write the board command register */
int ltdve8ch_brd_cmd_wr(modbus_t *p_modbus, int reg_val);

/* file ends here */
