/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "modbus.h"
#include "dev_ltdve4ch.h"

/* read all the general purpose registers */
int ltdve4ch_gen_reg_rd(modbus_t *p_modbus, ltdve4ch_reg_rd_t *p_reg, int print, int read_all_regs)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	if ((err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_DEVICE_TYPE, 1, &p_reg->device_type, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DEVICE_TYPE\t\t = %d\n", p_reg->device_type);

	if ((err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_BOOT_VERSION, 1, &p_reg->boot_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("BOOT_VERSION\t\t = %d\n", p_reg->boot_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MCU_VERSION, 1, &p_reg->mcu_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("MCU_VERSION\t\t = %d\n", p_reg->mcu_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_FPGA_VERSION, 1, &p_reg->fpga_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("FPGA_VERSION\t\t = %d\n", p_reg->fpga_version);

	if ((err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_BOARD_VERSION, 1, &p_reg->board_version, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("BOARD_VERSION\t\t = %d\n", p_reg->board_version);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OSC_PERIOD, 1, &p_reg->osc_period, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OSC_PERIOD\t\t = %d\n", p_reg->osc_period);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL0, 1, &p_reg->filter_sel0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FILTER_SEL0\t\t = %d\n", p_reg->filter_sel0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL1, 1, &p_reg->filter_sel1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FILTER_SEL1\t\t = %d\n", p_reg->filter_sel1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL2, 1, &p_reg->filter_sel2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FILTER_SEL2\t\t = %d\n", p_reg->filter_sel2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL3, 1, &p_reg->filter_sel3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("FILTER_SEL3\t\t = %d\n", p_reg->filter_sel3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL0, 1, &p_reg->input_sel0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL0\t\t = 0x%04X\n", p_reg->input_sel0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL1, 1, &p_reg->input_sel1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL1\t\t = 0x%04X\n", p_reg->input_sel1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL2, 1, &p_reg->input_sel2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL2\t\t = 0x%04X\n", p_reg->input_sel2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL3, 1, &p_reg->input_sel3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL3\t\t = 0x%04X\n", p_reg->input_sel3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL4, 1, &p_reg->input_sel4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL4\t\t = 0x%04X\n", p_reg->input_sel4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL5, 1, &p_reg->input_sel5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL5\t\t = 0x%04X\n", p_reg->input_sel5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL6, 1, &p_reg->input_sel6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL6\t\t = 0x%04X\n", p_reg->input_sel6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL7, 1, &p_reg->input_sel7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("INPUT_SEL7\t\t = 0x%04X\n", p_reg->input_sel7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE0, 1, &p_reg->gen_dly_base0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE0\t\t = %d\n", p_reg->gen_dly_base0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT0, 1, &p_reg->gen_dly_cnt0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT0\t\t = %d\n", p_reg->gen_dly_cnt0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE0, 1, &p_reg->gen_wdt_base0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE0\t\t = %d\n", p_reg->gen_wdt_base0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT0, 1, &p_reg->gen_wdt_cnt0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT0\t\t = %d\n", p_reg->gen_wdt_cnt0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE1, 1, &p_reg->gen_dly_base1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE1\t\t = %d\n", p_reg->gen_dly_base1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT1, 1, &p_reg->gen_dly_cnt1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT1\t\t = %d\n", p_reg->gen_dly_cnt1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE1, 1, &p_reg->gen_wdt_base1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE1\t\t = %d\n", p_reg->gen_wdt_base1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT1, 1, &p_reg->gen_wdt_cnt1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT1\t\t = %d\n", p_reg->gen_wdt_cnt1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE2, 1, &p_reg->gen_dly_base2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE2\t\t = %d\n", p_reg->gen_dly_base2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT2, 1, &p_reg->gen_dly_cnt2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT2\t\t = %d\n", p_reg->gen_dly_cnt2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE2, 1, &p_reg->gen_wdt_base2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE2\t\t = %d\n", p_reg->gen_wdt_base2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT2, 1, &p_reg->gen_wdt_cnt2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT2\t\t = %d\n", p_reg->gen_wdt_cnt2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE3, 1, &p_reg->gen_dly_base3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE3\t\t = %d\n", p_reg->gen_dly_base3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT3, 1, &p_reg->gen_dly_cnt3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT3\t\t = %d\n", p_reg->gen_dly_cnt3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE3, 1, &p_reg->gen_wdt_base3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE3\t\t = %d\n", p_reg->gen_wdt_base3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT3, 1, &p_reg->gen_wdt_cnt3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT3\t\t = %d\n", p_reg->gen_wdt_cnt3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE4, 1, &p_reg->gen_dly_base4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE4\t\t = %d\n", p_reg->gen_dly_base4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT4, 1, &p_reg->gen_dly_cnt4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT4\t\t = %d\n", p_reg->gen_dly_cnt4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE4, 1, &p_reg->gen_wdt_base4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE4\t\t = %d\n", p_reg->gen_wdt_base4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT4, 1, &p_reg->gen_wdt_cnt4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT4\t\t = %d\n", p_reg->gen_wdt_cnt4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE5, 1, &p_reg->gen_dly_base5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE5\t\t = %d\n", p_reg->gen_dly_base5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT5, 1, &p_reg->gen_dly_cnt5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT5\t\t = %d\n", p_reg->gen_dly_cnt5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE5, 1, &p_reg->gen_wdt_base5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE5\t\t = %d\n", p_reg->gen_wdt_base5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT5, 1, &p_reg->gen_wdt_cnt5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT5\t\t = %d\n", p_reg->gen_wdt_cnt5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE6, 1, &p_reg->gen_dly_base6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE6\t\t = %d\n", p_reg->gen_dly_base6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT6, 1, &p_reg->gen_dly_cnt6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT6\t\t = %d\n", p_reg->gen_dly_cnt6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE6, 1, &p_reg->gen_wdt_base6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE6\t\t = %d\n", p_reg->gen_wdt_base6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT6, 1, &p_reg->gen_wdt_cnt6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT6\t\t = %d\n", p_reg->gen_wdt_cnt6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE7, 1, &p_reg->gen_dly_base7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_BASE7\t\t = %d\n", p_reg->gen_dly_base7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT7, 1, &p_reg->gen_dly_cnt7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_DLY_CNT7\t\t = %d\n", p_reg->gen_dly_cnt7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE7, 1, &p_reg->gen_wdt_base7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_BASE7\t\t = %d\n", p_reg->gen_wdt_base7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT7, 1, &p_reg->gen_wdt_cnt7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("GEN_WDT_CNT7\t\t = %d\n", p_reg->gen_wdt_cnt7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI0, 1, &p_reg->output_sel_hi0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI0\t\t = 0x%04X\n", p_reg->output_sel_hi0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO0, 1, &p_reg->output_sel_lo0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO0\t\t = 0x%04X\n", p_reg->output_sel_lo0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI1, 1, &p_reg->output_sel_hi1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI1\t\t = 0x%04X\n", p_reg->output_sel_hi1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO1, 1, &p_reg->output_sel_lo1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO1\t\t = 0x%04X\n", p_reg->output_sel_lo1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI2, 1, &p_reg->output_sel_hi2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI2\t\t = 0x%04X\n", p_reg->output_sel_hi2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO2, 1, &p_reg->output_sel_lo2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO2\t\t = 0x%04X\n", p_reg->output_sel_lo2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI3, 1, &p_reg->output_sel_hi3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI3\t\t = 0x%04X\n", p_reg->output_sel_hi3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO3, 1, &p_reg->output_sel_lo3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO3\t\t = 0x%04X\n", p_reg->output_sel_lo3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI8, 1, &p_reg->output_sel_hi8, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI8\t\t = 0x%04X\n", p_reg->output_sel_hi8);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO8, 1, &p_reg->output_sel_lo8, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO8\t\t = 0x%04X\n", p_reg->output_sel_lo8);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI9, 1, &p_reg->output_sel_hi9, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI9\t\t = 0x%04X\n", p_reg->output_sel_hi9);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO9, 1, &p_reg->output_sel_lo9, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO9\t\t = 0x%04X\n", p_reg->output_sel_lo9);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI10, 1, &p_reg->output_sel_hi10, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI10\t\t = 0x%04X\n", p_reg->output_sel_hi10);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO10, 1, &p_reg->output_sel_lo10, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO10\t\t = 0x%04X\n", p_reg->output_sel_lo10);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI11, 1, &p_reg->output_sel_hi11, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_HI11\t\t = 0x%04X\n", p_reg->output_sel_hi11);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO11, 1, &p_reg->output_sel_lo11, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("OUTPUT_SEL_LO11\t\t = 0x%04X\n", p_reg->output_sel_lo11);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON0, 1, &p_reg->prt_cnt_on0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_ON0\t\t = %d\n", p_reg->prt_cnt_on0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON0, 1, &p_reg->prt_ena_on0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit; 
	}
	if (read_all_regs && print) printf("PRT_ENA_ON0\t\t = %d\n", p_reg->prt_ena_on0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF0, 1, &p_reg->prt_cnt_off0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_OFF0\t\t = %d\n", p_reg->prt_cnt_off0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF0, 1, &p_reg->prt_ena_off0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_OFF0\t\t = %d\n", p_reg->prt_ena_off0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON1, 1, &p_reg->prt_cnt_on1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_ON1\t\t = %d\n", p_reg->prt_cnt_on1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON1, 1, &p_reg->prt_ena_on1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_ON1\t\t = %d\n", p_reg->prt_ena_on1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF1, 1, &p_reg->prt_cnt_off1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_OFF1\t\t = %d\n", p_reg->prt_cnt_off1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF1, 1, &p_reg->prt_ena_off1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_OFF1\t\t = %d\n", p_reg->prt_ena_off1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON2, 1, &p_reg->prt_cnt_on2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_ON2\t\t = %d\n", p_reg->prt_cnt_on2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON2, 1, &p_reg->prt_ena_on2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_ON2\t\t = %d\n", p_reg->prt_ena_on2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF2, 1, &p_reg->prt_cnt_off2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_OFF2\t\t = %d\n", p_reg->prt_cnt_off2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF2, 1, &p_reg->prt_ena_off2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_OFF2\t\t = %d\n", p_reg->prt_ena_off2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON3, 1, &p_reg->prt_cnt_on3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_ON3\t\t = %d\n", p_reg->prt_cnt_on3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON3, 1, &p_reg->prt_ena_on3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_ON3\t\t = %d\n", p_reg->prt_ena_on3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF3, 1, &p_reg->prt_cnt_off3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_CNT_OFF3\t\t = %d\n", p_reg->prt_cnt_off3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF3, 1, &p_reg->prt_ena_off3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("PRT_ENA_OFF3\t\t = %d\n", p_reg->prt_ena_off3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE0, 1, &p_reg->cur_range0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_RANGE0\t\t = %d\n", p_reg->cur_range0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE0, 1, &p_reg->cur_value0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_VALUE0\t\t = %d => %.3f A\n", p_reg->cur_value0, p_reg->cur_value0 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE1, 1, &p_reg->cur_range1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_RANGE1\t\t = %d\n", p_reg->cur_range1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE1, 1, &p_reg->cur_value1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_VALUE1\t\t = %d => %.3f A\n", p_reg->cur_value1, p_reg->cur_value1 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE2, 1, &p_reg->cur_range2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_RANGE2\t\t = %d\n", p_reg->cur_range2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE2, 1, &p_reg->cur_value2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_VALUE2\t\t = %d => %.3f A\n", p_reg->cur_value2, p_reg->cur_value2 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE3, 1, &p_reg->cur_range3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_RANGE3\t\t = %d\n", p_reg->cur_range3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE3, 1, &p_reg->cur_value3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("CUR_VALUE3\t\t = %d => %.3f A\n", p_reg->cur_value3, p_reg->cur_value3 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_RS485_MODBUS_ADDR, 1, &p_reg->rs485_modbus_addr, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_MODBUS_ADDR\t = %d\n", p_reg->rs485_modbus_addr);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_RS485_LINE_SPEED, 1, &p_reg->rs485_line_speed, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_LINE_SPEED\t = %d\n", p_reg->rs485_line_speed);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_RS485_LINE_PARITY, 1, &p_reg->rs485_line_parity, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("RS485_LINE_PARITY\t = %d\n", p_reg->rs485_line_parity);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR0, 1, &p_reg->eth_mac_addr0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR0\t\t = 0x%04X\n", p_reg->eth_mac_addr0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR1, 1, &p_reg->eth_mac_addr1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR1\t\t = 0x%04X\n", p_reg->eth_mac_addr1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR2, 1, &p_reg->eth_mac_addr2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MAC_ADDR2\t\t = 0x%04X\n", p_reg->eth_mac_addr2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME0, 1, &p_reg->eth_hostname0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME0\t\t = 0x%04X\n", p_reg->eth_hostname0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME1, 1, &p_reg->eth_hostname1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME1\t\t = 0x%04X\n", p_reg->eth_hostname1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME2, 1, &p_reg->eth_hostname2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME2\t\t = 0x%04X\n", p_reg->eth_hostname2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME3, 1, &p_reg->eth_hostname3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME3\t\t = 0x%04X\n", p_reg->eth_hostname3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME4, 1, &p_reg->eth_hostname4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME4\t\t = 0x%04X\n", p_reg->eth_hostname4);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME5, 1, &p_reg->eth_hostname5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME5\t\t = 0x%04X\n", p_reg->eth_hostname5);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME6, 1, &p_reg->eth_hostname6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME6\t\t = 0x%04X\n", p_reg->eth_hostname6);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME7, 1, &p_reg->eth_hostname7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_HOSTNAME7\t\t = 0x%04X\n", p_reg->eth_hostname7);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_DHCP_ENABLE, 1, &p_reg->eth_dhcp_enable, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DHCP_ENABLE\t\t = %d\n", p_reg->eth_dhcp_enable);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_IP_ADDR_HI, 1, &p_reg->eth_ip_addr_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_IP_ADDR_HI\t\t = 0x%04X\n", p_reg->eth_ip_addr_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_IP_ADDR_LO, 1, &p_reg->eth_ip_addr_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_IP_ADDR_LO\t\t = 0x%04X\n", p_reg->eth_ip_addr_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_SUBNET_MASK_HI, 1, &p_reg->eth_subnet_mask_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SUBNET_MASK_HI\t = 0x%04X\n", p_reg->eth_subnet_mask_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_SUBNET_MASK_LO, 1, &p_reg->eth_subnet_mask_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SUBNET_MASK_LO\t = 0x%04X\n", p_reg->eth_subnet_mask_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_DEF_GATEWAY_HI, 1, &p_reg->eth_def_gateway_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DEF_GATEWAY_HI\t = 0x%04X\n", p_reg->eth_def_gateway_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_DEF_GATEWAY_LO, 1, &p_reg->eth_def_gateway_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_DEF_GATEWAY_LO\t = 0x%04X\n", p_reg->eth_def_gateway_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_PRI_DNS_HI, 1, &p_reg->eth_pri_dns_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_PRI_DNS_HI\t\t = 0x%04X\n", p_reg->eth_pri_dns_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_PRI_DNS_LO, 1, &p_reg->eth_pri_dns_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_PRI_DNS_LO\t\t = 0x%04X\n", p_reg->eth_pri_dns_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_SEC_DNS_HI, 1, &p_reg->eth_sec_dns_hi, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SEC_DNS_HI\t\t = 0x%04X\n", p_reg->eth_sec_dns_hi);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_SEC_DNS_LO, 1, &p_reg->eth_sec_dns_lo, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_SEC_DNS_LO\t\t = 0x%04X\n", p_reg->eth_sec_dns_lo);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_ADDR, 1, &p_reg->eth_modbus_addr, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_ADDR\t\t = %d\n", p_reg->eth_modbus_addr);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_TCP_PORT, 1, &p_reg->eth_modbus_tcp_port, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_TCP_PORT\t = %d\n", p_reg->eth_modbus_tcp_port);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_UDP_PORT, 1, &p_reg->eth_modbus_udp_port, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ETH_MODBUS_UDP_PORT\t = %d\n", p_reg->eth_modbus_udp_port);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD0, 1, &p_reg->web_password0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD0\t\t = 0x%04X\n", p_reg->web_password0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD1, 1, &p_reg->web_password1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD1\t\t = 0x%04X\n", p_reg->web_password1);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD2, 1, &p_reg->web_password2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD2\t\t = 0x%04X\n", p_reg->web_password2);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD3, 1, &p_reg->web_password3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("WEB_PASSWORD3\t\t = 0x%04X\n", p_reg->web_password3);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_BOARD_TEMPERATURE0, 1, &p_reg->board_temperature0, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("BOARD_TEMPERATURE0\t = %d => %.1f C\n", p_reg->board_temperature0, p_reg->board_temperature0 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_BOARD_TEMPERATURE1, 1, &p_reg->board_temperature1, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("BOARD_TEMPERATURE1\t = %d => %.1f C\n", p_reg->board_temperature1, p_reg->board_temperature1 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_REMOTE_TEMPERATURE, 1, &p_reg->remote_temperature, 1)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("REMOTE_TEMPERATURE\t = %d => %.1f C\n", p_reg->remote_temperature, p_reg->remote_temperature / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_SUPPLY_VOLTAGE, 1, &p_reg->supply_voltage, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("SUPPLY_VOLTAGE\t\t = %d => %.1f V\n", p_reg->supply_voltage, p_reg->supply_voltage / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_CURRENT0, 1, &p_reg->measured_current0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_CURRENT0\t = %d => %.3f A\n", p_reg->measured_current0, p_reg->measured_current0 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_CURRENT1, 1, &p_reg->measured_current1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_CURRENT1\t = %d => %.3f A\n", p_reg->measured_current1, p_reg->measured_current1 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_CURRENT2, 1, &p_reg->measured_current2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_CURRENT2\t = %d => %.3f A\n", p_reg->measured_current2, p_reg->measured_current2 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_CURRENT3, 1, &p_reg->measured_current3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_CURRENT3\t = %d => %.3f A\n", p_reg->measured_current3, p_reg->measured_current3 / 1000.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_VOLTAGE0, 1, &p_reg->measured_voltage0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_VOLTAGE0\t = %d => %.1f V\n", p_reg->measured_voltage0, p_reg->measured_voltage0 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_VOLTAGE1, 1, &p_reg->measured_voltage1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_VOLTAGE1\t = %d => %.1f V\n", p_reg->measured_voltage1, p_reg->measured_voltage1 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_VOLTAGE2, 1, &p_reg->measured_voltage2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_VOLTAGE2\t = %d => %.1f V\n", p_reg->measured_voltage2, p_reg->measured_voltage2 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_MEASURED_VOLTAGE3, 1, &p_reg->measured_voltage3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("MEASURED_VOLTAGE3\t = %d => %.1f V\n", p_reg->measured_voltage3, p_reg->measured_voltage3 / 10.0);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_ERROR_WORD, 1, &p_reg->error_word, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("ERROR_WORD\t\t = 0x%04X\n", p_reg->error_word);

	if (read_all_regs && (err = modbus_reg_rd_group(p_modbus, LTDVE4CH_ADR_BOARD_COMMAND, 1, &p_reg->board_command, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (read_all_regs && print) printf("BOARD_COMMAND\t\t = %d\n", p_reg->board_command);
	
exit:
	return err;
}

/* write all the general purpose registers */
int ltdve4ch_gen_reg_wr(modbus_t *p_modbus, ltdve4ch_reg_wr_t *p_reg, int print, int write_cal_regs)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	p_reg->osc_period = FORCE_RANGE(p_reg->osc_period, 0, 65535);
	p_reg->filter_sel0 = FORCE_RANGE(p_reg->filter_sel0, 0, 65535);
	p_reg->filter_sel1 = FORCE_RANGE(p_reg->filter_sel1, 0, 65535);
	p_reg->filter_sel2 = FORCE_RANGE(p_reg->filter_sel2, 0, 65535);
	p_reg->filter_sel3 = FORCE_RANGE(p_reg->filter_sel3, 0, 65535);
	p_reg->input_sel0 = FORCE_RANGE(p_reg->input_sel0, 0, 65535);
	p_reg->input_sel1 = FORCE_RANGE(p_reg->input_sel1, 0, 65535);
	p_reg->input_sel2 = FORCE_RANGE(p_reg->input_sel2, 0, 65535);
	p_reg->input_sel3 = FORCE_RANGE(p_reg->input_sel3, 0, 65535);
	p_reg->input_sel4 = FORCE_RANGE(p_reg->input_sel4, 0, 65535);
	p_reg->input_sel5 = FORCE_RANGE(p_reg->input_sel5, 0, 65535);
	p_reg->input_sel6 = FORCE_RANGE(p_reg->input_sel6, 0, 65535);
	p_reg->input_sel7 = FORCE_RANGE(p_reg->input_sel7, 0, 65535);
	p_reg->gen_dly_base0 = FORCE_RANGE(p_reg->gen_dly_base0, 0, 65535);
	p_reg->gen_dly_cnt0 = FORCE_RANGE(p_reg->gen_dly_cnt0, 0, 65535);
	p_reg->gen_wdt_base0 = FORCE_RANGE(p_reg->gen_wdt_base0, 0, 65535);
	p_reg->gen_wdt_cnt0 = FORCE_RANGE(p_reg->gen_wdt_cnt0, 0, 65535);
	p_reg->gen_dly_base1 = FORCE_RANGE(p_reg->gen_dly_base1, 0, 65535);
	p_reg->gen_dly_cnt1 = FORCE_RANGE(p_reg->gen_dly_cnt1, 0, 65535);
	p_reg->gen_wdt_base1 = FORCE_RANGE(p_reg->gen_wdt_base1, 0, 65535);
	p_reg->gen_wdt_cnt1 = FORCE_RANGE(p_reg->gen_wdt_cnt1, 0, 65535);
	p_reg->gen_dly_base2 = FORCE_RANGE(p_reg->gen_dly_base2, 0, 65535);
	p_reg->gen_dly_cnt2 = FORCE_RANGE(p_reg->gen_dly_cnt2, 0, 65535);
	p_reg->gen_wdt_base2 = FORCE_RANGE(p_reg->gen_wdt_base2, 0, 65535);
	p_reg->gen_wdt_cnt2 = FORCE_RANGE(p_reg->gen_wdt_cnt2, 0, 65535);
	p_reg->gen_dly_base3 = FORCE_RANGE(p_reg->gen_dly_base3, 0, 65535);
	p_reg->gen_dly_cnt3 = FORCE_RANGE(p_reg->gen_dly_cnt3, 0, 65535);
	p_reg->gen_wdt_base3 = FORCE_RANGE(p_reg->gen_wdt_base3, 0, 65535);
	p_reg->gen_wdt_cnt3 = FORCE_RANGE(p_reg->gen_wdt_cnt3, 0, 65535);
	p_reg->gen_dly_base4 = FORCE_RANGE(p_reg->gen_dly_base4, 0, 65535);
	p_reg->gen_dly_cnt4 = FORCE_RANGE(p_reg->gen_dly_cnt4, 0, 65535);
	p_reg->gen_wdt_base4 = FORCE_RANGE(p_reg->gen_wdt_base4, 0, 65535);
	p_reg->gen_wdt_cnt4 = FORCE_RANGE(p_reg->gen_wdt_cnt4, 0, 65535);
	p_reg->gen_dly_base5 = FORCE_RANGE(p_reg->gen_dly_base5, 0, 65535);
	p_reg->gen_dly_cnt5 = FORCE_RANGE(p_reg->gen_dly_cnt5, 0, 65535);
	p_reg->gen_wdt_base5 = FORCE_RANGE(p_reg->gen_wdt_base5, 0, 65535);
	p_reg->gen_wdt_cnt5 = FORCE_RANGE(p_reg->gen_wdt_cnt5, 0, 65535);
	p_reg->gen_dly_base6 = FORCE_RANGE(p_reg->gen_dly_base6, 0, 65535);
	p_reg->gen_dly_cnt6 = FORCE_RANGE(p_reg->gen_dly_cnt6, 0, 65535);
	p_reg->gen_wdt_base6 = FORCE_RANGE(p_reg->gen_wdt_base6, 0, 65535);
	p_reg->gen_wdt_cnt6 = FORCE_RANGE(p_reg->gen_wdt_cnt6, 0, 65535);
	p_reg->gen_dly_base7 = FORCE_RANGE(p_reg->gen_dly_base7, 0, 65535);
	p_reg->gen_dly_cnt7 = FORCE_RANGE(p_reg->gen_dly_cnt7, 0, 65535);
	p_reg->gen_wdt_base7 = FORCE_RANGE(p_reg->gen_wdt_base7, 0, 65535);
	p_reg->gen_wdt_cnt7 = FORCE_RANGE(p_reg->gen_wdt_cnt7, 0, 65535);
	p_reg->output_sel_hi0 = FORCE_RANGE(p_reg->output_sel_hi0, 0, 65535);
	p_reg->output_sel_lo0 = FORCE_RANGE(p_reg->output_sel_lo0, 0, 65535);
	p_reg->output_sel_hi1 = FORCE_RANGE(p_reg->output_sel_hi1, 0, 65535);
	p_reg->output_sel_lo1 = FORCE_RANGE(p_reg->output_sel_lo1, 0, 65535);
	p_reg->output_sel_hi2 = FORCE_RANGE(p_reg->output_sel_hi2, 0, 65535);
	p_reg->output_sel_lo2 = FORCE_RANGE(p_reg->output_sel_lo2, 0, 65535);
	p_reg->output_sel_hi3 = FORCE_RANGE(p_reg->output_sel_hi3, 0, 65535);
	p_reg->output_sel_lo3 = FORCE_RANGE(p_reg->output_sel_lo3, 0, 65535);
	p_reg->output_sel_hi8 = FORCE_RANGE(p_reg->output_sel_hi8, 0, 65535);
	p_reg->output_sel_lo8 = FORCE_RANGE(p_reg->output_sel_lo8, 0, 65535);
	p_reg->output_sel_hi9 = FORCE_RANGE(p_reg->output_sel_hi9, 0, 65535);
	p_reg->output_sel_lo9 = FORCE_RANGE(p_reg->output_sel_lo9, 0, 65535);
	p_reg->output_sel_hi10 = FORCE_RANGE(p_reg->output_sel_hi10, 0, 65535);
	p_reg->output_sel_lo10 = FORCE_RANGE(p_reg->output_sel_lo10, 0, 65535);
	p_reg->output_sel_hi11 = FORCE_RANGE(p_reg->output_sel_hi11, 0, 65535);
	p_reg->output_sel_lo11 = FORCE_RANGE(p_reg->output_sel_lo11, 0, 65535);
	p_reg->prt_cnt_on0 = FORCE_RANGE(p_reg->prt_cnt_on0, 0, 65535);
	p_reg->prt_ena_on0 = FORCE_RANGE(p_reg->prt_ena_on0, 0, 65535);
	p_reg->prt_cnt_off0 = FORCE_RANGE(p_reg->prt_cnt_off0, 0, 65535);
	p_reg->prt_ena_off0 = FORCE_RANGE(p_reg->prt_ena_off0, 0, 65535);
	p_reg->prt_cnt_on1 = FORCE_RANGE(p_reg->prt_cnt_on1, 0, 65535);
	p_reg->prt_ena_on1 = FORCE_RANGE(p_reg->prt_ena_on1, 0, 65535);
	p_reg->prt_cnt_off1 = FORCE_RANGE(p_reg->prt_cnt_off1, 0, 65535);
	p_reg->prt_ena_off1 = FORCE_RANGE(p_reg->prt_ena_off1, 0, 65535);
	p_reg->prt_cnt_on2 = FORCE_RANGE(p_reg->prt_cnt_on2, 0, 65535);
	p_reg->prt_ena_on2 = FORCE_RANGE(p_reg->prt_ena_on2, 0, 65535);
	p_reg->prt_cnt_off2 = FORCE_RANGE(p_reg->prt_cnt_off2, 0, 65535);
	p_reg->prt_ena_off2 = FORCE_RANGE(p_reg->prt_ena_off2, 0, 65535);
	p_reg->prt_cnt_on3 = FORCE_RANGE(p_reg->prt_cnt_on3, 0, 65535);
	p_reg->prt_ena_on3 = FORCE_RANGE(p_reg->prt_ena_on3, 0, 65535);
	p_reg->prt_cnt_off3 = FORCE_RANGE(p_reg->prt_cnt_off3, 0, 65535);
	p_reg->prt_ena_off3 = FORCE_RANGE(p_reg->prt_ena_off3, 0, 65535);
	p_reg->cur_range0 = FORCE_RANGE(p_reg->cur_range0, 0, 65535);
	p_reg->cur_value0 = FORCE_RANGE(p_reg->cur_value0, 0, 65535);
	p_reg->cur_range1 = FORCE_RANGE(p_reg->cur_range1, 0, 65535);
	p_reg->cur_value1 = FORCE_RANGE(p_reg->cur_value1, 0, 65535);
	p_reg->cur_range2 = FORCE_RANGE(p_reg->cur_range2, 0, 65535);
	p_reg->cur_value2 = FORCE_RANGE(p_reg->cur_value2, 0, 65535);
	p_reg->cur_range3 = FORCE_RANGE(p_reg->cur_range3, 0, 65535);
	p_reg->cur_value3 = FORCE_RANGE(p_reg->cur_value3, 0, 65535);
	p_reg->rs485_modbus_addr = FORCE_RANGE(p_reg->rs485_modbus_addr, 1, 247);
	p_reg->rs485_line_speed = FORCE_RANGE(p_reg->rs485_line_speed, 0, 65535);
	p_reg->rs485_line_parity = FORCE_RANGE(p_reg->rs485_line_parity, 0, 65535);
	p_reg->eth_mac_addr0 = FORCE_RANGE(p_reg->eth_mac_addr0, 0, 65535);
	p_reg->eth_mac_addr1 = FORCE_RANGE(p_reg->eth_mac_addr1, 0, 65535);
	p_reg->eth_mac_addr2 = FORCE_RANGE(p_reg->eth_mac_addr2, 0, 65535);
	p_reg->eth_hostname0 = FORCE_RANGE(p_reg->eth_hostname0, 0, 65535);
	p_reg->eth_hostname1 = FORCE_RANGE(p_reg->eth_hostname1, 0, 65535);
	p_reg->eth_hostname2 = FORCE_RANGE(p_reg->eth_hostname2, 0, 65535);
	p_reg->eth_hostname3 = FORCE_RANGE(p_reg->eth_hostname3, 0, 65535);
	p_reg->eth_hostname4 = FORCE_RANGE(p_reg->eth_hostname4, 0, 65535);
	p_reg->eth_hostname5 = FORCE_RANGE(p_reg->eth_hostname5, 0, 65535);
	p_reg->eth_hostname6 = FORCE_RANGE(p_reg->eth_hostname6, 0, 65535);
	p_reg->eth_hostname7 = FORCE_RANGE(p_reg->eth_hostname7, 0, 65535);
	p_reg->eth_dhcp_enable = FORCE_RANGE(p_reg->eth_dhcp_enable, 0, 65535);
	p_reg->eth_ip_addr_hi = FORCE_RANGE(p_reg->eth_ip_addr_hi, 0, 65535);
	p_reg->eth_ip_addr_lo = FORCE_RANGE(p_reg->eth_ip_addr_lo, 0, 65535);
	p_reg->eth_subnet_mask_hi = FORCE_RANGE(p_reg->eth_subnet_mask_hi, 0, 65535);
	p_reg->eth_subnet_mask_lo = FORCE_RANGE(p_reg->eth_subnet_mask_lo, 0, 65535);
	p_reg->eth_def_gateway_hi = FORCE_RANGE(p_reg->eth_def_gateway_hi, 0, 65535);
	p_reg->eth_def_gateway_lo = FORCE_RANGE(p_reg->eth_def_gateway_lo, 0, 65535);
	p_reg->eth_pri_dns_hi = FORCE_RANGE(p_reg->eth_pri_dns_hi, 0, 65535);
	p_reg->eth_pri_dns_lo = FORCE_RANGE(p_reg->eth_pri_dns_lo, 0, 65535);
	p_reg->eth_sec_dns_hi = FORCE_RANGE(p_reg->eth_sec_dns_hi, 0, 65535);
	p_reg->eth_sec_dns_lo = FORCE_RANGE(p_reg->eth_sec_dns_lo, 0, 65535);
	p_reg->eth_modbus_addr = FORCE_RANGE(p_reg->eth_modbus_addr, 1, 247);
	p_reg->eth_modbus_tcp_port = FORCE_RANGE(p_reg->eth_modbus_tcp_port, 1, 65535);
	p_reg->eth_modbus_udp_port = FORCE_RANGE(p_reg->eth_modbus_udp_port, 1, 65535);
	p_reg->web_password0 = FORCE_RANGE(p_reg->web_password0, 0, 65535);
	p_reg->web_password1 = FORCE_RANGE(p_reg->web_password1, 0, 65535);
	p_reg->web_password2 = FORCE_RANGE(p_reg->web_password2, 0, 65535);
	p_reg->web_password3 = FORCE_RANGE(p_reg->web_password3, 0, 65535);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OSC_PERIOD, 1, &p_reg->osc_period)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OSC_PERIOD\t\t = %d\n", p_reg->osc_period);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL0, 1, &p_reg->filter_sel0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FILTER_SEL0\t\t = %d\n", p_reg->filter_sel0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL1, 1, &p_reg->filter_sel1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FILTER_SEL1\t\t = %d\n", p_reg->filter_sel1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL2, 1, &p_reg->filter_sel2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FILTER_SEL2\t\t = %d\n", p_reg->filter_sel2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_FILTER_SEL3, 1, &p_reg->filter_sel3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("FILTER_SEL3\t\t = %d\n", p_reg->filter_sel3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL0, 1, &p_reg->input_sel0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL0\t\t = 0x%04X\n", p_reg->input_sel0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL1, 1, &p_reg->input_sel1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL1\t\t = 0x%04X\n", p_reg->input_sel1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL2, 1, &p_reg->input_sel2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL2\t\t = 0x%04X\n", p_reg->input_sel2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL3, 1, &p_reg->input_sel3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL3\t\t = 0x%04X\n", p_reg->input_sel3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL4, 1, &p_reg->input_sel4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL4\t\t = 0x%04X\n", p_reg->input_sel4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL5, 1, &p_reg->input_sel5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL5\t\t = 0x%04X\n", p_reg->input_sel5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL6, 1, &p_reg->input_sel6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL6\t\t = 0x%04X\n", p_reg->input_sel6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_INPUT_SEL7, 1, &p_reg->input_sel7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INPUT_SEL7\t\t = 0x%04X\n", p_reg->input_sel7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE0, 1, &p_reg->gen_dly_base0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE0\t\t = %d\n", p_reg->gen_dly_base0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT0, 1, &p_reg->gen_dly_cnt0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT0\t\t = %d\n", p_reg->gen_dly_cnt0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE0, 1, &p_reg->gen_wdt_base0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE0\t\t = %d\n", p_reg->gen_wdt_base0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT0, 1, &p_reg->gen_wdt_cnt0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT0\t\t = %d\n", p_reg->gen_wdt_cnt0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE1, 1, &p_reg->gen_dly_base1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE1\t\t = %d\n", p_reg->gen_dly_base1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT1, 1, &p_reg->gen_dly_cnt1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT1\t\t = %d\n", p_reg->gen_dly_cnt1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE1, 1, &p_reg->gen_wdt_base1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE1\t\t = %d\n", p_reg->gen_wdt_base1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT1, 1, &p_reg->gen_wdt_cnt1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT1\t\t = %d\n", p_reg->gen_wdt_cnt1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE2, 1, &p_reg->gen_dly_base2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE2\t\t = %d\n", p_reg->gen_dly_base2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT2, 1, &p_reg->gen_dly_cnt2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT2\t\t = %d\n", p_reg->gen_dly_cnt2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE2, 1, &p_reg->gen_wdt_base2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE2\t\t = %d\n", p_reg->gen_wdt_base2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT2, 1, &p_reg->gen_wdt_cnt2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT2\t\t = %d\n", p_reg->gen_wdt_cnt2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE3, 1, &p_reg->gen_dly_base3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE3\t\t = %d\n", p_reg->gen_dly_base3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT3, 1, &p_reg->gen_dly_cnt3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT3\t\t = %d\n", p_reg->gen_dly_cnt3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE3, 1, &p_reg->gen_wdt_base3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE3\t\t = %d\n", p_reg->gen_wdt_base3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT3, 1, &p_reg->gen_wdt_cnt3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT3\t\t = %d\n", p_reg->gen_wdt_cnt3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE4, 1, &p_reg->gen_dly_base4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE4\t\t = %d\n", p_reg->gen_dly_base4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT4, 1, &p_reg->gen_dly_cnt4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT4\t\t = %d\n", p_reg->gen_dly_cnt4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE4, 1, &p_reg->gen_wdt_base4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE4\t\t = %d\n", p_reg->gen_wdt_base4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT4, 1, &p_reg->gen_wdt_cnt4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT4\t\t = %d\n", p_reg->gen_wdt_cnt4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE5, 1, &p_reg->gen_dly_base5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE5\t\t = %d\n", p_reg->gen_dly_base5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT5, 1, &p_reg->gen_dly_cnt5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT5\t\t = %d\n", p_reg->gen_dly_cnt5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE5, 1, &p_reg->gen_wdt_base5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE5\t\t = %d\n", p_reg->gen_wdt_base5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT5, 1, &p_reg->gen_wdt_cnt5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT5\t\t = %d\n", p_reg->gen_wdt_cnt5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE6, 1, &p_reg->gen_dly_base6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE6\t\t = %d\n", p_reg->gen_dly_base6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT6, 1, &p_reg->gen_dly_cnt6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT6\t\t = %d\n", p_reg->gen_dly_cnt6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE6, 1, &p_reg->gen_wdt_base6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE6\t\t = %d\n", p_reg->gen_wdt_base6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT6, 1, &p_reg->gen_wdt_cnt6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT6\t\t = %d\n", p_reg->gen_wdt_cnt6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_BASE7, 1, &p_reg->gen_dly_base7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_BASE7\t\t = %d\n", p_reg->gen_dly_base7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_DLY_CNT7, 1, &p_reg->gen_dly_cnt7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DLY_CNT7\t\t = %d\n", p_reg->gen_dly_cnt7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_BASE7, 1, &p_reg->gen_wdt_base7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_BASE7\t\t = %d\n", p_reg->gen_wdt_base7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_GEN_WDT_CNT7, 1, &p_reg->gen_wdt_cnt7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_WDT_CNT7\t\t = %d\n", p_reg->gen_wdt_cnt7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI0, 1, &p_reg->output_sel_hi0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI0\t\t = 0x%04X\n", p_reg->output_sel_hi0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO0, 1, &p_reg->output_sel_lo0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO0\t\t = 0x%04X\n", p_reg->output_sel_lo0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI1, 1, &p_reg->output_sel_hi1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI1\t\t = 0x%04X\n", p_reg->output_sel_hi1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO1, 1, &p_reg->output_sel_lo1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO1\t\t = 0x%04X\n", p_reg->output_sel_lo1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI2, 1, &p_reg->output_sel_hi2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI2\t\t = 0x%04X\n", p_reg->output_sel_hi2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO2, 1, &p_reg->output_sel_lo2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO2\t\t = 0x%04X\n", p_reg->output_sel_lo2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI3, 1, &p_reg->output_sel_hi3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI3\t\t = 0x%04X\n", p_reg->output_sel_hi3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO3, 1, &p_reg->output_sel_lo3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO3\t\t = 0x%04X\n", p_reg->output_sel_lo3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI8, 1, &p_reg->output_sel_hi8)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI8\t\t = 0x%04X\n", p_reg->output_sel_hi8);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO8, 1, &p_reg->output_sel_lo8)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO8\t\t = 0x%04X\n", p_reg->output_sel_lo8);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI9, 1, &p_reg->output_sel_hi9)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI9\t\t = 0x%04X\n", p_reg->output_sel_hi9);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO9, 1, &p_reg->output_sel_lo9)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO9\t\t = 0x%04X\n", p_reg->output_sel_lo9);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI10, 1, &p_reg->output_sel_hi10)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI10\t\t = 0x%04X\n", p_reg->output_sel_hi10);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO10, 1, &p_reg->output_sel_lo10)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO10\t\t = 0x%04X\n", p_reg->output_sel_lo10);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_HI11, 1, &p_reg->output_sel_hi11)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_HI11\t\t = 0x%04X\n", p_reg->output_sel_hi11);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_OUTPUT_SEL_LO11, 1, &p_reg->output_sel_lo11)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUTPUT_SEL_LO11\t\t = 0x%04X\n", p_reg->output_sel_lo11);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON0, 1, &p_reg->prt_cnt_on0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_ON0\t\t = %d\n", p_reg->prt_cnt_on0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON0, 1, &p_reg->prt_ena_on0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_ON0\t\t = %d\n", p_reg->prt_ena_on0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF0, 1, &p_reg->prt_cnt_off0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_OFF0\t\t = %d\n", p_reg->prt_cnt_off0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF0, 1, &p_reg->prt_ena_off0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_OFF0\t\t = %d\n", p_reg->prt_ena_off0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON1, 1, &p_reg->prt_cnt_on1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_ON1\t\t = %d\n", p_reg->prt_cnt_on1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON1, 1, &p_reg->prt_ena_on1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_ON1\t\t = %d\n", p_reg->prt_ena_on1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF1, 1, &p_reg->prt_cnt_off1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_OFF1\t\t = %d\n", p_reg->prt_cnt_off1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF1, 1, &p_reg->prt_ena_off1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_OFF1\t\t = %d\n", p_reg->prt_ena_off1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON2, 1, &p_reg->prt_cnt_on2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_ON2\t\t = %d\n", p_reg->prt_cnt_on2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON2, 1, &p_reg->prt_ena_on2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_ON2\t\t = %d\n", p_reg->prt_ena_on2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF2, 1, &p_reg->prt_cnt_off2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_OFF2\t\t = %d\n", p_reg->prt_cnt_off2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF2, 1, &p_reg->prt_ena_off2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_OFF2\t\t = %d\n", p_reg->prt_ena_off2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_ON3, 1, &p_reg->prt_cnt_on3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_ON3\t\t = %d\n", p_reg->prt_cnt_on3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_ON3, 1, &p_reg->prt_ena_on3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_ON3\t\t = %d\n", p_reg->prt_ena_on3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_CNT_OFF3, 1, &p_reg->prt_cnt_off3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_CNT_OFF3\t\t = %d\n", p_reg->prt_cnt_off3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_PRT_ENA_OFF3, 1, &p_reg->prt_ena_off3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("PRT_ENA_OFF3\t\t = %d\n", p_reg->prt_ena_off3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE0, 1, &p_reg->cur_range0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_RANGE0\t\t = %d\n", p_reg->cur_range0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE0, 1, &p_reg->cur_value0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_VALUE0\t\t = %d => %.3f A\n", p_reg->cur_value0, p_reg->cur_value0 / 1000.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE1, 1, &p_reg->cur_range1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_RANGE1\t\t = %d\n", p_reg->cur_range1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE1, 1, &p_reg->cur_value1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_VALUE1\t\t = %d => %.3f A\n", p_reg->cur_value1, p_reg->cur_value1 / 1000.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE2, 1, &p_reg->cur_range2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_RANGE2\t\t = %d\n", p_reg->cur_range2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE2, 1, &p_reg->cur_value2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_VALUE2\t\t = %d => %.3f A\n", p_reg->cur_value2, p_reg->cur_value2 / 1000.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_RANGE3, 1, &p_reg->cur_range3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_RANGE3\t\t = %d\n", p_reg->cur_range3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_CUR_VALUE3, 1, &p_reg->cur_value3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_VALUE3\t\t = %d => %.3f A\n", p_reg->cur_value3, p_reg->cur_value3 / 1000.0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_RS485_MODBUS_ADDR, 1, &p_reg->rs485_modbus_addr)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_MODBUS_ADDR\t = %d\n", p_reg->rs485_modbus_addr);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_RS485_LINE_SPEED, 1, &p_reg->rs485_line_speed)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_LINE_SPEED\t = %d\n", p_reg->rs485_line_speed);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_RS485_LINE_PARITY, 1, &p_reg->rs485_line_parity)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("RS485_LINE_PARITY\t = %d\n", p_reg->rs485_line_parity);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR0, 1, &p_reg->eth_mac_addr0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR0\t\t = 0x%04X\n", p_reg->eth_mac_addr0);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR1, 1, &p_reg->eth_mac_addr1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR1\t\t = 0x%04X\n", p_reg->eth_mac_addr1);

	if (write_cal_regs && (err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MAC_ADDR2, 1, &p_reg->eth_mac_addr2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (write_cal_regs && print) printf("ETH_MAC_ADDR2\t\t = 0x%04X\n", p_reg->eth_mac_addr2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME0, 1, &p_reg->eth_hostname0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME0\t\t = 0x%04X\n", p_reg->eth_hostname0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME1, 1, &p_reg->eth_hostname1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME1\t\t = 0x%04X\n", p_reg->eth_hostname1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME2, 1, &p_reg->eth_hostname2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME2\t\t = 0x%04X\n", p_reg->eth_hostname2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME3, 1, &p_reg->eth_hostname3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME3\t\t = 0x%04X\n", p_reg->eth_hostname3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME4, 1, &p_reg->eth_hostname4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME4\t\t = 0x%04X\n", p_reg->eth_hostname4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME5, 1, &p_reg->eth_hostname5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME5\t\t = 0x%04X\n", p_reg->eth_hostname5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME6, 1, &p_reg->eth_hostname6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME6\t\t = 0x%04X\n", p_reg->eth_hostname6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_HOSTNAME7, 1, &p_reg->eth_hostname7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_HOSTNAME7\t\t = 0x%04X\n", p_reg->eth_hostname7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_DHCP_ENABLE, 1, &p_reg->eth_dhcp_enable)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DHCP_ENABLE\t\t = %d\n", p_reg->eth_dhcp_enable);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_IP_ADDR_HI, 1, &p_reg->eth_ip_addr_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_IP_ADDR_HI\t\t = 0x%04X\n", p_reg->eth_ip_addr_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_IP_ADDR_LO, 1, &p_reg->eth_ip_addr_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_IP_ADDR_LO\t\t = 0x%04X\n", p_reg->eth_ip_addr_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_SUBNET_MASK_HI, 1, &p_reg->eth_subnet_mask_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SUBNET_MASK_HI\t = 0x%04X\n", p_reg->eth_subnet_mask_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_SUBNET_MASK_LO, 1, &p_reg->eth_subnet_mask_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SUBNET_MASK_LO\t = 0x%04X\n", p_reg->eth_subnet_mask_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_DEF_GATEWAY_HI, 1, &p_reg->eth_def_gateway_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DEF_GATEWAY_HI\t = 0x%04X\n", p_reg->eth_def_gateway_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_DEF_GATEWAY_LO, 1, &p_reg->eth_def_gateway_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_DEF_GATEWAY_LO\t = 0x%04X\n", p_reg->eth_def_gateway_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_PRI_DNS_HI, 1, &p_reg->eth_pri_dns_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_PRI_DNS_HI\t\t = 0x%04X\n", p_reg->eth_pri_dns_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_PRI_DNS_LO, 1, &p_reg->eth_pri_dns_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_PRI_DNS_LO\t\t = 0x%04X\n", p_reg->eth_pri_dns_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_SEC_DNS_HI, 1, &p_reg->eth_sec_dns_hi)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SEC_DNS_HI\t\t = 0x%04X\n", p_reg->eth_sec_dns_hi);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_SEC_DNS_LO, 1, &p_reg->eth_sec_dns_lo)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_SEC_DNS_LO\t\t = 0x%04X\n", p_reg->eth_sec_dns_lo);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_ADDR, 1, &p_reg->eth_modbus_addr)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_ADDR\t\t = %d\n", p_reg->eth_modbus_addr);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_TCP_PORT, 1, &p_reg->eth_modbus_tcp_port)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_TCP_PORT\t = %d\n", p_reg->eth_modbus_tcp_port);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_ETH_MODBUS_UDP_PORT, 1, &p_reg->eth_modbus_udp_port)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("ETH_MODBUS_UDP_PORT\t = %d\n", p_reg->eth_modbus_udp_port);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD0, 1, &p_reg->web_password0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD0\t\t = 0x%04X\n", p_reg->web_password0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD1, 1, &p_reg->web_password1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD1\t\t = 0x%04X\n", p_reg->web_password1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD2, 1, &p_reg->web_password2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD2\t\t = 0x%04X\n", p_reg->web_password2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDVE4CH_ADR_WEB_PASSWORD3, 1, &p_reg->web_password3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("WEB_PASSWORD3\t\t = 0x%04X\n", p_reg->web_password3);

exit:
	return err;
}

/* write the board command register */
int ltdve4ch_brd_cmd_wr(modbus_t *p_modbus, int reg_val)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (reg_val < 0) { err = 1; printf("bad parameter reg_val\n"); goto exit; }
	if (reg_val > 3) { err = 1; printf("bad parameter reg_val\n"); goto exit; }

	if ((err = modbus_reg_wr_single(p_modbus, LTDVE4CH_ADR_BOARD_COMMAND, reg_val)) != 0) {
		printf("error in modbus_reg_wr_single() call\n");
		goto exit;
	}

exit:
	return err;
}

/* file ends here */
