/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#define FORCE_RANGE(v, a, b) ((v) < (a) ? (a) : ((v) > (b) ? (b) : (v)))

/* register file */
#define LTDVE2CH_ADR_DEVICE_TYPE			(0)
#define LTDVE2CH_ADR_BOOT_VERSION			(1)
#define LTDVE2CH_ADR_MCU_VERSION			(2)
#define LTDVE2CH_ADR_FPGA_VERSION			(3)
#define LTDVE2CH_ADR_BOARD_VERSION			(4)
#define LTDVE2CH_ADR_OSC_PERIOD				(5)
#define LTDVE2CH_ADR_FILTER_SEL0			(6)
#define LTDVE2CH_ADR_FILTER_SEL1			(7)
#define LTDVE2CH_ADR_UNUSED_8				(8)
#define LTDVE2CH_ADR_UNUSED_9				(9)
#define LTDVE2CH_ADR_UNUSED_10				(10)
#define LTDVE2CH_ADR_UNUSED_11				(11)
#define LTDVE2CH_ADR_UNUSED_12				(12)
#define LTDVE2CH_ADR_UNUSED_13				(13)
#define LTDVE2CH_ADR_INPUT_SEL0				(14)
#define LTDVE2CH_ADR_INPUT_SEL1				(15)
#define LTDVE2CH_ADR_INPUT_SEL2				(16)
#define LTDVE2CH_ADR_INPUT_SEL3				(17)
#define LTDVE2CH_ADR_UNUSED_18				(18)
#define LTDVE2CH_ADR_UNUSED_19				(19)
#define LTDVE2CH_ADR_UNUSED_20				(20)
#define LTDVE2CH_ADR_UNUSED_21				(21)
#define LTDVE2CH_ADR_UNUSED_22				(22)
#define LTDVE2CH_ADR_UNUSED_23				(23)
#define LTDVE2CH_ADR_UNUSED_24				(24)
#define LTDVE2CH_ADR_UNUSED_25				(25)
#define LTDVE2CH_ADR_UNUSED_26				(26)
#define LTDVE2CH_ADR_UNUSED_27				(27)
#define LTDVE2CH_ADR_UNUSED_28				(28)
#define LTDVE2CH_ADR_UNUSED_29				(29)
#define LTDVE2CH_ADR_GEN_DLY_BASE0			(30)
#define LTDVE2CH_ADR_GEN_DLY_CNT0			(31)
#define LTDVE2CH_ADR_GEN_WDT_BASE0			(32)
#define LTDVE2CH_ADR_GEN_WDT_CNT0			(33)
#define LTDVE2CH_ADR_GEN_DLY_BASE1			(34)
#define LTDVE2CH_ADR_GEN_DLY_CNT1			(35)
#define LTDVE2CH_ADR_GEN_WDT_BASE1			(36)
#define LTDVE2CH_ADR_GEN_WDT_CNT1			(37)
#define LTDVE2CH_ADR_GEN_DLY_BASE2			(38)
#define LTDVE2CH_ADR_GEN_DLY_CNT2			(39)
#define LTDVE2CH_ADR_GEN_WDT_BASE2			(40)
#define LTDVE2CH_ADR_GEN_WDT_CNT2			(41)
#define LTDVE2CH_ADR_GEN_DLY_BASE3			(42)
#define LTDVE2CH_ADR_GEN_DLY_CNT3			(43)
#define LTDVE2CH_ADR_GEN_WDT_BASE3			(44)
#define LTDVE2CH_ADR_GEN_WDT_CNT3			(45)
#define LTDVE2CH_ADR_UNUSED_46				(46)
#define LTDVE2CH_ADR_UNUSED_47				(47)
#define LTDVE2CH_ADR_UNUSED_48				(48)
#define LTDVE2CH_ADR_UNUSED_49				(49)
#define LTDVE2CH_ADR_UNUSED_50				(50)
#define LTDVE2CH_ADR_UNUSED_51				(51)
#define LTDVE2CH_ADR_UNUSED_52				(52)
#define LTDVE2CH_ADR_UNUSED_53				(53)
#define LTDVE2CH_ADR_UNUSED_54				(54)
#define LTDVE2CH_ADR_UNUSED_55				(55)
#define LTDVE2CH_ADR_UNUSED_56				(56)
#define LTDVE2CH_ADR_UNUSED_57				(57)
#define LTDVE2CH_ADR_UNUSED_58				(58)
#define LTDVE2CH_ADR_UNUSED_59				(59)
#define LTDVE2CH_ADR_UNUSED_60				(60)
#define LTDVE2CH_ADR_UNUSED_61				(61)
#define LTDVE2CH_ADR_UNUSED_62				(62)
#define LTDVE2CH_ADR_UNUSED_63				(63)
#define LTDVE2CH_ADR_UNUSED_64				(64)
#define LTDVE2CH_ADR_UNUSED_65				(65)
#define LTDVE2CH_ADR_UNUSED_66				(66)
#define LTDVE2CH_ADR_UNUSED_67				(67)
#define LTDVE2CH_ADR_UNUSED_68				(68)
#define LTDVE2CH_ADR_UNUSED_69				(69)
#define LTDVE2CH_ADR_UNUSED_70				(70)
#define LTDVE2CH_ADR_UNUSED_71				(71)
#define LTDVE2CH_ADR_UNUSED_72				(72)
#define LTDVE2CH_ADR_UNUSED_73				(73)
#define LTDVE2CH_ADR_UNUSED_74				(74)
#define LTDVE2CH_ADR_UNUSED_75				(75)
#define LTDVE2CH_ADR_UNUSED_76				(76)
#define LTDVE2CH_ADR_UNUSED_77				(77)
#define LTDVE2CH_ADR_UNUSED_78				(78)
#define LTDVE2CH_ADR_UNUSED_79				(79)
#define LTDVE2CH_ADR_UNUSED_80				(80)
#define LTDVE2CH_ADR_UNUSED_81				(81)
#define LTDVE2CH_ADR_UNUSED_82				(82)
#define LTDVE2CH_ADR_UNUSED_83				(83)
#define LTDVE2CH_ADR_UNUSED_84				(84)
#define LTDVE2CH_ADR_UNUSED_85				(85)
#define LTDVE2CH_ADR_UNUSED_86				(86)
#define LTDVE2CH_ADR_UNUSED_87				(87)
#define LTDVE2CH_ADR_UNUSED_88				(88)
#define LTDVE2CH_ADR_UNUSED_89				(89)
#define LTDVE2CH_ADR_UNUSED_90				(90)
#define LTDVE2CH_ADR_UNUSED_91				(91)
#define LTDVE2CH_ADR_UNUSED_92				(92)
#define LTDVE2CH_ADR_UNUSED_93				(93)
#define LTDVE2CH_ADR_OUTPUT_SEL_HI0			(94)
#define LTDVE2CH_ADR_OUTPUT_SEL_LO0			(95)
#define LTDVE2CH_ADR_OUTPUT_SEL_HI1			(96)
#define LTDVE2CH_ADR_OUTPUT_SEL_LO1			(97)
#define LTDVE2CH_ADR_UNUSED_98				(98)
#define LTDVE2CH_ADR_UNUSED_99				(99)
#define LTDVE2CH_ADR_UNUSED_100				(100)
#define LTDVE2CH_ADR_UNUSED_101				(101)
#define LTDVE2CH_ADR_UNUSED_102				(102)
#define LTDVE2CH_ADR_UNUSED_103				(103)
#define LTDVE2CH_ADR_UNUSED_104				(104)
#define LTDVE2CH_ADR_UNUSED_105				(105)
#define LTDVE2CH_ADR_UNUSED_106				(106)
#define LTDVE2CH_ADR_UNUSED_107				(107)
#define LTDVE2CH_ADR_UNUSED_108				(108)
#define LTDVE2CH_ADR_UNUSED_109				(109)
#define LTDVE2CH_ADR_OUTPUT_SEL_HI8			(110)
#define LTDVE2CH_ADR_OUTPUT_SEL_LO8			(111)
#define LTDVE2CH_ADR_OUTPUT_SEL_HI9			(112)
#define LTDVE2CH_ADR_OUTPUT_SEL_LO9			(113)
#define LTDVE2CH_ADR_UNUSED_114				(114)
#define LTDVE2CH_ADR_UNUSED_115				(115)
#define LTDVE2CH_ADR_UNUSED_116				(116)
#define LTDVE2CH_ADR_UNUSED_117				(117)
#define LTDVE2CH_ADR_UNUSED_118				(118)
#define LTDVE2CH_ADR_UNUSED_119				(119)
#define LTDVE2CH_ADR_UNUSED_120				(120)
#define LTDVE2CH_ADR_UNUSED_121				(121)
#define LTDVE2CH_ADR_UNUSED_122				(122)
#define LTDVE2CH_ADR_UNUSED_123				(123)
#define LTDVE2CH_ADR_UNUSED_124				(124)
#define LTDVE2CH_ADR_UNUSED_125				(125)
#define LTDVE2CH_ADR_PRT_CNT_ON0			(126)
#define LTDVE2CH_ADR_PRT_ENA_ON0			(127)
#define LTDVE2CH_ADR_PRT_CNT_OFF0			(128)
#define LTDVE2CH_ADR_PRT_ENA_OFF0			(129)
#define LTDVE2CH_ADR_PRT_CNT_ON1			(130)
#define LTDVE2CH_ADR_PRT_ENA_ON1			(131)
#define LTDVE2CH_ADR_PRT_CNT_OFF1			(132)
#define LTDVE2CH_ADR_PRT_ENA_OFF1			(133)
#define LTDVE2CH_ADR_UNUSED_134				(134)
#define LTDVE2CH_ADR_UNUSED_135				(135)
#define LTDVE2CH_ADR_UNUSED_136				(136)
#define LTDVE2CH_ADR_UNUSED_137				(137)
#define LTDVE2CH_ADR_UNUSED_138				(138)
#define LTDVE2CH_ADR_UNUSED_139				(139)
#define LTDVE2CH_ADR_UNUSED_140				(140)
#define LTDVE2CH_ADR_UNUSED_141				(141)
#define LTDVE2CH_ADR_UNUSED_142				(142)
#define LTDVE2CH_ADR_UNUSED_143				(143)
#define LTDVE2CH_ADR_UNUSED_144				(144)
#define LTDVE2CH_ADR_UNUSED_145				(145)
#define LTDVE2CH_ADR_UNUSED_146				(146)
#define LTDVE2CH_ADR_UNUSED_147				(147)
#define LTDVE2CH_ADR_UNUSED_148				(148)
#define LTDVE2CH_ADR_UNUSED_149				(149)
#define LTDVE2CH_ADR_UNUSED_150				(150)
#define LTDVE2CH_ADR_UNUSED_151				(151)
#define LTDVE2CH_ADR_UNUSED_152				(152)
#define LTDVE2CH_ADR_UNUSED_153				(153)
#define LTDVE2CH_ADR_UNUSED_154				(154)
#define LTDVE2CH_ADR_UNUSED_155				(155)
#define LTDVE2CH_ADR_UNUSED_156				(156)
#define LTDVE2CH_ADR_UNUSED_157				(157)
#define LTDVE2CH_ADR_CUR_RANGE0				(158)
#define LTDVE2CH_ADR_CUR_VALUE0				(159)
#define LTDVE2CH_ADR_CUR_RANGE1				(160)
#define LTDVE2CH_ADR_CUR_VALUE1				(161)
#define LTDVE2CH_ADR_UNUSED_162				(162)
#define LTDVE2CH_ADR_UNUSED_163				(163)
#define LTDVE2CH_ADR_UNUSED_164				(164)
#define LTDVE2CH_ADR_UNUSED_165				(165)
#define LTDVE2CH_ADR_UNUSED_166				(166)
#define LTDVE2CH_ADR_UNUSED_167				(167)
#define LTDVE2CH_ADR_UNUSED_168				(168)
#define LTDVE2CH_ADR_UNUSED_169				(169)
#define LTDVE2CH_ADR_UNUSED_170				(170)
#define LTDVE2CH_ADR_UNUSED_171				(171)
#define LTDVE2CH_ADR_UNUSED_172				(172)
#define LTDVE2CH_ADR_UNUSED_173				(173)
#define LTDVE2CH_ADR_RS485_MODBUS_ADDR		(174)
#define LTDVE2CH_ADR_RS485_LINE_SPEED		(175)
#define LTDVE2CH_ADR_RS485_LINE_PARITY		(176)
#define LTDVE2CH_ADR_ETH_MAC_ADDR0			(177)
#define LTDVE2CH_ADR_ETH_MAC_ADDR1			(178)
#define LTDVE2CH_ADR_ETH_MAC_ADDR2			(179)
#define LTDVE2CH_ADR_ETH_HOSTNAME0			(180)
#define LTDVE2CH_ADR_ETH_HOSTNAME1			(181)
#define LTDVE2CH_ADR_ETH_HOSTNAME2			(182)
#define LTDVE2CH_ADR_ETH_HOSTNAME3			(183)
#define LTDVE2CH_ADR_ETH_HOSTNAME4			(184)
#define LTDVE2CH_ADR_ETH_HOSTNAME5			(185)
#define LTDVE2CH_ADR_ETH_HOSTNAME6			(186)
#define LTDVE2CH_ADR_ETH_HOSTNAME7			(187)
#define LTDVE2CH_ADR_ETH_DHCP_ENABLE		(188)
#define LTDVE2CH_ADR_ETH_IP_ADDR_HI			(189)
#define LTDVE2CH_ADR_ETH_IP_ADDR_LO			(190)
#define LTDVE2CH_ADR_ETH_SUBNET_MASK_HI		(191)
#define LTDVE2CH_ADR_ETH_SUBNET_MASK_LO		(192)
#define LTDVE2CH_ADR_ETH_DEF_GATEWAY_HI		(193)
#define LTDVE2CH_ADR_ETH_DEF_GATEWAY_LO		(194)
#define LTDVE2CH_ADR_ETH_PRI_DNS_HI			(195)
#define LTDVE2CH_ADR_ETH_PRI_DNS_LO			(196)
#define LTDVE2CH_ADR_ETH_SEC_DNS_HI			(197)
#define LTDVE2CH_ADR_ETH_SEC_DNS_LO			(198)
#define LTDVE2CH_ADR_ETH_MODBUS_ADDR		(199)
#define LTDVE2CH_ADR_ETH_MODBUS_TCP_PORT	(200)
#define LTDVE2CH_ADR_ETH_MODBUS_UDP_PORT	(201)
#define LTDVE2CH_ADR_WEB_PASSWORD0			(202)
#define LTDVE2CH_ADR_WEB_PASSWORD1			(203)
#define LTDVE2CH_ADR_WEB_PASSWORD2			(204)
#define LTDVE2CH_ADR_WEB_PASSWORD3			(205)
#define LTDVE2CH_ADR_CONVERTER_TEMPERATURE	(206)
#define LTDVE2CH_ADR_DRIVER_TEMPERATURE		(207)
#define LTDVE2CH_ADR_REMOTE_TEMPERATURE0	(208)
#define LTDVE2CH_ADR_REMOTE_TEMPERATURE1	(209)
#define LTDVE2CH_ADR_UNUSED_210				(210)
#define LTDVE2CH_ADR_SUPPLY_VOLTAGE			(211)
#define LTDVE2CH_ADR_MEASURED_CURRENT0		(212)
#define LTDVE2CH_ADR_MEASURED_CURRENT1		(213)
#define LTDVE2CH_ADR_UNUSED_214				(214)
#define LTDVE2CH_ADR_UNUSED_215				(215)
#define LTDVE2CH_ADR_UNUSED_216				(216)
#define LTDVE2CH_ADR_UNUSED_217				(217)
#define LTDVE2CH_ADR_UNUSED_218				(218)
#define LTDVE2CH_ADR_UNUSED_219				(219)
#define LTDVE2CH_ADR_MEASURED_VOLTAGE0		(220)
#define LTDVE2CH_ADR_MEASURED_VOLTAGE1		(221)
#define LTDVE2CH_ADR_UNUSED_222				(222)
#define LTDVE2CH_ADR_UNUSED_223				(223)
#define LTDVE2CH_ADR_UNUSED_224				(224)
#define LTDVE2CH_ADR_UNUSED_225				(225)
#define LTDVE2CH_ADR_UNUSED_226				(226)
#define LTDVE2CH_ADR_UNUSED_227				(227)
#define LTDVE2CH_ADR_ERROR_WORD				(228)
#define LTDVE2CH_ADR_GEN_HLD_BASE0			(229)
#define LTDVE2CH_ADR_GEN_HLD_CNT0			(230)
#define LTDVE2CH_ADR_GEN_HLD_BASE1			(231)
#define LTDVE2CH_ADR_GEN_HLD_CNT1			(232)
#define LTDVE2CH_ADR_GEN_HLD_BASE2			(233)
#define LTDVE2CH_ADR_GEN_HLD_CNT2			(234)
#define LTDVE2CH_ADR_GEN_HLD_BASE3			(235)
#define LTDVE2CH_ADR_GEN_HLD_CNT3			(236)
#define LTDVE2CH_ADR_UNUSED_237				(237)
#define LTDVE2CH_ADR_UNUSED_238				(238)
#define LTDVE2CH_ADR_UNUSED_239				(239)
#define LTDVE2CH_ADR_UNUSED_240				(240)
#define LTDVE2CH_ADR_UNUSED_241				(241)
#define LTDVE2CH_ADR_UNUSED_242				(242)
#define LTDVE2CH_ADR_UNUSED_243				(243)
#define LTDVE2CH_ADR_UNUSED_244				(244)
#define LTDVE2CH_ADR_UNUSED_245				(245)
#define LTDVE2CH_ADR_UNUSED_246				(246)
#define LTDVE2CH_ADR_UNUSED_247				(247)
#define LTDVE2CH_ADR_UNUSED_248				(248)
#define LTDVE2CH_ADR_UNUSED_249				(249)
#define LTDVE2CH_ADR_UNUSED_250				(250)
#define LTDVE2CH_ADR_UNUSED_251				(251)
#define LTDVE2CH_ADR_UNUSED_252				(252)
#define LTDVE2CH_ADR_UNUSED_253				(253)
#define LTDVE2CH_ADR_UNUSED_254				(254)
#define LTDVE2CH_ADR_UNUSED_255				(255)
#define LTDVE2CH_ADR_UNUSED_256				(256)
#define LTDVE2CH_ADR_UNUSED_257				(257)
#define LTDVE2CH_ADR_UNUSED_258				(258)
#define LTDVE2CH_ADR_UNUSED_259				(259)
#define LTDVE2CH_ADR_UNUSED_260				(260)
#define LTDVE2CH_ADR_GEN_EDGE_SEL0			(261)
#define LTDVE2CH_ADR_GEN_EDGE_SEL1			(262)
#define LTDVE2CH_ADR_GEN_EDGE_SEL2			(263)
#define LTDVE2CH_ADR_GEN_EDGE_SEL3			(264)
#define LTDVE2CH_ADR_UNUSED_265				(265)
#define LTDVE2CH_ADR_UNUSED_266				(266)
#define LTDVE2CH_ADR_UNUSED_267				(267)
#define LTDVE2CH_ADR_UNUSED_268				(268)
#define LTDVE2CH_ADR_UNUSED_269				(269)
#define LTDVE2CH_ADR_UNUSED_270				(270)
#define LTDVE2CH_ADR_UNUSED_271				(271)
#define LTDVE2CH_ADR_UNUSED_272				(272)
#define LTDVE2CH_ADR_UNUSED_273				(273)
#define LTDVE2CH_ADR_UNUSED_274				(274)
#define LTDVE2CH_ADR_UNUSED_275				(275)
#define LTDVE2CH_ADR_UNUSED_276				(276)
#define LTDVE2CH_ADR_RESERVED_277			(277)
#define LTDVE2CH_ADR_RESERVED_278			(278)
#define LTDVE2CH_ADR_RESERVED_279			(279)
#define LTDVE2CH_ADR_RESERVED_280			(280)
#define LTDVE2CH_ADR_RESERVED_281			(281)
#define LTDVE2CH_ADR_RESERVED_282			(282)
#define LTDVE2CH_ADR_RESERVED_283			(283)
#define LTDVE2CH_ADR_RESERVED_284			(284)
#define LTDVE2CH_ADR_DRIVE_TIME0			(285)
#define LTDVE2CH_ADR_DRIVE_TIME1			(286)
#define LTDVE2CH_ADR_UNUSED_287				(287)
#define LTDVE2CH_ADR_UNUSED_288				(288)
#define LTDVE2CH_ADR_UNUSED_289				(289)
#define LTDVE2CH_ADR_UNUSED_290				(290)
#define LTDVE2CH_ADR_UNUSED_291				(291)
#define LTDVE2CH_ADR_UNUSED_292				(292)
#define LTDVE2CH_ADR_CUR_RED_DLY0			(293)
#define LTDVE2CH_ADR_CUR_RED_VAL0			(294)
#define LTDVE2CH_ADR_CUR_RED_DLY1			(295)
#define LTDVE2CH_ADR_CUR_RED_VAL1			(296)
#define LTDVE2CH_ADR_UNUSED_297				(297)
#define LTDVE2CH_ADR_UNUSED_298				(298)
#define LTDVE2CH_ADR_UNUSED_299				(299)
#define LTDVE2CH_ADR_UNUSED_300				(300)
#define LTDVE2CH_ADR_UNUSED_301				(301)
#define LTDVE2CH_ADR_UNUSED_302				(302)
#define LTDVE2CH_ADR_UNUSED_303				(303)
#define LTDVE2CH_ADR_UNUSED_304				(304)
#define LTDVE2CH_ADR_UNUSED_305				(305)
#define LTDVE2CH_ADR_UNUSED_306				(306)
#define LTDVE2CH_ADR_UNUSED_307				(307)
#define LTDVE2CH_ADR_UNUSED_308				(308)
#define LTDVE2CH_ADR_SOFTWARE_TRIGGER		(309)
#define LTDVE2CH_ADR_CONVERTER_MODE			(310)
#define LTDVE2CH_ADR_CONVERTER_MAXIMUM_VLT	(311)
#define LTDVE2CH_ADR_CONVERTER_PRESET_VLT	(312)
#define LTDVE2CH_ADR_DRIVER_MODE			(313)
#define LTDVE2CH_ADR_DIGIPOT_VALUE			(314)
#define LTDVE2CH_ADR_CONVERTER_VOLTAGE		(315)
#define LTDVE2CH_ADR_DRIVER_VOLTAGE			(316)
#define LTDVE2CH_ADR_SUPPLY_CURRENT			(317)
#define LTDVE2CH_ADR_CONVERTER_CURRENT		(318)
#define LTDVE2CH_ADR_CAL_GEN_CUR_LOW_MUL0	(319)
#define LTDVE2CH_ADR_CAL_GEN_CUR_LOW_ADD0	(320)
#define LTDVE2CH_ADR_CAL_GEN_CUR_LOW_MUL1	(321)
#define LTDVE2CH_ADR_CAL_GEN_CUR_LOW_ADD1	(322)
#define LTDVE2CH_ADR_CAL_GEN_CUR_HIGH_MUL0	(323)
#define LTDVE2CH_ADR_CAL_GEN_CUR_HIGH_ADD0	(324)
#define LTDVE2CH_ADR_CAL_GEN_CUR_HIGH_MUL1	(325)
#define LTDVE2CH_ADR_CAL_GEN_CUR_HIGH_ADD1	(326)
#define LTDVE2CH_ADR_CAL_MES_CUR_LOW_MUL0	(327)
#define LTDVE2CH_ADR_CAL_MES_CUR_LOW_ADD0	(328)
#define LTDVE2CH_ADR_CAL_MES_CUR_LOW_MUL1	(329)
#define LTDVE2CH_ADR_CAL_MES_CUR_LOW_ADD1	(330)
#define LTDVE2CH_ADR_CAL_MES_CUR_HIGH_MUL0	(331)
#define LTDVE2CH_ADR_CAL_MES_CUR_HIGH_ADD0	(332)
#define LTDVE2CH_ADR_CAL_MES_CUR_HIGH_MUL1	(333)
#define LTDVE2CH_ADR_CAL_MES_CUR_HIGH_ADD1	(334)
#define LTDVE2CH_ADR_CAL_MES_VLT_LOW_MUL0	(335)
#define LTDVE2CH_ADR_CAL_MES_VLT_LOW_ADD0	(336)
#define LTDVE2CH_ADR_CAL_MES_VLT_LOW_MUL1	(337)
#define LTDVE2CH_ADR_CAL_MES_VLT_LOW_ADD1	(338)
#define LTDVE2CH_ADR_CAL_MES_VLT_HIGH_MUL0	(339)
#define LTDVE2CH_ADR_CAL_MES_VLT_HIGH_ADD0	(340)
#define LTDVE2CH_ADR_CAL_MES_VLT_HIGH_MUL1	(341)
#define LTDVE2CH_ADR_CAL_MES_VLT_HIGH_ADD1	(342)
#define LTDVE2CH_ADR_CAL_SET_CNV_POT_MUL	(343)
#define LTDVE2CH_ADR_CAL_SET_CNV_POT_ADD	(344)
#define LTDVE2CH_ADR_CAL_MES_TMP_CNV_MUL	(345)
#define LTDVE2CH_ADR_CAL_MES_TMP_CNV_ADD	(346)
#define LTDVE2CH_ADR_CAL_MES_TMP_DRV_MUL	(347)
#define LTDVE2CH_ADR_CAL_MES_TMP_DRV_ADD	(348)
#define LTDVE2CH_ADR_CAL_MES_TMP_REM_MUL0	(349)
#define LTDVE2CH_ADR_CAL_MES_TMP_REM_ADD0	(350)
#define LTDVE2CH_ADR_CAL_MES_TMP_REM_MUL1	(351)
#define LTDVE2CH_ADR_CAL_MES_TMP_REM_ADD1	(352)
#define LTDVE2CH_ADR_CAL_MES_VLT_SUP_MUL	(353)
#define LTDVE2CH_ADR_CAL_MES_VLT_SUP_ADD	(354)
#define LTDVE2CH_ADR_CAL_MES_VLT_CNV_MUL	(355)
#define LTDVE2CH_ADR_CAL_MES_VLT_CNV_ADD	(356)
#define LTDVE2CH_ADR_CAL_MES_VLT_DRV_MUL	(357)
#define LTDVE2CH_ADR_CAL_MES_VLT_DRV_ADD	(358)
#define LTDVE2CH_ADR_CAL_MES_CUR_SUP_MUL	(359)
#define LTDVE2CH_ADR_CAL_MES_CUR_SUP_ADD	(360)
#define LTDVE2CH_ADR_CAL_MES_CUR_CNV_MUL	(361)
#define LTDVE2CH_ADR_CAL_MES_CUR_CNV_ADD	(362)
#define LTDVE2CH_ADR_CAL_UNLOCK_CODE0		(363)
#define LTDVE2CH_ADR_CAL_UNLOCK_CODE1		(364)
#define LTDVE2CH_ADR_BOARD_COMMAND			(511)

/* general purpose read registers */
typedef struct {
	int device_type;
	int boot_version;
	int mcu_version;
	int fpga_version;
	int board_version;
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
	int converter_temperature;
	int driver_temperature;
	int remote_temperature0;
	int remote_temperature1;
	int supply_voltage;
	int measured_current0;
	int measured_current1;
	int measured_voltage0;
	int measured_voltage1;
	int error_word;
	int gen_hld_base0;
	int gen_hld_cnt0;
	int gen_hld_base1;
	int gen_hld_cnt1;
	int gen_hld_base2;
	int gen_hld_cnt2;
	int gen_hld_base3;
	int gen_hld_cnt3;
	int gen_edge_sel0;
	int gen_edge_sel1;
	int gen_edge_sel2;
	int gen_edge_sel3;
	int drive_time0;
	int drive_time1;
	int cur_red_delay0;
	int cur_red_value0;
	int cur_red_delay1;
	int cur_red_value1;
	int software_trigger;
	int converter_mode;
	int converter_maximum_voltage;
	int converter_preset_voltage;
	int driver_mode;
	int digipot_value;
	int converter_voltage;
	int driver_voltage;
	int supply_current;
	int converter_current;
	int cal_gen_cur_low_mul0;
	int cal_gen_cur_low_add0;
	int cal_gen_cur_low_mul1;
	int cal_gen_cur_low_add1;
	int cal_gen_cur_high_mul0;
	int cal_gen_cur_high_add0;
	int cal_gen_cur_high_mul1;
	int cal_gen_cur_high_add1;
	int cal_mes_cur_low_mul0;
	int cal_mes_cur_low_add0;
	int cal_mes_cur_low_mul1;
	int cal_mes_cur_low_add1;
	int cal_mes_cur_high_mul0;
	int cal_mes_cur_high_add0;
	int cal_mes_cur_high_mul1;
	int cal_mes_cur_high_add1;
	int cal_mes_vlt_low_mul0;
	int cal_mes_vlt_low_add0;
	int cal_mes_vlt_low_mul1;
	int cal_mes_vlt_low_add1;
	int cal_mes_vlt_high_mul0;
	int cal_mes_vlt_high_add0;
	int cal_mes_vlt_high_mul1;
	int cal_mes_vlt_high_add1;
	int cal_set_cnv_pot_mul;
	int cal_set_cnv_pot_add;
	int cal_mes_tmp_cnv_mul;
	int cal_mes_tmp_cnv_add;
	int cal_mes_tmp_drv_mul;
	int cal_mes_tmp_drv_add;
	int cal_mes_tmp_rem_mul0;
	int cal_mes_tmp_rem_add0;
	int cal_mes_tmp_rem_mul1;
	int cal_mes_tmp_rem_add1;
	int cal_mes_vlt_sup_mul;
	int cal_mes_vlt_sup_add;
	int cal_mes_vlt_cnv_mul;
	int cal_mes_vlt_cnv_add;
	int cal_mes_vlt_drv_mul;
	int cal_mes_vlt_drv_add;
	int cal_mes_cur_sup_mul;
	int cal_mes_cur_sup_add;
	int cal_mes_cur_cnv_mul;
	int cal_mes_cur_cnv_add;
	int cal_unlock_code0;
	int cal_unlock_code1;
	int board_command;
}
ltdve2ch_reg_rd_t;

/* general purpose write registers */
typedef struct {
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
	int gen_hld_base0;
	int gen_hld_cnt0;
	int gen_hld_base1;
	int gen_hld_cnt1;
	int gen_hld_base2;
	int gen_hld_cnt2;
	int gen_hld_base3;
	int gen_hld_cnt3;
	int gen_edge_sel0;
	int gen_edge_sel1;
	int gen_edge_sel2;
	int gen_edge_sel3;
	int cur_red_delay0;
	int cur_red_value0;
	int cur_red_delay1;
	int cur_red_value1;
	int software_trigger;
	int converter_mode;
	int converter_maximum_voltage;
	int driver_mode;
	int cal_gen_cur_low_mul0;
	int cal_gen_cur_low_add0;
	int cal_gen_cur_low_mul1;
	int cal_gen_cur_low_add1;
	int cal_gen_cur_high_mul0;
	int cal_gen_cur_high_add0;
	int cal_gen_cur_high_mul1;
	int cal_gen_cur_high_add1;
	int cal_mes_cur_low_mul0;
	int cal_mes_cur_low_add0;
	int cal_mes_cur_low_mul1;
	int cal_mes_cur_low_add1;
	int cal_mes_cur_high_mul0;
	int cal_mes_cur_high_add0;
	int cal_mes_cur_high_mul1;
	int cal_mes_cur_high_add1;
	int cal_mes_vlt_low_mul0;
	int cal_mes_vlt_low_add0;
	int cal_mes_vlt_low_mul1;
	int cal_mes_vlt_low_add1;
	int cal_mes_vlt_high_mul0;
	int cal_mes_vlt_high_add0;
	int cal_mes_vlt_high_mul1;
	int cal_mes_vlt_high_add1;
	int cal_set_cnv_pot_mul;
	int cal_set_cnv_pot_add;
	int cal_mes_tmp_cnv_mul;
	int cal_mes_tmp_cnv_add;
	int cal_mes_tmp_drv_mul;
	int cal_mes_tmp_drv_add;
	int cal_mes_tmp_rem_mul0;
	int cal_mes_tmp_rem_add0;
	int cal_mes_tmp_rem_mul1;
	int cal_mes_tmp_rem_add1;
	int cal_mes_vlt_sup_mul;
	int cal_mes_vlt_sup_add;
	int cal_mes_vlt_cnv_mul;
	int cal_mes_vlt_cnv_add;
	int cal_mes_vlt_drv_mul;
	int cal_mes_vlt_drv_add;
	int cal_mes_cur_sup_mul;
	int cal_mes_cur_sup_add;
	int cal_mes_cur_cnv_mul;
	int cal_mes_cur_cnv_add;
	int cal_unlock_code0;
	int cal_unlock_code1;
}
ltdve2ch_reg_wr_t;

#define LTDVE2CH_FILE_MAGIC0 (0x76543210)
#define LTDVE2CH_FILE_MAGIC1 (0x0000000A)

/* data stored in disk file */
typedef struct {
	int magic0;
	int magic1;
	int osc_period;
	int filter_sel0;
	int filter_sel1;
	int input_sel0;
	int input_sel1;
	int input_sel2;
	int input_sel3;
	int gen_dly_base0;
	int gen_dly_cnt0;
	int gen_wdt_base0;
	int gen_wdt_cnt0;
	int gen_dly_base1;
	int gen_dly_cnt1;
	int gen_wdt_base1;
	int gen_wdt_cnt1;
	int gen_dly_base2;
	int gen_dly_cnt2;
	int gen_wdt_base2;
	int gen_wdt_cnt2;
	int gen_dly_base3;
	int gen_dly_cnt3;
	int gen_wdt_base3;
	int gen_wdt_cnt3;
	int output_sel_hi0;
	int output_sel_lo0;
	int output_sel_hi1;
	int output_sel_lo1;
	int output_sel_hi8;
	int output_sel_lo8;
	int output_sel_hi9;
	int output_sel_lo9;
	int prt_cnt_on0;
	int prt_ena_on0;
	int prt_cnt_off0;
	int prt_ena_off0;
	int prt_cnt_on1;
	int prt_ena_on1;
	int prt_cnt_off1;
	int prt_ena_off1;
	int cur_range0;
	int cur_value0;
	int cur_range1;
	int cur_value1;
	int rs485_modbus_addr;
	int rs485_line_speed;
	int rs485_line_parity;
	int eth_mac_addr0;
	int eth_mac_addr1;
	int eth_mac_addr2;
	int eth_hostname0;
	int eth_hostname1;
	int eth_hostname2;
	int eth_hostname3;
	int eth_hostname4;
	int eth_hostname5;
	int eth_hostname6;
	int eth_hostname7;
	int eth_dhcp_enable;
	int eth_ip_addr_hi;
	int eth_ip_addr_lo;
	int eth_subnet_mask_hi;
	int eth_subnet_mask_lo;
	int eth_def_gateway_hi;
	int eth_def_gateway_lo;
	int eth_pri_dns_hi;
	int eth_pri_dns_lo;
	int eth_sec_dns_hi;
	int eth_sec_dns_lo;
	int eth_modbus_addr;
	int eth_modbus_tcp_port;
	int eth_modbus_udp_port;
	int web_password0;
	int web_password1;
	int web_password2;
	int web_password3;
	int gen_hld_base0;
	int gen_hld_cnt0;
	int gen_hld_base1;
	int gen_hld_cnt1;
	int gen_hld_base2;
	int gen_hld_cnt2;
	int gen_hld_base3;
	int gen_hld_cnt3;
	int gen_edge_sel0;
	int gen_edge_sel1;
	int gen_edge_sel2;
	int gen_edge_sel3;
	int cur_red_delay0;
	int cur_red_value0;
	int cur_red_delay1;
	int cur_red_value1;
	int software_trigger;
	int converter_mode;
	int converter_maximum_voltage;
	int driver_mode;
	int cal_gen_cur_low_mul0;
	int cal_gen_cur_low_add0;
	int cal_gen_cur_low_mul1;
	int cal_gen_cur_low_add1;
	int cal_gen_cur_high_mul0;
	int cal_gen_cur_high_add0;
	int cal_gen_cur_high_mul1;
	int cal_gen_cur_high_add1;
	int cal_mes_cur_low_mul0;
	int cal_mes_cur_low_add0;
	int cal_mes_cur_low_mul1;
	int cal_mes_cur_low_add1;
	int cal_mes_cur_high_mul0;
	int cal_mes_cur_high_add0;
	int cal_mes_cur_high_mul1;
	int cal_mes_cur_high_add1;
	int cal_mes_vlt_low_mul0;
	int cal_mes_vlt_low_add0;
	int cal_mes_vlt_low_mul1;
	int cal_mes_vlt_low_add1;
	int cal_mes_vlt_high_mul0;
	int cal_mes_vlt_high_add0;
	int cal_mes_vlt_high_mul1;
	int cal_mes_vlt_high_add1;
	int cal_set_cnv_pot_mul;
	int cal_set_cnv_pot_add;
	int cal_mes_tmp_cnv_mul;
	int cal_mes_tmp_cnv_add;
	int cal_mes_tmp_drv_mul;
	int cal_mes_tmp_drv_add;
	int cal_mes_tmp_rem_mul0;
	int cal_mes_tmp_rem_add0;
	int cal_mes_tmp_rem_mul1;
	int cal_mes_tmp_rem_add1;
	int cal_mes_vlt_sup_mul;
	int cal_mes_vlt_sup_add;
	int cal_mes_vlt_cnv_mul;
	int cal_mes_vlt_cnv_add;
	int cal_mes_vlt_drv_mul;
	int cal_mes_vlt_drv_add;
	int cal_mes_cur_sup_mul;
	int cal_mes_cur_sup_add;
	int cal_mes_cur_cnv_mul;
	int cal_mes_cur_cnv_add;
	int cal_unlock_code0;
	int cal_unlock_code1;
}
ltdve2ch_reg_file_t;

/* read all the general purpose registers */
int ltdve2ch_gen_reg_rd(modbus_t *p_modbus, ltdve2ch_reg_rd_t *p_reg, int print, int read_all_regs);

/* write all the general purpose registers */
int ltdve2ch_gen_reg_wr(modbus_t *p_modbus, ltdve2ch_reg_wr_t *p_reg, int print, int write_cal_regs);

/* write the board command register */
int ltdve2ch_brd_cmd_wr(modbus_t *p_modbus, int reg_val);

/* file ends here */
