/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#define FORCE_RANGE(v, a, b) ((v) < (a) ? (a) : ((v) > (b) ? (b) : (v)))

/* register file */
#define LTDV6CH_ADR_INP_FLT0	(0)
#define LTDV6CH_ADR_INP_FLT1	(1)
#define LTDV6CH_ADR_INP_FLT2	(2)
#define LTDV6CH_ADR_INP_FLT3	(3)
#define LTDV6CH_ADR_INP_SEL0	(4)
#define LTDV6CH_ADR_INP_SEL1	(5)
#define LTDV6CH_ADR_INP_SEL2	(6)
#define LTDV6CH_ADR_INP_SEL3	(7)
#define LTDV6CH_ADR_INP_SEL4	(8)
#define LTDV6CH_ADR_INP_SEL5	(9)
#define LTDV6CH_ADR_INP_SEL6	(10)
#define LTDV6CH_ADR_INP_SEL7	(11)
#define LTDV6CH_ADR_GEN_DELAY0	(12)
#define LTDV6CH_ADR_GEN_PULSE0	(13)
#define LTDV6CH_ADR_GEN_DELAY1	(14)
#define LTDV6CH_ADR_GEN_PULSE1	(15)
#define LTDV6CH_ADR_GEN_DELAY2	(16)
#define LTDV6CH_ADR_GEN_PULSE2	(17)
#define LTDV6CH_ADR_GEN_DELAY3	(18)
#define LTDV6CH_ADR_GEN_PULSE3	(19)
#define LTDV6CH_ADR_GEN_DELAY4	(20)
#define LTDV6CH_ADR_GEN_PULSE4	(21)
#define LTDV6CH_ADR_GEN_DELAY5	(22)
#define LTDV6CH_ADR_GEN_PULSE5	(23)
#define LTDV6CH_ADR_GEN_DELAY6	(24)
#define LTDV6CH_ADR_GEN_PULSE6	(25)
#define LTDV6CH_ADR_GEN_DELAY7	(26)
#define LTDV6CH_ADR_GEN_PULSE7	(27)
#define LTDV6CH_ADR_OUT_SEL0	(28)
#define LTDV6CH_ADR_OUT_SEL1	(29)
#define LTDV6CH_ADR_OUT_SEL2	(30)
#define LTDV6CH_ADR_OUT_SEL3	(31)
#define LTDV6CH_ADR_OUT_SEL4	(32)
#define LTDV6CH_ADR_OUT_SEL5	(33)
#define LTDV6CH_ADR_OUT_SEL6	(34)
#define LTDV6CH_ADR_OUT_SEL7	(35)
#define LTDV6CH_ADR_CUR_SET0	(36)
#define LTDV6CH_ADR_CUR_SET1	(37)
#define LTDV6CH_ADR_CUR_SET2	(38)
#define LTDV6CH_ADR_CUR_SET3	(39)
#define LTDV6CH_ADR_CUR_SET4	(40)
#define LTDV6CH_ADR_CUR_SET5	(41)
#define LTDV6CH_ADR_TON_MAX		(48)
#define LTDV6CH_ADR_TOFF_MIN	(49)
#define LTDV6CH_ADR_DRN_VOL0	(50)
#define LTDV6CH_ADR_DRN_VOL1	(51)
#define LTDV6CH_ADR_DRN_VOL2	(52)
#define LTDV6CH_ADR_DRN_VOL3	(53)
#define LTDV6CH_ADR_DRN_VOL4	(54)
#define LTDV6CH_ADR_DRN_VOL5	(55)
#define LTDV6CH_ADR_DIP_CFG		(57)
#define LTDV6CH_ADR_ERR_FLG		(58)
#define LTDV6CH_ADR_BRD_TMP		(59)
#define LTDV6CH_ADR_MCU_VER		(60)
#define LTDV6CH_ADR_DEV_TYPE	(61)
#define LTDV6CH_ADR_FPGA_VER	(62)
#define LTDV6CH_ADR_BRD_CMD		(63)

/* general purpose read registers */
typedef struct {
    int inp_flt0;
	int inp_flt1;
	int inp_flt2;
	int inp_flt3;
	int inp_sel0;
	int inp_sel1;
	int inp_sel2;
	int inp_sel3;
	int inp_sel4;
	int inp_sel5;
	int inp_sel6;
	int inp_sel7;
	int gen_delay0;
	int gen_pulse0;
	int gen_delay1;
	int gen_pulse1;
	int gen_delay2;
	int gen_pulse2;
	int gen_delay3;
	int gen_pulse3;
	int gen_delay4;
	int gen_pulse4;
	int gen_delay5;
	int gen_pulse5;
	int gen_delay6;
	int gen_pulse6;
	int gen_delay7;
	int gen_pulse7;
	int out_sel0;
	int out_sel1;
	int out_sel2;
	int out_sel3;
	int out_sel4;
	int out_sel5;
	int out_sel6;
	int out_sel7;
	int cur_set0;
	int cur_set1;
	int cur_set2;
	int cur_set3;
	int cur_set4;
	int cur_set5;
	int ton_max;
	int toff_min;
	int drn_vol0;
	int drn_vol1;
	int drn_vol2;
	int drn_vol3;
	int drn_vol4;
	int drn_vol5;
	int dip_cfg;
	int err_flg;
	int brd_tmp;
	int mcu_ver;
	int dev_type;
	int fpga_ver;
}
ltdv6ch_reg_rd_t;

/* general purpose write registers */
typedef struct {
	int inp_flt0;
	int inp_flt1;
	int inp_flt2;
	int inp_flt3;
	int inp_sel0;
	int inp_sel1;
	int inp_sel2;
	int inp_sel3;
	int inp_sel4;
	int inp_sel5;
	int inp_sel6;
	int inp_sel7;
	int gen_delay0;
	int gen_pulse0;
	int gen_delay1;
	int gen_pulse1;
	int gen_delay2;
	int gen_pulse2;
	int gen_delay3;
	int gen_pulse3;
	int gen_delay4;
	int gen_pulse4;
	int gen_delay5;
	int gen_pulse5;
	int gen_delay6;
	int gen_pulse6;
	int gen_delay7;
	int gen_pulse7;
	int out_sel0;
	int out_sel1;
	int out_sel2;
	int out_sel3;
	int out_sel4;
	int out_sel5;
	int out_sel6;
	int out_sel7;
	int cur_set0;
	int cur_set1;
	int cur_set2;
	int cur_set3;
	int cur_set4;
	int cur_set5;
	int ton_max;
	int toff_min;
}
ltdv6ch_reg_wr_t;

#define LTDV6CH_FILE_MAGIC0 (0x76543210)
#define LTDV6CH_FILE_MAGIC1 (0x00000006)

/* data stored in disk file */
typedef struct {
	int magic0;
	int magic1;
	int inp_flt0;
	int inp_flt1;
	int inp_flt2;
	int inp_flt3;
	int inp_sel0;
	int inp_sel1;
	int inp_sel2;
	int inp_sel3;
	int inp_sel4;
	int inp_sel5;
	int inp_sel6;
	int inp_sel7;
	int gen_delay0;
	int gen_pulse0;
	int gen_delay1;
	int gen_pulse1;
	int gen_delay2;
	int gen_pulse2;
	int gen_delay3;
	int gen_pulse3;
	int gen_delay4;
	int gen_pulse4;
	int gen_delay5;
	int gen_pulse5;
	int gen_delay6;
	int gen_pulse6;
	int gen_delay7;
	int gen_pulse7;
	int out_sel0;
	int out_sel1;
	int out_sel2;
	int out_sel3;
	int out_sel4;
	int out_sel5;
	int out_sel6;
	int out_sel7;
	int cur_set0;
	int cur_set1;
	int cur_set2;
	int cur_set3;
	int cur_set4;
	int cur_set5;
	int ton_max;
	int toff_min;
}
ltdv6ch_reg_file_t;

/* read all the general purpose registers */
int ltdv6ch_gen_reg_rd(modbus_t *p_modbus, ltdv6ch_reg_rd_t *p_reg, int print);

/* write all the general purpose registers */
int ltdv6ch_gen_reg_wr(modbus_t *p_modbus, ltdv6ch_reg_wr_t *p_reg, int print);

/* write the board command register */
int ltdv6ch_brd_cmd_wr(modbus_t *p_modbus, int reg_val);

/* file ends here */
