/*
 * DISCLAIMER AND LIMITATION OF LIABILITY: Opto Engineering does not make or
 * give any representation or warranty with respect to the usefulness or the
 * efficiency of this software, it being understood that the degree of success
 * with which equipment, software, modifications, and other materials can be
 * applied to data processing is dependent upon many factors, many of which
 * are not under Opto Engineering's control.  ACCORDINGLY, THIS SOFTWARE IS
 * PROVIDED 'AS IS' WITHOUT EXPRESS OR IMPLIED WARRANTIES, INCLUDING NO
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NONINFRINGEMENT.  THIS SOFTWARE IS PROVIDED GRATUITOUSLY AND, ACCORDINGLY,
 * OPTO ENGINEERING SHALL NOT BE LIABLE UNDER ANY THEORY FOR ANY DAMAGES
 * SUFFERED BY YOU OR ANY USER OF THE SOFTWARE.  OPTO ENGINEERING WILL NOT
 * SUPPORT THIS SOFTWARE AND IS UNDER NO OBLIGATION TO ISSUE UPDATES TO THIS
 * SOFTWARE.
 *
 * WITHOUT LIMITING THE GENERALITY OF THE FOREGOING, NEITHER OPTO ENGINEERING
 * NOR ITS SUPPLIERS SHALL BE LIABLE FOR (a) INCIDENTAL, CONSEQUENTIAL,
 * SPECIAL OR INDIRECT DAMAGES OF ANY SORT, WHETHER ARISING IN TORT, CONTRACT
 * OR OTHERWISE, EVEN IF OPTO ENGINEERING HAS BEEN INFORMED OF THE POSSIBILITY
 * OF SUCH DAMAGES, OR (b) FOR ANY CLAIM BY ANY OTHER PARTY.  SOME STATES DO
 * NOT ALLOW THE EXCLUSION OR LIMITATION OF INCIDENTAL OR CONSEQUENTIAL
 * DAMAGES, SO THIS LIMITATION AND EXCLUSION MAY NOT APPLY TO YOU.
 *
 * Written with Microsoft Visual C++ 2013 Express.
 *
 * Date: 25 APR 2018 - Version: 1.0
 * Author: Sergio Sigala
 */

#include "stdafx.h"

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>

#include "modbus.h"
#include "dev_ltdv6ch.h"

/* read all the general purpose registers */
int ltdv6ch_gen_reg_rd(modbus_t *p_modbus, ltdv6ch_reg_rd_t *p_reg, int print)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_FLT0, 1, &p_reg->inp_flt0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT0\t = %d\n", p_reg->inp_flt0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_FLT1, 1, &p_reg->inp_flt1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT1\t = %d\n", p_reg->inp_flt1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_FLT2, 1, &p_reg->inp_flt2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT2\t = %d\n", p_reg->inp_flt2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_FLT3, 1, &p_reg->inp_flt3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT3\t = %d\n", p_reg->inp_flt3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL0, 1, &p_reg->inp_sel0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL0\t = %d\n", p_reg->inp_sel0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL1, 1, &p_reg->inp_sel1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL1\t = %d\n", p_reg->inp_sel1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL2, 1, &p_reg->inp_sel2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL2\t = %d\n", p_reg->inp_sel2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL3, 1, &p_reg->inp_sel3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL3\t = %d\n", p_reg->inp_sel3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL4, 1, &p_reg->inp_sel4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL4\t = %d\n", p_reg->inp_sel4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL5, 1, &p_reg->inp_sel5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL5\t = %d\n", p_reg->inp_sel5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL6, 1, &p_reg->inp_sel6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL6\t = %d\n", p_reg->inp_sel6);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_INP_SEL7, 1, &p_reg->inp_sel7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL7\t = %d\n", p_reg->inp_sel7);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY0, 1, &p_reg->gen_delay0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY0\t = %d\n", p_reg->gen_delay0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE0, 1, &p_reg->gen_pulse0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE0\t = %d\n", p_reg->gen_pulse0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY1, 1, &p_reg->gen_delay1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY1\t = %d\n", p_reg->gen_delay1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE1, 1, &p_reg->gen_pulse1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE1\t = %d\n", p_reg->gen_pulse1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY2, 1, &p_reg->gen_delay2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY2\t = %d\n", p_reg->gen_delay2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE2, 1, &p_reg->gen_pulse2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE2\t = %d\n", p_reg->gen_pulse2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY3, 1, &p_reg->gen_delay3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY3\t = %d\n", p_reg->gen_delay3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE3, 1, &p_reg->gen_pulse3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE3\t = %d\n", p_reg->gen_pulse3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY4, 1, &p_reg->gen_delay4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY4\t = %d\n", p_reg->gen_delay4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE4, 1, &p_reg->gen_pulse4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE4\t = %d\n", p_reg->gen_pulse4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY5, 1, &p_reg->gen_delay5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY5\t = %d\n", p_reg->gen_delay5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE5, 1, &p_reg->gen_pulse5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE5\t = %d\n", p_reg->gen_pulse5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY6, 1, &p_reg->gen_delay6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY6\t = %d\n", p_reg->gen_delay6);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE6, 1, &p_reg->gen_pulse6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE6\t = %d\n", p_reg->gen_pulse6);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_DELAY7, 1, &p_reg->gen_delay7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY7\t = %d\n", p_reg->gen_delay7);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_GEN_PULSE7, 1, &p_reg->gen_pulse7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE7\t = %d\n", p_reg->gen_pulse7);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL0, 1, &p_reg->out_sel0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL0\t = %d\n", p_reg->out_sel0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL1, 1, &p_reg->out_sel1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL1\t = %d\n", p_reg->out_sel1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL2, 1, &p_reg->out_sel2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL2\t = %d\n", p_reg->out_sel2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL3, 1, &p_reg->out_sel3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL3\t = %d\n", p_reg->out_sel3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL4, 1, &p_reg->out_sel4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL4\t = %d\n", p_reg->out_sel4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL5, 1, &p_reg->out_sel5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL5\t = %d\n", p_reg->out_sel5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL6, 1, &p_reg->out_sel6, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL6\t = %d\n", p_reg->out_sel6);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_OUT_SEL7, 1, &p_reg->out_sel7, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL7\t = %d\n", p_reg->out_sel7);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET0, 1, &p_reg->cur_set0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET0\t = %d\n", p_reg->cur_set0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET1, 1, &p_reg->cur_set1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET1\t = %d\n", p_reg->cur_set1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET2, 1, &p_reg->cur_set2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET2\t = %d\n", p_reg->cur_set2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET3, 1, &p_reg->cur_set3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET3\t = %d\n", p_reg->cur_set3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET4, 1, &p_reg->cur_set4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET4\t = %d\n", p_reg->cur_set4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_CUR_SET5, 1, &p_reg->cur_set5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET5\t = %d\n", p_reg->cur_set5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_TON_MAX, 1, &p_reg->ton_max, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("TON_MAX\t\t = %d\n", p_reg->ton_max);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_TOFF_MIN, 1, &p_reg->toff_min, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("TOFF_MIN\t = %d\n", p_reg->toff_min);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL0, 1, &p_reg->drn_vol0, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL0\t = %d\n", p_reg->drn_vol0);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL1, 1, &p_reg->drn_vol1, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL1\t = %d\n", p_reg->drn_vol1);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL2, 1, &p_reg->drn_vol2, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL2\t = %d\n", p_reg->drn_vol2);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL3, 1, &p_reg->drn_vol3, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL3\t = %d\n", p_reg->drn_vol3);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL4, 1, &p_reg->drn_vol4, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL4\t = %d\n", p_reg->drn_vol4);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DRN_VOL5, 1, &p_reg->drn_vol5, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DRN_VOL5\t = %d\n", p_reg->drn_vol5);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DIP_CFG, 1, &p_reg->dip_cfg, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DIP_CFG\t\t = %d\n", p_reg->dip_cfg);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_ERR_FLG, 1, &p_reg->err_flg, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("ERR_FLG\t\t = 0x%X\n", p_reg->err_flg);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_BRD_TMP, 1, &p_reg->brd_tmp, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("BRD_TMP\t\t = %d\n", p_reg->brd_tmp);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_MCU_VER, 1, &p_reg->mcu_ver, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("MCU_VER\t\t = 0x%X\n", p_reg->mcu_ver);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_DEV_TYPE, 1, &p_reg->dev_type, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("DEV_TYPE\t = %d\n", p_reg->dev_type);

	if ((err = modbus_reg_rd_group(p_modbus, LTDV6CH_ADR_FPGA_VER, 1, &p_reg->fpga_ver, 0)) != 0) {
		printf("error in modbus_reg_rd_group() call\n");
		goto exit;
	}
	if (print) printf("FPGA_VER\t = 0x%X\n", p_reg->fpga_ver);

exit:
	return err;
}

/* write all the general purpose registers */
int ltdv6ch_gen_reg_wr(modbus_t *p_modbus, ltdv6ch_reg_wr_t *p_reg, int print)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (p_reg == NULL) { err = 1; printf("bad parameter p_reg\n"); goto exit; }

	p_reg->inp_flt0 = FORCE_RANGE(p_reg->inp_flt0, 0, 6);
    p_reg->inp_flt1 = FORCE_RANGE(p_reg->inp_flt1, 0, 6);
    p_reg->inp_flt2 = FORCE_RANGE(p_reg->inp_flt2, 0, 6);
    p_reg->inp_flt3 = FORCE_RANGE(p_reg->inp_flt3, 0, 6);
    p_reg->inp_sel0 = FORCE_RANGE(p_reg->inp_sel0, 0, 31);
    p_reg->inp_sel1 = FORCE_RANGE(p_reg->inp_sel1, 0, 31);
    p_reg->inp_sel2 = FORCE_RANGE(p_reg->inp_sel2, 0, 31);
    p_reg->inp_sel3 = FORCE_RANGE(p_reg->inp_sel3, 0, 31);
    p_reg->inp_sel4 = FORCE_RANGE(p_reg->inp_sel4, 0, 31);
    p_reg->inp_sel5 = FORCE_RANGE(p_reg->inp_sel5, 0, 31);
    p_reg->inp_sel6 = FORCE_RANGE(p_reg->inp_sel6, 0, 31);
    p_reg->inp_sel7 = FORCE_RANGE(p_reg->inp_sel7, 0, 31);
    p_reg->gen_delay0 = FORCE_RANGE(p_reg->gen_delay0, 0, 65535);
    p_reg->gen_pulse0 = FORCE_RANGE(p_reg->gen_pulse0, 10, 65535);
    p_reg->gen_delay1 = FORCE_RANGE(p_reg->gen_delay1, 0, 65535);
    p_reg->gen_pulse1 = FORCE_RANGE(p_reg->gen_pulse1, 10, 65535);
    p_reg->gen_delay2 = FORCE_RANGE(p_reg->gen_delay2, 0, 65535);
    p_reg->gen_pulse2 = FORCE_RANGE(p_reg->gen_pulse2, 10, 65535);
    p_reg->gen_delay3 = FORCE_RANGE(p_reg->gen_delay3, 0, 65535);
    p_reg->gen_pulse3 = FORCE_RANGE(p_reg->gen_pulse3, 10, 65535);
    p_reg->gen_delay4 = FORCE_RANGE(p_reg->gen_delay4, 0, 65535);
    p_reg->gen_pulse4 = FORCE_RANGE(p_reg->gen_pulse4, 10, 65535);
    p_reg->gen_delay5 = FORCE_RANGE(p_reg->gen_delay5, 0, 65535);
    p_reg->gen_pulse5 = FORCE_RANGE(p_reg->gen_pulse5, 10, 65535);
    p_reg->gen_delay6 = FORCE_RANGE(p_reg->gen_delay6, 0, 65535);
    p_reg->gen_pulse6 = FORCE_RANGE(p_reg->gen_pulse6, 10, 65535);
    p_reg->gen_delay7 = FORCE_RANGE(p_reg->gen_delay7, 0, 65535);
    p_reg->gen_pulse7 = FORCE_RANGE(p_reg->gen_pulse7, 10, 65535);
	p_reg->out_sel0 = FORCE_RANGE(p_reg->out_sel0, 0, 8191);
    p_reg->out_sel1 = FORCE_RANGE(p_reg->out_sel1, 0, 8191);
    p_reg->out_sel2 = FORCE_RANGE(p_reg->out_sel2, 0, 8191);
    p_reg->out_sel3 = FORCE_RANGE(p_reg->out_sel3, 0, 8191);
    p_reg->out_sel4 = FORCE_RANGE(p_reg->out_sel4, 0, 8191);
    p_reg->out_sel5 = FORCE_RANGE(p_reg->out_sel5, 0, 8191);
	p_reg->out_sel6 = FORCE_RANGE(p_reg->out_sel6, 0, 4095);
    p_reg->out_sel7 = FORCE_RANGE(p_reg->out_sel7, 0, 4095);
	p_reg->cur_set0 = FORCE_RANGE(p_reg->cur_set0, 35, 175);
    p_reg->cur_set1 = FORCE_RANGE(p_reg->cur_set1, 35, 175);
    p_reg->cur_set2 = FORCE_RANGE(p_reg->cur_set2, 35, 175);
    p_reg->cur_set3 = FORCE_RANGE(p_reg->cur_set3, 35, 175);
    p_reg->cur_set4 = FORCE_RANGE(p_reg->cur_set4, 35, 175);
    p_reg->cur_set5 = FORCE_RANGE(p_reg->cur_set5, 35, 175);
    p_reg->ton_max = FORCE_RANGE(p_reg->ton_max, 1, 255);
    p_reg->toff_min = FORCE_RANGE(p_reg->toff_min, 1, 255);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_FLT0, 1, &p_reg->inp_flt0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT0\t = %d\n", p_reg->inp_flt0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_FLT1, 1, &p_reg->inp_flt1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT1\t = %d\n", p_reg->inp_flt1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_FLT2, 1, &p_reg->inp_flt2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT2\t = %d\n", p_reg->inp_flt2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_FLT3, 1, &p_reg->inp_flt3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_FLT3\t = %d\n", p_reg->inp_flt3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL0, 1, &p_reg->inp_sel0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL0\t = %d\n", p_reg->inp_sel0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL1, 1, &p_reg->inp_sel1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL1\t = %d\n", p_reg->inp_sel1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL2, 1, &p_reg->inp_sel2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL2\t = %d\n", p_reg->inp_sel2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL3, 1, &p_reg->inp_sel3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL3\t = %d\n", p_reg->inp_sel3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL4, 1, &p_reg->inp_sel4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL4\t = %d\n", p_reg->inp_sel4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL5, 1, &p_reg->inp_sel5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL5\t = %d\n", p_reg->inp_sel5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL6, 1, &p_reg->inp_sel6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL6\t = %d\n", p_reg->inp_sel6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_INP_SEL7, 1, &p_reg->inp_sel7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("INP_SEL7\t = %d\n", p_reg->inp_sel7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY0, 1, &p_reg->gen_delay0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY0\t = %d\n", p_reg->gen_delay0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE0, 1, &p_reg->gen_pulse0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE0\t = %d\n", p_reg->gen_pulse0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY1, 1, &p_reg->gen_delay1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY1\t = %d\n", p_reg->gen_delay1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE1, 1, &p_reg->gen_pulse1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE1\t = %d\n", p_reg->gen_pulse1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY2, 1, &p_reg->gen_delay2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY2\t = %d\n", p_reg->gen_delay2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE2, 1, &p_reg->gen_pulse2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE2\t = %d\n", p_reg->gen_pulse2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY3, 1, &p_reg->gen_delay3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY3\t = %d\n", p_reg->gen_delay3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE3, 1, &p_reg->gen_pulse3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE3\t = %d\n", p_reg->gen_pulse3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY4, 1, &p_reg->gen_delay4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY4\t = %d\n", p_reg->gen_delay4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE4, 1, &p_reg->gen_pulse4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE4\t = %d\n", p_reg->gen_pulse4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY5, 1, &p_reg->gen_delay5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY5\t = %d\n", p_reg->gen_delay5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE5, 1, &p_reg->gen_pulse5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE5\t = %d\n", p_reg->gen_pulse5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY6, 1, &p_reg->gen_delay6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY6\t = %d\n", p_reg->gen_delay6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE6, 1, &p_reg->gen_pulse6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE6\t = %d\n", p_reg->gen_pulse6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_DELAY7, 1, &p_reg->gen_delay7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_DELAY7\t = %d\n", p_reg->gen_delay7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_GEN_PULSE7, 1, &p_reg->gen_pulse7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("GEN_PULSE7\t = %d\n", p_reg->gen_pulse7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL0, 1, &p_reg->out_sel0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL0\t = %d\n", p_reg->out_sel0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL1, 1, &p_reg->out_sel1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL1\t = %d\n", p_reg->out_sel1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL2, 1, &p_reg->out_sel2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL2\t = %d\n", p_reg->out_sel2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL3, 1, &p_reg->out_sel3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL3\t = %d\n", p_reg->out_sel3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL4, 1, &p_reg->out_sel4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL4\t = %d\n", p_reg->out_sel4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL5, 1, &p_reg->out_sel5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL5\t = %d\n", p_reg->out_sel5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL6, 1, &p_reg->out_sel6)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL6\t = %d\n", p_reg->out_sel6);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_OUT_SEL7, 1, &p_reg->out_sel7)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("OUT_SEL7\t = %d\n", p_reg->out_sel7);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET0, 1, &p_reg->cur_set0)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET0\t = %d\n", p_reg->cur_set0);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET1, 1, &p_reg->cur_set1)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET1\t = %d\n", p_reg->cur_set1);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET2, 1, &p_reg->cur_set2)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET2\t = %d\n", p_reg->cur_set2);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET3, 1, &p_reg->cur_set3)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET3\t = %d\n", p_reg->cur_set3);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET4, 1, &p_reg->cur_set4)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET4\t = %d\n", p_reg->cur_set4);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_CUR_SET5, 1, &p_reg->cur_set5)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("CUR_SET5\t = %d\n", p_reg->cur_set5);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_TON_MAX, 1, &p_reg->ton_max)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("TON_MAX\t\t = %d\n", p_reg->ton_max);

	if ((err = modbus_reg_wr_group(p_modbus, LTDV6CH_ADR_TOFF_MIN, 1, &p_reg->toff_min)) != 0) {
		printf("error in modbus_reg_wr_group() call\n");
		goto exit;
	}
	if (print) printf("TOFF_MIN\t = %d\n", p_reg->toff_min);

exit:
	return err;
}

/* write the board command register */
int ltdv6ch_brd_cmd_wr(modbus_t *p_modbus, int reg_val)
{
	int err = 0;

	if (p_modbus == NULL) { err = 1; printf("bad parameter p_modbus\n"); goto exit; }
	if (reg_val < 0) { err = 1; printf("bad parameter reg_val\n"); goto exit; }
	if (reg_val > 3) { err = 1; printf("bad parameter reg_val\n"); goto exit; }

	if ((err = modbus_reg_wr_single(p_modbus, LTDV6CH_ADR_BRD_CMD, reg_val)) != 0) {
		printf("error in modbus_reg_wr_single() call\n");
		goto exit;
	}

exit:
	return err;
}

/* file ends here */
